define("tc/calendar-reset-url-dialog",
    [
        "jquery",
        "underscore",
        "tc-backbone",
        "tc/templates",
        "tc/calendar-util",
        "tc/util"
    ], function
        (
            $,
            _,
            Backbone,
            Templates,
            CalUtil,
            Util
        )
    {
        "use strict";
        var ResetUrlSubCalendarDialog = Backbone.View.extend({
            resetUrlSubCalendarDialog : null,
            _calendarDiv: null,
            _calendarPlugin : null,
            _subCalendar: null,
            _subCalendars: null,
            initialize: function(options){
                this._calendarDiv = options.calendarDiv;
                this._calendarPlugin = options.calendarPlugin;
                this._subCalendar = options.subCalendar;
                this._subCalendars = options.subCalendars;

                this.resetUrlSubCalendarDialog = $('#calendar-reset-private-urls-dialog');
            },
            render: function() {
                var that = this;
                if (this.resetUrlSubCalendarDialog) {
                    this.resetUrlSubCalendarDialog.remove();
                }

                var resetPrivateUrlsDialog = new AJS.Dialog({
                        width: 512,
                        height: 250,
                        id: "calendar-reset-private-urls-dialog"
                    }),
                    closeDialog = function() {
                        resetPrivateUrlsDialog.hide();
                        resetPrivateUrlsDialog.remove();
                    };

                resetPrivateUrlsDialog.addHeader(AJS.I18n.getText("calendar3.privateurl.reset.title"));
                resetPrivateUrlsDialog.addPanel("", Templates.resetSubCalendarPrivateUrl(), "calendar-private-url-reset-dialog-panel");

                var resetPrivateUrlsDialogBody =  resetPrivateUrlsDialog.getCurrentPanel().body;
                resetPrivateUrlsDialog.addButton(AJS.I18n.getText("calendar3.privateurl.reset.button.label"), function() {
                    var spinnerDefer = that._calendarPlugin.setSubCalendarSpinnerIconVisible(true);

                    var resetProgress = $(".reset-progress", resetPrivateUrlsDialogBody).addClass("reset-in-progress");
                    var resetButton = $("#calendar-reset-private-urls-dialog .subcalendar-private-url-reset-button").prop("disabled", true);

                    $.ajax({
                        cache: false,
                        success: function() {
                            resetProgress.removeClass("reset-in-progress").addClass("reset-done");
                            $("#calendar-reset-private-urls-dialog .reset-cancel").text(AJS.I18n.getText("close.name"));
                            resetButton.prop("disabled", false);
                        },
                        type: "PUT",
                        timeout : CalUtil.ajaxTimeout,
                        url: that._calendarPlugin.getCalendarServiceBaseUrl(that._calendarDiv, "/subcalendar/privateurl/reset/" + encodeURIComponent(that._subCalendar.id)),
                        error: function(XMLHttpRequest, textStatus, errorThrown) {
                            resetButton.prop("disabled", false);
                            CalUtil.showAjaxError(that._calendarDiv, XMLHttpRequest, textStatus, errorThrown,
                                that._calendarPlugin.ERROR_CLASS_RESET_PRIVATE_URLS);
                        },
                        complete: function(){
                            if(spinnerDefer) spinnerDefer.resolve();
                        }
                    });
                }, "subcalendar-private-url-reset-button");
                resetPrivateUrlsDialog.addLink(AJS.I18n.getText("cancel.name"), function() {
                    closeDialog();
                    return false;
                }, "reset-cancel");

                $(".calendar-title", resetPrivateUrlsDialogBody).text(that._subCalendar.name);
                $(".subscribe-to-calendar", resetPrivateUrlsDialogBody).click(function() {
                    closeDialog();
                    that._calendarPlugin.getCalendarSubscribeDialog(that._calendarDiv, that._subCalendars, that._subCalendar);
                    return false;
                });
                resetPrivateUrlsDialog.show();

                return resetPrivateUrlsDialog;
            }

        });

        return ResetUrlSubCalendarDialog;
    });