define("tc/calendar-share-dialog",
    [
        "jquery",
        "underscore",
        "tc-backbone",
        "tc/templates",
        "tc/calendar-util"
    ], function
        (
            $,
            _,
            Backbone,
            Templates,
            CalUtil
            )
    {
        "use strict";
        var ShareCalendarDialog = Backbone.View.extend({
            _calendarDiv: null,
            subCalendar: null,
            _calendarPlugin : null,
            editDialog: null,
            initialize: function(options){
                this._calendarDiv = options._calendarDiv;
                this.subCalendar = options.subCalendar;
                this._calendarPlugin = options._calendarPlugin;

                this.editDialog = options.editDialog;
                this.$el.html(Templates.shareSubCalendar({ "elementIdSuffix" : CalUtil.getParameter(this._calendarDiv, "elementIdSuffix") }));
                this.editDialog.addPanel(AJS.I18n.getText("calendar3.shareorembed"), this.$el, "calendar-share-dialog-panel");
            },
            render: function() {
                var that = this;

                var isSubCalendarRestricted = this._calendarPlugin.doesSubCalendarHaveRestrictions(that.subCalendar),
                    dialogBody,
                    restrictionsLink;

                dialogBody = that.editDialog.getCurrentPanel().body;
                restrictionsLink = $(".share-restrictions-link", dialogBody);

                var link = "";

                if (that.subCalendar.spaceKey) {
                    link = AJS.format("{0}/display/{1}/calendar/{2}?calendarName={3}",
                            CalUtil.getParameter(that._calendarDiv, "baseUrl"),
                            encodeURIComponent(that.subCalendar.spaceKey),
                            encodeURIComponent(that.subCalendar.subscriptionId || that.subCalendar.id),
                            encodeURIComponent(that.subCalendar.name));
                } else {
                    link = AJS.format("{0}/calendar/previewcalendar.action?subCalendarId={1}",
                            CalUtil.getParameter(that._calendarDiv, "baseUrl"),
                            encodeURIComponent(that.subCalendar.subscriptionId || that.subCalendar.id));
                }

                $(".share-address-field", this.editDialog.getCurrentPanel().body).val(link);

                if (isSubCalendarRestricted) {
                    if (that._calendarPlugin.isSubCalendarAdministratable(that._calendarDiv, that.subCalendar)) {
                        restrictionsLink.click(function() {
                            that.editDialog.hide();
                            that._calendarPlugin.getSubCalendarRestrictionsDialog(that._calendarDiv, that.subCalendar).show();
                        });
                    } else {
                        restrictionsLink.addClass("hidden");
                    }
                } else {
                    $(".description", dialogBody).addClass("hidden");
                    var autoConvertMessage = $(".autoconvert", dialogBody);
                    if (that._calendarPlugin.isAutoConvertSupported(that._calendarDiv))
                        autoConvertMessage.removeClass("hidden");
                    else
                        autoConvertMessage.addClass("hidden");
                }

                //process behaviour when share panel active
                this.editDialog.getCurrentPanel().onselect = function() {
                    $("#edit-calendar-dialog").find(".button-panel-button.submit").addClass("hidden");
                    $(".share-address-field", that.editDialog.getCurrentPanel().body).focus().select();
                };

                return that.editDialog;
            }

        });

        return ShareCalendarDialog;
    });