define("tc/subcalendar-navigation-buttons-view",
    [
        "jquery",
        "underscore",
        "tc/calendar-util",
        "tc/util",
        "tc/calendar-add-dropdown",
        "tc-backbone",
        "confluence/share-page/service/share-page",
        "confluence/api/logger"
    ],
    function (
        $,
        _,
        CalUtil,
        Util,
        CalendarAddDropdownView,
        Backbone,
        SharePage,
        logger
    ) {

        var CalendarNavigationButtonsView = Backbone.View.extend({
            events: {
                "click .edit-calendar-button, #editCalendarLink" : "_onEditButtonClick",
                "click .add-calendar-button" : "_onAddButtonClick"
            },

            initialize: function(options) {
                this._calendarDiv = options._calendarDiv;
                this.CalendarPlugin = options.CalendarPlugin;

                AJS.bind("calendar.loaded", _.bind(this._onCalendarLoaded, this));
                AJS.bind("calendar.removed", _.bind(this._onCalendarRemoved, this));
                AJS.bind("calendar.watch.statuses.loaded", _.bind(this._onWatchStatusLoaded, this));

                this.inlineAddCalendarDialog = new CalendarAddDropdownView({callbackHandler: this.CalendarPlugin.getRenderedMacroCallbackHandler(this._calendarDiv)});
            },

            render: function() {
                // share button
                this._initShareButton();

                if (CalUtil.isSpaceCalendarView(this._calendarDiv)) {
                    // add calendar button
                    var hasCalendar = !$(".no-calendar-page").is(":visible");
                    this.$(".add-calendar-button").toggleClass("hidden", !hasCalendar);
                    this.$(".add-calendar-button-more").toggleClass("hidden", !hasCalendar);

                } else if(CalUtil.isSingleCalendarView(this._calendarDiv)) {
                    // edit button
                    if(this.subCalendar) {
                        var editable = this.CalendarPlugin.getParameter(this._calendarDiv, "readOnly") !== "true" && this.subCalendar.editable && this.subCalendar.eventsEditable;
                        this.$(".edit-calendar-button").toggleClass("hidden", !editable);
                    }
                }

                this.inlineAddCalendarDialog.render();
            },

            _initShareButton: function() {
                var that = this;
                var selector = ".share-calendar-button";
                var $shareButton = this.$(selector);

                // There is a race condition where no-calendar-page is hidden when this function is called, but shortly after becomes visible
                var hasCalendar = !$(".no-calendar-page").is(":visible");
                var enableShareCalendar = CalUtil.getParameter(this._calendarDiv, "enableShareCalendar");

                // should not show share when users do not have permission to view calendar
                var hasViewPermission = true;
                if (this.subCalendar) {
                    hasViewPermission = this.subCalendar.eventsViewable;
                } else if (CalUtil.isSingleCalendarView(this._calendarDiv)) {
                    // Single calendar but calendar is not loaded, means the user does not have view permission
                    // Necessary to handle above mentioned race condition to ensure we don't show share button on "no calendar page"
                    hasViewPermission = false;
                }

                var showShareCalendar = hasCalendar && enableShareCalendar && hasViewPermission;
                $shareButton.toggleClass("hidden", !showShareCalendar);

                if (showShareCalendar && !this.shareDialogLoaded) {
                    var context, notePlaceholderText, headingText;
                    if (CalUtil.isSingleCalendarView(this._calendarDiv)) {
                        context = "singleCalendar";
                        notePlaceholderText = AJS.I18n.getText("calendar3.share.dialog.placeholder.single");
                        headingText = AJS.I18n.getText("calendar3.share.dialog.title.single");
                    } else if (CalUtil.isSpaceCalendarView(this._calendarDiv)) {
                        context = "spaceCalendars";
                        notePlaceholderText = AJS.I18n.getText("calendar3.share.dialog.placeholder.space");
                        headingText = AJS.I18n.getText("calendar3.share.dialog.title.space");
                    } else {
                        logger.warn("Unable to create share button: cannot share calendar from anywhere other than space calendars or single calendar")
                        return;
                    }

                    // Should always be defined, given that we ensure that we are viewing a single calendar or share calendars above
                    var contentType = CalUtil.getCustomContentType(this._calendarDiv);

                    SharePage.initDialog(selector, "shareContentPopup", {offsetX: -110}, {
                        heading: headingText,
                        notePlaceholder: notePlaceholderText,
                        copyOption: "share",
                        entityId: function () {
                            return CalUtil.getParameter(that._calendarDiv, "contentId");
                        },
                        contentType: contentType,
                        shareType: "custom",
                        errorText: AJS.I18n.getText("calendar3.share.dialog.error"),
                        beforeLoad: function () {
                            $shareButton.find(".aui-icon").css("visibility", "hidden");
                            $shareButton.spin();
                            $shareButton.find("aui-spinner").css("left", "-23px");
                        },
                        afterLoad: function () {
                            $shareButton.find(".aui-icon").css("visibility", "visible");
                            $shareButton.spinStop();
                        },
                        onShow: function () {
                            Confluence.TeamCalendars.fireEventForAnalytics("share.calendar.click." + context);
                        },
                    });
                    this.shareDialogLoaded = true;
                }
            },

            _onEditButtonClick: function(event) {
                this.CalendarPlugin.showSubCalendarEdit(this._calendarDiv, this.subCalendar);
                //process behaviour when event type panel active
                $("#edit-calendar-dialog").find(".button-panel-button.submit").removeClass("hidden");

                event.preventDefault();

                return false;
            },

            _onCalendarLoaded: function(event, subCalendar) {
                // show/hide edit button in when calendar loaded in single view
                if(CalUtil.isSingleCalendarView(this._calendarDiv)) {
                    this.subCalendar = subCalendar;
                }

                var contentId = this.CalendarPlugin.getParameter(this._calendarDiv, "contentId");
                AJS.params.pageId = contentId ? contentId : AJS.params.pageId;

                this.render();
            },

            _onCalendarRemoved: function() {
                this.render();
            },

            _onWatchStatusLoaded: function(event, watchStatues) {
                //TODO: showing watch status of calendar
            },

            _onAddButtonClick: function(event) {
                Confluence.TeamCalendars.fireEventForAnalytics(
                    "add.calendar.click",
                    {context: Confluence.TeamCalendars.getCalendarContext(), subSource: "new"}
                );
                var subCalendarDialog = Confluence.TeamCalendars.Dialogs.getSubCalendarCreateDialog("parent", this.CalendarPlugin.getRenderedMacroCallbackHandler(this._calendarDiv));
                Util.showDialogInUpdatedHeight(subCalendarDialog);
                $("input[name='name']", subCalendarDialog.getCurrentPanel().body).focus();
                $("#inline-dialog-inline-dialog-more").hide();

                event.preventDefault();

                return false;
            }
        });

        return CalendarNavigationButtonsView;
    }
);
