define("tc/subcalendar-restriction-button-view",
    [
        "jquery",
        "underscore",
        "tc/calendar-util"

    ],
    function (
        $,
        _,
        CalUtil
    ) {

        var CalendarRestrictionButtonsView = Backbone.View.extend({
            events: {
                "click .restrict-calendar-button" : "_onRestrictionClick"
            },

            initialize: function(options) {
                this._calendarDiv = options._calendarDiv;
                this.CalendarPlugin = options.CalendarPlugin;

                AJS.bind("calendar.loaded", _.bind(this._onCalendarLoaded, this));
            },

            render: function() {
                var hasRestriction = CalUtil.hasRestriction(this.subCalendar);

                this.$(".restrict-calendar-button.restricted").toggleClass("hidden", !hasRestriction);
                this.$(".restrict-calendar-button.no-restricted").toggleClass("hidden", hasRestriction);
            },

            _onRestrictionClick: function() {
                if(this.CalendarPlugin.getParameter(this._calendarDiv, "readOnly") !== "true" && this.subCalendar.administrable && !CalUtil.isJiraSubCalendar(this.subCalendar)) {
                    this.CalendarPlugin.getSubCalendarRestrictionsDialog(this._calendarDiv, this.subCalendar);
                }

                event.preventDefault();
            },

            _onCalendarLoaded: function(event, subCalendar) {
                if(CalUtil.isSingleCalendarView(this._calendarDiv)) {
                    this.subCalendar = subCalendar;
                    this.render();
                }
            }

        });

        return CalendarRestrictionButtonsView;
    }
);
