define("tc/customeventtype-edit",
    [
        "jquery",
        "underscore",
        "tc-backbone"
    ],
    function (
            $,
            _,
            Backbone
            )
    {
        "use strict";
        var CustomEventTypeEditInlineDialogView = Backbone.View.extend({
            parentCustomEventTypeDiv: null,
            mediator : null,
            isOpen: null,
            events: {
                "click input.save": "_updateCustomEventType",
                "click button.cancel": "_closeInlineDialog",
                "keydown button.cancel": "_handleCancelKeydown",
                "click .select-avatar button": "_selectIconCustomEventType",
                "keydown" : "handleKey"
            },
            initialize: function(option) {
                if(!option) {
                    return;
                }
                this.mediator = option.mediator;
                this.parentCustomEventTypeDiv = option.parentCustomEventTypeDiv;
                this.model.on("invalid", _.bind(this._handleError,this));

                // this event will trigger when new edit dialog open then we have a chance to close the previous one
                this.mediator.on("Custom-Event-Type.edit.open", _.bind(this.shouldRemoveMe, this));
                this.mediator.trigger("Custom-Event-Type.edit.open", this);
            },
            render: function() {
                // hide instructional text
                var that = this;
                var isCustomEventType = that.model.get("isCustomEvent") === true;

                $(".custom-event-type-items-instructional").addClass("hidden");
                $(that.parentCustomEventTypeDiv).addClass("hidden");

                $(that.parentCustomEventTypeDiv).after(Confluence.TeamCalendars.Templates.editCustomEventType({"title":that.model.get("title"), "icon": that.model.get("icon"), "periodInMins": that.model.get("periodInMins"), "isCustomEventType": isCustomEventType}));

                that.$editCustomEventTypeForm = $("#edit-custom-event-type-form");
                //HACK bind event for event-type-custom edit
                that.el = that.$editCustomEventTypeForm;
                that.$el = $(that.el);
                that.delegateEvents(); // this will bind all events once

                that.$editCustomEventTypeForm.find('.custom-event-title input').focus();

                this.isOpen = true;
            },

            shouldRemoveMe : function() {
                if (this.isOpen)
                {
                    this.remove();
                }
            },
            remove: function(){
                this._closeInlineDialog();
            },
            handleKey : function (e) {
                if (e.which === 13){
                    // Stop propagation to parent nodes
                    e.preventDefault();
                    e.stopPropagation();
                    this._updateCustomEventType();
                }

                if (e.which === 27){
                    e.preventDefault();
                    e.stopPropagation();
                    this._closeInlineDialog();
                }
            },
            _handleCancelKeydown : function (e) {
                // enter or space key press
                if (e.which === 13 || e.which === 32){
                    e.preventDefault();
                    e.stopPropagation();
                    this._closeInlineDialog();
                    this.parentCustomEventTypeDiv.find('.edit-eventtypes-link').focus()
                }
            },
            _closeInlineDialog: function() {
                $(this.parentCustomEventTypeDiv).removeClass("hidden");
                if (this.model.collection && this.model.collection.customEventTypes().length === 0) {
                    $(".custom-event-type-items-instructional").removeClass("hidden");
                }
                this.$editCustomEventTypeForm.remove();
            },
            _updateCustomEventType: function() {
                // hide all error messages
                this.$editCustomEventTypeForm.find(".custom_event_type_field_error").each(function(index, errorItem){
                    var $errorItem = $(errorItem);
                    if (!$errorItem.hasClass("hidden")){
                        $errorItem.addClass("hidden");
                    }
                });

                var customEventTypeTitle = this.$editCustomEventTypeForm.find('.custom-event-title input').val();
                var customEventTypeIcon = this.$editCustomEventTypeForm.find(".select-avatar button.selected span").data("icon");
                var customEventTypePeriodInMins = this.$editCustomEventTypeForm.find("#period-reminder").val();

                var oldCustomEventTypeTitle = this.model.get("title");
                var oldCustomEventTypeIcon = this.model.get("icon");
                var oldCustomEventTypePeriodInMins = this.model.get("periodInMins");

                this.model.set({
                    title : customEventTypeTitle !== undefined ? customEventTypeTitle : oldCustomEventTypeTitle,
                    icon : customEventTypeIcon !== undefined ? customEventTypeIcon: oldCustomEventTypeIcon,
                    periodInMins: customEventTypePeriodInMins
                });

                if (!this.model.isValid()){
                    this.model.set({
                        title : oldCustomEventTypeTitle,
                        icon : oldCustomEventTypeIcon,
                        periodInMins: oldCustomEventTypePeriodInMins
                    });
                    return;
                }

                // trigger event to other view to handle
                this.mediator.trigger("Custom-Event-Type.save", this.model);

                this._closeInlineDialog();
            },
            _handleError : function (model, errors){
                var that = this;
                var getErrorMessageFor = function (fieldName){
                    var fieldError = _.where(errors, {field : fieldName});
                    if(fieldError.length > 0) {
                        return fieldError[0].message;
                    }
                    return "";
                };

                // show all error messages
                this.$editCustomEventTypeForm.find(".custom_event_type_field_error").each(function(index, errorItem){
                    var $errorItem = $(errorItem);
                    var fieldName = $errorItem.data("field-name");
                    $errorItem.html(getErrorMessageFor(fieldName));
                    if ($errorItem.hasClass("hidden")){
                        $errorItem.removeClass("hidden");
                    }

                    // try to set focus when there was a error on title field
                    if (fieldName === "title") {
                        that.$editCustomEventTypeForm.find("#custom-eventtype-title").focus();
                    }
                });
            },
            _selectIconCustomEventType: function(event) {
                if( !event ) {
                    event = window.event;
                }

                // stop default link click behaviour
                event.preventDefault();
                $(".select-avatar.tc-event-type-item button").removeClass('selected');
                var target = event.target || event.srcElement;
                if (target.nodeName === "SPAN") {
                    $(target).parent().addClass('selected');
                } else {
                    $(target).addClass('selected');
                }
            }
        });
        return CustomEventTypeEditInlineDialogView;
    }
);
