define("tc/customeventtype-model",
    [
        "jquery",
        "tc-backbone"
    ],
    function (
        $,
        Backbone)
    {
        "use strict";
        var customeEventTypeModel = Backbone.Model.extend({
            defaults : function (){
                return {
                    title: "",
                    icon: "",
                    subCalendar: "",
                    disable: false,
                    isCustomEvent: false,
                    id: "",
                    created: "",
                    periodInMins: ""
                };
            },
            validate: function (attrs) {
                if (!attrs.isCustomEvent){
                    return false;
                }

                var errors = [];
                if (!attrs.title)
                {
                    errors.push({field : "title", message : AJS.I18n.getText("com.atlassian.confluence.extra.team-calendars.eventtypes.custom.missing.title")});
                }

                attrs.title = $.trim(attrs.title);
                if (attrs.title.length <= 0){
                    errors.push({field : "title", message : AJS.I18n.getText("com.atlassian.confluence.extra.team-calendars.eventtypes.custom.missing.title")});
                }else {
                    if (attrs.title.length > 256){
                        errors.push({field : "title", message : AJS.I18n.getText("com.atlassian.confluence.extra.team-calendars.eventtypes.custom.error.max.title")});
                    }
                }

                if (!attrs.icon)
                {
                    errors.push({field : "icon", message : AJS.I18n.getText("com.atlassian.confluence.extra.team-calendars.eventtypes.custom.missing.icon")});
                }

                return errors.length > 0 ? errors : false;
            },
            toggle: function() {
                this.set({disable: !this.get("disable")});
            }
        });

        return customeEventTypeModel;
    }
);