define("tc/eventtypes-edit-dialog",
    [
        "jquery",
        "underscore",
        "tc-backbone",
        "tc/dialogs",
        "tc/templates",
        "tc/customeventtype-view",
        "tc/customeventtype-edit",
        "tc/customeventtype-model",
        "tc/customeventtype-list",
        "tc/event-types"
    ], function (
        $,
        _,
        Backbone,
        Dialog,
        Templates,
        CustomEventTypeView,
        CustomEventTypeEditInlineDialogView,
        CustomeEventTypeModel,
        CustomEventTypeList,
        EventTypes)
    {
        "use strict";
        var EventTypesEditDialogView = Backbone.View.extend({
            editDialog: null,
            subCalendar: null,
            callbackHandler: null,
            mediator : null,
            events: {
                "click .add-custom-event-type-item button": "_showAddEventypeForm"
            },
            initialize: function(options){
                this.options = $.extend({}, this.defaults, options);
                this.mediator = _.extend({}, Backbone.Events);
                this.subCalendar = this.options.subCalendar;
                this.callbackHandler = this.options.callbackHandler;
                this.collection = this._buildCustomEventTypeCollection();

                // build a custom event collection for event type
                this.editDialog = this.options.editDialog;
                this.listenTo(this.collection, 'reset add remove', this.render);
                this.mediator.on("Custom-Event-Type.save", _.bind(this._updateEventType, this, this.callbackHandler));
                this.mediator.on("close-edit-custom-event-dialog", _.bind(this._closeEditCustomEventTypeDialog, this));
                this.mediator.on("open-edit-custom-event-dialog", _.bind(this._openEditCustomEventTypeDialog, this));

                this.$el.html(Templates.editCalendarEventTypes({"subCalendarId": this.subCalendar.id, "eventTypes": this.collection}));
                this.editDialog.addPanel(AJS.I18n.getText("com.atlassian.confluence.extra.team-calendars.editcalendar.panel.eventtype"), this.$el, "eventtypes-edit-dialog-panel");
            },
            render: function() {
                if (this.collection.customEventTypes().length === 0){
                    // render instructional text
                    this.$el.find(".custom-event-type-items-instructional").removeClass("hidden");
                } else {
                    this.$el.find(".custom-event-type-items-instructional").addClass("hidden");
                }

                this.$el.find(".event-type-item").remove();
                // render default eventTypes
                this._renderCustomeEventTypes(this.$el.find(".default-event-type-items"), this.collection.defaultEventTypes());

                // render custom eventTypes
                this.collection.setSortField("created", "DESC"); //order sort for custom event
                this.collection.sort();
                this._renderCustomeEventTypes(this.$el.find(".custom-event-type-items"), this.collection.customEventTypes());

                //process behaviour when event type panel active
                this.editDialog.getCurrentPanel().onselect = function() {
                    $("#edit-calendar-dialog").find(".button-panel-button.submit").removeClass("hidden");
                };

                return this.editDialog;
            },
            selectCustomEvent: function(id) {
                this.collection.select(id);
            },
            getDisableEventTypes : function (){
                var disableEventType = this.collection.chain()
                    .filter(function(model) { return model.get('disable') === true; })
                    .map(function(model) { return  model.id; })
                    .value();

                return disableEventType;
            },
            showAddEventypeForm : function(){
                // trigger click to show add event type form
                $('.add-custom-event-type-item button').click();
            },
            _renderCustomeEventTypes : function($rootElement, eventTypes){
                var that = this;
                $(eventTypes).each(function(index, eventTypeModel){
                    var customEventTypeView = new CustomEventTypeView({model : eventTypeModel, mediator : that.mediator});
                    $rootElement.after(customEventTypeView.render().el);
                });
            },
            _buildCustomEventTypeCollection : function (){
                var that = this;
                var listDisableEventType = that.subCalendar.disableEventTypes;
                var listCustomEventType = that.subCalendar.customEventTypes;
                var sanboxEventTypeReminders = that.subCalendar.sanboxEventTypeReminders;
                var eventTypes = EventTypes.DefaultEventType;
                var customEventTypeCollection = new CustomEventTypeList();

                var isDisableEventType = function(eventType) {
                    for (var item in listDisableEventType) {
                        if (eventType === listDisableEventType[item])
                        {
                            return true;
                        }
                    }
                    return false;
                };

                var getPeriodForSanboxEventType = function(eventTypeId) {
                    for(var item in sanboxEventTypeReminders) {
                        if(eventTypeId === sanboxEventTypeReminders[item].eventTypeId) {
                            return sanboxEventTypeReminders[item].periodInMins;
                        }
                    }
                }

                var customeEventModels = new Array();
                //load default sanbox event type
                $.each(eventTypes, function(i, type) {
                    if (!type.hiddenFromEventCreation) {
                        var customeEventModel = new CustomeEventTypeModel({
                            title : type.name,
                            subCalendar : that.subCalendar,
                            disable : isDisableEventType(type.id),
                            id : type.id,
                            icon : type.id,
                            periodInMins: getPeriodForSanboxEventType(type.id)
                        });
                        customeEventModels.push(customeEventModel);
                    }
                });

                //load custom event type
                if(listCustomEventType) {
                    $.each(listCustomEventType, function(i, type) {
                        var customeEventModel = new CustomeEventTypeModel({
                            title : type.title,
                            subCalendar : that.subCalendar,
                            disable : isDisableEventType(type.customEventTypeId),
                            id : type.customEventTypeId,
                            icon : type.icon,
                            isCustomEvent: true,
                            created: type.created,
                            periodInMins: type.periodInMins
                        });
                        customeEventModels.push(customeEventModel);
                    });
                }

                customEventTypeCollection.add(customeEventModels);
                return customEventTypeCollection;
            },
            _showAddEventypeForm: function(event) {
                event.preventDefault();
                event.stopPropagation();

                var $addCustomEventTypeBtn = $(event.target).closest(".add-custom-event-type-item");

                var newCustomEventNewModel = new CustomeEventTypeModel({
                    id : null,
                    subCalendar : this.subCalendar,
                    isCustomEvent: true
                });
                newCustomEventNewModel.collection = this.collection;

                var eventTypesEditDialogView = new CustomEventTypeEditInlineDialogView({model : newCustomEventNewModel, parentCustomEventTypeDiv: $addCustomEventTypeBtn, mediator : this.mediator});
                eventTypesEditDialogView.render();
                //scroll to bottom
                this.$el.parent().scrollTop(this.$el.find("#edit-custom-event-type-form form").position().top);
            },
            _updateEventType: function(_callbackHandler, newEventTypeModel) {
               if(newEventTypeModel.get("isCustomEvent") === true) {
                   this._updateCustomEventType(_callbackHandler, newEventTypeModel);
               } else {
                   this._updateSanboxEventType(_callbackHandler, newEventTypeModel);
               }
            },
            _updateCustomEventType : function(_callbackHandler, newCustomEventTypeModel) {
                var that = this;
                var requestData = that._getCustomEventTypes(newCustomEventTypeModel);

                //disable button submit
                var submitButton = this.$el.find("#save-custom-event-type");
                $(submitButton).val(AJS.I18n.getText("calendar.customeventtype.saving")).prop("disabled", true).addClass("ui-state-disabled");

                //call rest to add new custom event type
                $.ajax({
                     cache : false,
                     data : requestData,
                     dataType : "json",
                     error : function(XMLHttpRequest, textStatus, errorThrown) {
                         _callbackHandler.showAjaxUpdateError(XMLHttpRequest, textStatus, errorThrown);
                     },
                     success : function(responseEntity) {
                         var customEventTypeModel = new CustomeEventTypeModel({
                             subCalendar : that.subCalendar,
                             isCustomEvent: true,
                             title: responseEntity.title,
                             icon: responseEntity.icon,
                             id: responseEntity.customEventTypeId,
                             created: responseEntity.created,
                             periodInMins: responseEntity.periodInMins
                         });

                         var isCreateNew = true;
                         var customEventTypes = that.collection.where({id: responseEntity.customEventTypeId});
                         if(customEventTypes && customEventTypes.length > 0) {
                             isCreateNew = false;
                         }
                         if (isCreateNew) {
                             Confluence.TeamCalendars.fireEventForAnalytics("customeventtype.create", {});
                         } else {
                             Confluence.TeamCalendars.fireEventForAnalytics("customeventtype.update", {});
                         }

                         that.collection.add(customEventTypeModel);
                         //scroll to bottom
                         that.$el.parent().scrollTop(that.$el.find(".add-custom-event-type-item").position().top);
                     },
                     type : "PUT",
                     timeout: Confluence.TeamCalendars.ajaxTimeout,
                     url : Confluence.TeamCalendars.getCalendarServiceBaseUrl("/eventtype/custom.json")
                });
            },
            _updateSanboxEventType : function(_callbackHandler, newEventTypeModel) {
                var that = this;
                var requestData = that._getSanboxEventTypes(newEventTypeModel);

                //disable button submit
                var submitButton = this.$el.find("#save-custom-event-type");
                $(submitButton).val(AJS.I18n.getText("calendar.customeventtype.saving")).prop("disabled", true).addClass("ui-state-disabled");

                //call rest to add new custom event type
                $.ajax({
                     cache : false,
                     data : requestData,
                     dataType : "json",
                     error : function(XMLHttpRequest, textStatus, errorThrown) {
                         _callbackHandler.showAjaxUpdateError(XMLHttpRequest, textStatus, errorThrown);
                     },
                     success : function(responseEntity) {
                         that.collection.add(newEventTypeModel);
                         //scroll to bottom
                         that.$el.parent().scrollTop(that.$el.find(".add-custom-event-type-item").position().top);
                     },
                     type : "PUT",
                     timeout: Confluence.TeamCalendars.ajaxTimeout,
                     url : Confluence.TeamCalendars.getCalendarServiceBaseUrl("/eventtype/sandbox.json")
                });
            },
            _selectIconCustomEventType: function(event) {
                // stop default link click behaviour
                event.preventDefault();

                // unmark any previously selected image and mark clicked selected
                $(event.target).siblings('.icon-teamcals').removeClass('selected');
                $(event.target).addClass('selected');
            },
            _getCustomEventTypes: function(newCustomEventTypeModel) {
                return {
                    title: newCustomEventTypeModel.get("title"),
                    icon: newCustomEventTypeModel.get("icon"),
                    subCalendarId: newCustomEventTypeModel.get("subCalendar").id,
                    customEventTypeId: newCustomEventTypeModel.get("id"),
                    created: newCustomEventTypeModel.get("created"),
                    periodInMins: newCustomEventTypeModel.get("periodInMins")
                };
            },
            _getSanboxEventTypes: function(newEventTypeModel) {
                return {
                    title: newEventTypeModel.get("title"),
                    icon: newEventTypeModel.get("icon"),
                    subCalendarId: newEventTypeModel.get("subCalendar").id,
                    eventTypeId: newEventTypeModel.get("id"),
                    created: newEventTypeModel.get("created"),
                    periodInMins: newEventTypeModel.get("periodInMins")
                };
            },
            _closeEditCustomEventTypeDialog: function() {
                this.editDialog.hide();
            },
            _openEditCustomEventTypeDialog: function() {
                this.editDialog.show();
            }
        });
        return EventTypesEditDialogView;
});
