jQuery(function($) {
    $("#reset-subscriptions-form").submit(function() {
        $(".button", this).prop("disabled", true);
    });

    var LongRunTaskClient = {
        waitForLongRunTask : function (longRunTaskId, processUpdateCb, status, defer) {
            var d = defer ? defer : $.Deferred();
            var timeout = 2000;
            var url = AJS.contextPath() + "/rest/api/longtask/" + longRunTaskId;
            LongRunTaskClient
                .wait(timeout)
                .done(function () {
                    $.ajax({
                        type: 'GET',
                        contentType: 'application/json',
                        url: url
                        }).done(function (s) {
                            var jsonStatus = s;
                            var progressComplete = parseInt(jsonStatus.percentageComplete, 10);
                            if (jsonStatus.successful) {
                                if (progressComplete >= 100) {
                                    return d.resolve(status);
                                }

                                processUpdateCb(jsonStatus.percentageComplete);
                                return LongRunTaskClient.waitForLongRunTask(longRunTaskId, processUpdateCb, jsonStatus, d);
                            } else {
                                return d.reject(status);
                            }

                    }).fail(d.reject);
                });

            return d.promise();
        },

        wait: function(timeout, context) {
            var deferred = $.Deferred();
            var promise = deferred.promise();

            var timeoutId = setTimeout(function() {
                deferred.resolveWith(context, arguments)
            }, timeout || 0);
            return promise;
        }
    };

    var $encryptePasswordForm = $('#tc-encrypt-password-form');
    var $waitingIcon = $encryptePasswordForm.find('.aui-icon-wait');
    var $submitButton = $encryptePasswordForm.find('.button');
    var $encryptPasswordPanel = $("#tc-password-encryption");
    var $encryptPasswordMsg = $("#tc-password-encryption-msg");
    var longRunTaskId = $encryptePasswordForm.attr("longRunTaskId");
    var messages = $("#tc-password-encryption span.hidden");
    var updateProgressBar = function(percentage) {};
    var enableForm = function (isDone) {
        $waitingIcon.addClass("hidden");
        $submitButton.prop("disabled", false);
        $encryptPasswordPanel.removeClass();
        if (isDone) {
            $encryptPasswordPanel.addClass("aui-message aui-message-success success shadowed");
            $encryptPasswordMsg.html(messages[0].innerHTML);
        } else {
            $encryptPasswordPanel.addClass("aui-message aui-message-error error shadowed");
            $encryptPasswordMsg.html(messages[1].innerHTML);
        }
    };

    var disableForm = function () {
        $submitButton.prop("disabled", true);
        $waitingIcon.removeClass("hidden");
    };

    if (longRunTaskId) {
        $waitingIcon.removeClass("hidden");
        LongRunTaskClient.waitForLongRunTask(longRunTaskId, updateProgressBar)
            .fail(enableForm(false))
            .done(enableForm(true));
        $encryptePasswordForm.remove();
    } else {
        $encryptePasswordForm.submit(function () {
            disableForm();
        });
    }
});
