define("tc/import-subcalendar",
    [
        "jquery",
        "underscore",
        "document",
        "tc/util",
        "tc-backbone",
        "tc/templates",
        "tc/calendar-util",
        "confluence/flag"
    ],
    function (
        $,
        _,
        document,
        Util,
        Backbone,
        Templates,
        CalUtil,
        Flag
    ) {

        "use strict";

        var ImportSubCalendarDialogView = Backbone.View.extend({
            dialog: null, //instance of AJS.ConfluenceDialog,
            //el: will be dialogContent of dialog
            $uploadIframe: null,
            //submit import button
            $submitButton: null,
            options: null, //setting collection of an instance of ImportSubCalendarDialogView

            template: null,

            events: {
                "selected.autocomplete-content input[name='spaceKeyAutocomplete']": "_selectSpace"
            },

            defaults: {
                callbackHandler: null,
                textTitleDialog: AJS.I18n.getText("calendar3.importsubcal"),
                textBtnImport: AJS.I18n.getText("import.name"),
                textLinkCancel: AJS.I18n.getText("cancel.name")
            },

            initialize: function (options) {
                this.options = $.extend({}, this.defaults, options);
                var existingSubCalendar = this.options.existingSubCalendar;
                this.template = Templates.importSubcalendar({ existingSubCalendar: existingSubCalendar })

                if (!this.options.callbackHandler) {
                    AJS.debug("tc/import-subcalendar: requires 'callbackHandler' object");
                }
            },

            render: function () {
                this._createSubCalendarImportDialog();
                this._populateSubCalendarImportForm();

                this.$submitButton = this.dialog.popup.element.find(".submit");
                return this.dialog;
            },

            _createSubCalendarImportDialog: function () {
                var that = this;
                var isSendingRequest = false;
                var submit = function () {
                    if (isSendingRequest) {
                        return;
                    }
                    var editForm = that.$el.find('form.sub-calendar-import-form');

                    isSendingRequest = true;
                    $.ajax({
                        type: "POST",
                        headers: {
                            "X-Atlassian-Token": "no-check"
                        },
                        url: Confluence.getContextPath() + "/plugins/calendar/importsubcalendar.action",
                        cache: false,
                        contentType: false,
                        processData: false,
                        data: new FormData(editForm[0]),
                        success: function(data) {
                            isSendingRequest = false;
                            that._loadedResultImport(data);
                        },
                        error: function () {
                            isSendingRequest = false;
                        }

                    });

                    that._submit();
                    return false;
                };

                //Do not need to create one more instance of AJS.ConfluenceDialog
                if (this.dialog) {
                    return;
                }

                this.dialog = new AJS.ConfluenceDialog({
                    height: this.options.existingSubCalendar ? 250 : 429,
                    width: 512,
                    onSubmit: submit,
                    id: !this.options.existingSubCalendar ? "import-calendar-dialog" : "import-calendar-dialog-existing",
                    onCancel: function() {
                        that.dialog.remove();
                    }
                });

                this.dialog.addHeader(this.options.textTitleDialog);
                this.dialog.addPanel("", this.template, "calendar-dialog-panel");

                //add button submit for dialog
                this.dialog.addButton(
                    this.options.textBtnImport,
                    submit,
                    "submit"
                );

                //add cancel link for dialog
                this.dialog.addLink(
                    this.options.textLinkCancel,
                    _.bind(this._cancelDialog, this)
                );

                this.el = this.dialog.getCurrentPanel().body;
                this.$el = $(this.el);
                this.$uploadIframe = this.$el.find(".subcalendar-import-result");

                this.delegateEvents(); // this will bind all events once
            },

            _populateSubCalendarImportForm: function () {
                if (!this.options.existingSubCalendar) {
                    this.$el.find("input[name='name'], textarea[name='description'], input[name='spaceKey'], input[name='spaceKeyAutocomplete']").val("");
                }
                this.$el.find("input[name='color']").val(this.options.callbackHandler.getNextCalendarColor());
                this.$el.find(".field-group .error").empty();

                //hidden space field when TC on space
                if (AJS.Meta.get("space-key")) {
                    this.$el.find("input[name='spaceKey']").val(AJS.Meta.get("space-key"));
                    var spaceDiv = $(".field-group-space-permission", this.$el);
                    spaceDiv.css("display", "none");
                }
            },

            _submit: function () {
                this.options.callbackHandler.setProcessingSubCalendar(true);
                this.spinnerDefer = this.options.callbackHandler.setSubCalendarSpinnerIconVisible(true);
                //disable submit when click
                CalUtil.disableButton(this.$submitButton, AJS.I18n.getText("calendar3.importing.name"));
            },

            _selectSpace: function (e, selection) {
                this.$el.find("input[name='spaceKey']").val(selection.content.key);
                this.$el.find("input[name='spaceKeyAutocomplete']").val(selection.content.name);
            },

            _cancelDialog: function () {
                this.dialog.remove();
                this.dialog = null;
                return false;
            },
            _showImportJiraWarningFlag: function() {
                var title = AJS.I18n.getText('calendar3.error.import.warning.jira.title');
                var body = Templates.importWarningGeneral();

                this._showFlag(title, body, 'warning', 'manual');
            },
            _showImportWarningFlag: function() {
                var title = AJS.I18n.getText('calendar3.error.import.warning.general.title');
                var body = Templates.importWarningGeneral();

                this._showFlag(title, body, 'warning', 'manual');
            },
            _showImportSuccessFlag: function() {
                var title = AJS.I18n.getText('calendar3.error.import.success.general.title');
                var body = AJS.I18n.getText('calendar3.error.import.success.general.body');

                this._showFlag(title, body, 'success', 'auto');
            },
            _showFlag: function (title, body, type, close) {
                new Flag({
                    close: close,
                    type: type,
                    extraClasses: 'qr-flag',
                    fifo: true,
                    stack: 'teamcal',
                    body: body,
                    title: title
                });
            },

            _loadedResultImport: function (data) {
                var that = this;

                var responseDocument = document.createElement('html');
                responseDocument.innerHTML = data;

                var subcalendarId = $(responseDocument).find(".subcalendar-id").text();
                var closeDialog;
                var showFlagFunc;

                if ($(".import-timezone-required", responseDocument).length) { //We could not determine the calendars timezone

                    CalUtil.disableButton(this.$submitButton);

                    //Show a message explaining we need to know the timezone
                    that.$el.find(".tc-need-timezone").removeClass("hidden");
                    //Show the timezone field
                    that.$el.find(".tc-field-group-timezone").removeClass("hidden");

                    //TODO: need to refactor Confluence.TeamCalendars.populateTimeZoneDropDown
                    // and Confluence.TeamCalendars.getUserTimeZone
                    Confluence.TeamCalendars.populateTimeZoneDropDown(
                        that.$el.find(".tc-field-group-timezone .timeZone"),
                        Confluence.TeamCalendars.getUserTimeZone(),
                        function () {
                            CalUtil.enableButton(that.$submitButton, AJS.I18n.getText("import.name"));
                        },
                        function (XMLHttpRequest, textStatus, errorThrown) {
                            that.options.callbackHandler.showAjaxError(XMLHttpRequest, textStatus, errorThrown);
                        }
                    );

                    that.dialog.updateHeight();
                } else if (!$(".import-successful", responseDocument).length) {
                    var fieldErrors = [];
                    $(".field-errors input", responseDocument).each(function () {
                        fieldErrors.push({
                            field: this.name,
                            errorMessages: [this.value]
                        });
                    });

                    if (fieldErrors.length) {
                        //TODO: need to refactor Confluence.TeamCalendars.setFieldErrors
                        Confluence.TeamCalendars.setFieldErrors(that.$el.find(".sub-calendar-import-form")[0], fieldErrors);
                        // Comment out to deal with AUI on Confluence 5.7
                        //Util.showDialogInUpdatedHeight(that.dialog);
                        that.dialog.updateHeight();
                    }

                    var errorMessages = [];
                    $(".action-error", responseDocument).each(function () {
                        errorMessages.push($(this).text());
                    });
                    if (errorMessages.length) {
                        AJS.error('Error importing calendar', responseDocument);
                        //TODO: need to refactor Confluence.TeamCalendars.setGenericErrors
                        Confluence.TeamCalendars.setGenericErrors(that.el, errorMessages, "error-subcalendar-update");

                        var hasJiraRelatedErrors = !!($(".action-error-events-of-type:contains('jira-')", responseDocument).length);

                        if (hasJiraRelatedErrors) {
                            showFlagFunc = that._showImportJiraWarningFlag;
                        } else {
                            showFlagFunc = that._showImportWarningFlag;
                        }

                        if (!fieldErrors.length) {
                            closeDialog = true;
                        }
                    }
                } else {
                    closeDialog = true;
                    showFlagFunc = this._showImportSuccessFlag;
                }

                CalUtil.enableButton(this.$submitButton, AJS.I18n.getText("import.name"));

                if (this.spinnerDefer) {
                    this.spinnerDefer.resolve();
                }
                this.options.callbackHandler.setProcessingSubCalendar(false);
                if (closeDialog) {
                    this.dialog.remove();
                    this.options.callbackHandler.handleImport(subcalendarId);
                }
                if (showFlagFunc) {
                    showFlagFunc.call(this);
                }

            }
        });

        return ImportSubCalendarDialogView;
    });
