define("tc/infinite-list",
    [
        "jquery",
        "underscore",
        "tc-backbone",
        "exports"
    ],
    function (
        $,
        _,
        Backbone,
        exports
    ) {
        /**
         * Infinite scroll thingie. Loads more popular subscription when you scroll down in dialog.
         *
         */
        function ScrollLoader(options) {

            var $list = options.$el;
            var loadDataFunction = options.load;
            var $container = options.$container || $(window);
            var body = options.body || document.body;
            var scrollMargin = options.scrollMargin || 300;
            var isLoadMoreItems = options.isLoadMoreItems || false;

            var pageSize = $list.data("page-size");
            var startIndex = 1; // we start loading items at the page size offset

            function loadMoreItems() {
                loadDataFunction(startIndex, pageSize);
                startIndex += 1;
            }

            /**
             * Load items when we are almost scrolled to the bottom of a page and there are possibly more items
             * on the server to load (when we initially already display pageSize items).
             */
            function loadItemsMaybe() {
                var possiblyMoreItemsToLoad = isLoadMoreItems == true ? isLoadMoreItems : $list.children().length >= pageSize;
                var scrolledToTheBottom = body.scrollHeight - $container.scrollTop() - scrollMargin  <= $container.height();
                if (possiblyMoreItemsToLoad && scrolledToTheBottom) {
                    loadMoreItems();
                }
            }

            $container.bind("scroll.list", _.debounce(loadItemsMaybe, 100));
            loadItemsMaybe();

            this.destroy = function() {
                $container.off("scroll.list");
            };
        }

        // mixin events
        _.extend(ScrollLoader.prototype, Backbone.Events);

        exports.init = function(options) {
            return new ScrollLoader(options);
        };
    });