define('tc/init-resources', ['wrm', 'jquery'], function(WRM, $) {
    var removeSpinner = function($elem) {
        $elem.removeClass('spinner aui-icon aui-icon-wait'); // Remove old spinner if it exists
        $elem.find('aui-spinner').remove();
        return $elem;
    };

    return {
        requireResources: function() {
            console.log("Init TC resources");
            WRM.require([
                'wrc!com.atlassian.confluence.extra.team-calendars.resources-batch'
            ], function () {
                removeSpinner($('div.plugin-calendar'));
                require(['tc/calendar-plugin'], function(CalendarPlugin) {
                    CalendarPlugin.onTeamCalendarsLoaded();
                });
            }).fail(function () {
                removeSpinner($('div.plugin-calendar')).text('Failed to load calendar resources');
            });
        }
    }
});
