/**
 * Allow to configure which content-types don't require TC editor resources
 */
define('tc/init-resources-unsupported-content-types',
    function () {
        var unsupportedContentTypes = [
            'comment',
            'com.atlassian.confluence.plugins.confluence-questions:question'
        ];
        return unsupportedContentTypes;
    }
);

/**
 * Return a promise resolved once AJS.MacroBrowser.getMacroMetadata('calendar') is loaded
 */
define('tc/wait-for-calendar-macro-browser-metadata',
    function () {
        var promise;

        return function () {
            if (!promise) {
                promise = new Promise(function (resolve) {
                    var intervalId = setInterval(
                        function () {
                            if (AJS.MacroBrowser.getMacroMetadata('calendar')) {
                                clearInterval(intervalId);
                                resolve();
                            }
                        },
                        100
                    )
                });
            }
            return promise;
        };
    }
);

/**
 * Make the code testable, not for external usage
*/
define('tc/init-resources-function',
    ['ajs', 'jquery', 'wrm', 'confluence/meta', 'confluence/api/logger', 'tc/init-resources-unsupported-content-types', 'tc/wait-for-calendar-macro-browser-metadata'],
    function(AJS, $, WRM, Meta, Logger, unsupportedContentTypes, waitForCalendarMacroBrowserMetadata) {
        var initResourcesFunction =  function() {
            var contentType = Meta.get("content-type");
            if (unsupportedContentTypes.indexOf(contentType) >= 0) {
                WRM.require(
                    ['wrc!com.atlassian.confluence.extra.team-calendars:editor'],
                    function () {
                        // remove the calendar macro from the add dialog
                        waitForCalendarMacroBrowserMetadata().then( function() {
                            AJS.MacroBrowser.getMacroMetadata('calendar').hidden = true;
                            $(window).trigger("tc/init-resources-function--load-succeed");
                            initResourcesFunction.isEditorResourcesLoadSucceed = true;
                            Logger.log('TC initialiser-editor: not loading TC editor resources for content-type=' + contentType);
                        });
                    }
                );
                return;
            }

            Logger.log('TC initialiser-editor: Init TC resources in Editor. content-type=' + contentType);
            WRM.require([
                'wrc!com.atlassian.confluence.extra.team-calendars:editor'
            ], function () {
                require(
                    ['tc/init-resources', 'tc/macro-button-panel', 'tc/macro-browser', 'tc/macro-browser-event-macro', 'tc/editor-auto-convert'],
                    function(Initialiser, MacroButtonPanel, TcMacroBrowserEnhancer, TcEventMacroBrowserEnhancer, EditorAutoConvert) {
                    try {
                        MacroButtonPanel.init();
                        TcMacroBrowserEnhancer.init();
                        TcEventMacroBrowserEnhancer.init();
                        EditorAutoConvert.init();
                        Initialiser.requireResources();
                        // show the calendar macro in the add dialog
                        waitForCalendarMacroBrowserMetadata().then( function() {
                            AJS.MacroBrowser.getMacroMetadata('calendar').hidden = false;
                            $(window).trigger("tc/init-resources-function--load-succeed");
                            initResourcesFunction.isEditorResourcesLoadSucceed = true;
                        });
                    } catch (e) {
                        $(window).trigger("tc/init-resources-function--load-failed");
                        initResourcesFunction.isEditorResourcesLoadFailed = e;
                        Logger.error('TC initialiser-editor: Could not init TC resources for editor', e);
                    }
                });
            }).fail(function (e) {
                $(window).trigger("tc/init-resources-function--load-failed");
                initResourcesFunction.isEditorResourcesLoadFailed = e;
                Logger.error('TC initialiser-editor: Could not load TC resources for editor');
            });

        };
        return initResourcesFunction;
    }
);

/**
 * We need to require the resources directly in the editor, not skate them.
 */
require(['tc/init-resources-function'],
    function(initResources) {
     // Make sure only init TC resources when editor is ready
        $(window).bind('rte-ready', initResources);
    }
);
