define("tc/load-favicon",
    [
        "jquery"

    ],
    function (
        $
    )
    {
        "use strict";
        return {
            render: function ()
            {
                var currentDay = (new Date()).getDate() + '';
                this._loadFaviconCalendar(currentDay);
            },
            _loadFaviconCalendar: function (day) {
                var canvas = $('<canvas />'),
                // create image node
                    image = $('<img />'),
                // clone current favicon link node
                    links = $("link[rel~='icon']");

                // set the number/text you want to overlay your icon
                // browser check, only create image and new link node if
                //        browser supports canvas node operations
                if (typeof canvas.get(0).getContext === 'function')
                {

                    if (!links)
                    {
                        links = document.createElement("link");
                        links.setAttribute("rel", "shortcut icon");
                        links.type = "image/x-icon";
                        document.head.appendChild(links);
                    }

                    canvas.attr({
                        width: 32, // set width
                        height: 32 // set height
                    });

                    // get the canvas context
                    var context = canvas.get(0).getContext('2d');
                    var realContextPath = AJS.Meta.get("static-resource-url-prefix") || Confluence.getContextPath();

                    // add an on load event handler for the image will
                    // get triggered when you set the src attribute//
                    // of your favicon image, and its this image that will
                    // have a number overlayed it
                    image.on('load', function ()
                    {
                        // draw a copy of the orignal image
                        context.drawImage(this, 0, 0);
                        context.font = 'bold 17px "helvetica", sans-serif';
                        context.textAlign = 'center';
                        context.fillStyle = '#42526E';
                        context.fillText(day, 16, 25);

                        //is IE 11 load default icon calendar
                        var IE11 = !!navigator.userAgent.match(/Trident\/7.0/) &&
                            !!navigator.userAgent.match(/.NET4.0E/);
                        // set the href attribute of the cloned link tag
                        // to the data url of the newly generated image

                        links.each(function () {
                            if (IE11) {
                                this.href = realContextPath +
                                '/download/resources/com.atlassian.confluence.extra.team-calendars:calendar-resources/img/logo_16.png';
                            } else  {
                                this.href = canvas.get(0).toDataURL('image/png');
                            }
                        });

                        // append the new link tag to the bottom of the head,
                        // which will override the existing favicon link node
                        $('head').append(links);
                    });

                    // trigger the load the new image by setting the src
                    // attribute to the image you want to overlay your text with
                    image.attr({
                        src: realContextPath +
                            '/download/resources/com.atlassian.confluence.extra.team-calendars:calendar-resources/img/calendar-favicon.png'
                    });
                }
            }
        };
});