/**
 * An abstract module to work around Confluence.storageManager does not available in older Confluence
 */
define("tc/localStorage",
    [
        "jquery"
    ],
    function ($)
    {
        var cookieStorage = function() {
            return {
                getItem: function(key) {
                    $.cookie(key)
                },

                setItem: function(key, value, expire) {
                    $.cookie(key, value, expire)
                }
            }
        }();

        var id = "team-calendars",
            tcStorageManger = Confluence.storageManager ? Confluence.storageManager(id) : (localStorage ? localStorage : cookieStorage),
            user = AJS.Meta.get("remote-user"),
            namespace = "confluence" + "." +  user + "." + id;

        var getKeyStore = function(key) {
            return Confluence.storageManager ? key : namespace + "." + key;
        };

        return {
            getItem: function(key) {
                return tcStorageManger.getItem(getKeyStore(key));
            },

            setItem: function(key, value, expire) {
                try {
                    tcStorageManger.setItem(getKeyStore(key), value, expire);
                } catch(e){
                    console.log(e);
                }
            }
        };
    }
);