define("tc/event-edit-analytics",
    [
        "jquery",
        "tc/calendar-util",
        "confluence/api/logger"
    ],
    function (
        $,
        CalUtil,
        Logger
    ) {
        "use strict";

        var analyticEventTrigger = function (calendarDiv, properties, uid, eventType) {
            if (!uid) { //We are creating a new event
                //only fire event for analytics when creating new event.
                Logger.log("analyticEventTrigger: rruleLength=" + properties.rruleLength +  ", eventType=" + eventType);
                addEventAnalytics(calendarDiv, properties);
            }
        }

        var addEventAnalytics = function (calendarDiv, properties) {
            var context = "myCalendars";

            if (AJS.Meta.get("space-key")) {
                if (AJS.Meta.get("content-id")) {
                    context = "embedded";
                } else {
                    if(CalUtil.isSingleCalendarView(calendarDiv)){
                        context = "singleCalendar";
                    } else {
                        context = "spaceCalendars";
                    }
                }
            }

            Object.assign(properties, {context: context});
            Confluence.TeamCalendars.fireEventForAnalytics("add.event", properties);
        };

        return {
            analyticEventTrigger: analyticEventTrigger
        }
});