define("tc/event-types",
    [
        "jquery",
        "confluence/dark-features",
        "tc/jira-event-field-process-united",
        "tc/jira-event-field-process-divided"
    ],
    function (
        $,
        DarkFeatures,
        JiraEventFieldProcessUnited,
        JiraEventFieldProcessDivided
    )
    {
        "use strict";
        var basePeopleEventType = {
            "fields" : [
                {
                    "type" : "user",
                    "id" : "who",
                    "label" : AJS.I18n.getText("calendar3.who"),
                    "required" : true,
                    "property" : "what",
                    "setTitle" : true
                },
                {
                    "type" : "text",
                    "id" : "description",
                    "required" : true,
                    "property" : "description",
                    "label" : AJS.I18n.getText("calendar3.summary"),
                    "copyto" : "what"
                },
                {
                    "type" : "when",
                    "id" : "people"
                },
                {
                    "type" : "repeats2",
                    "id" : "people"
                },
                {
                    "type" : "reminder",
                    "id" : "reminder",
                    "label" : AJS.I18n.getText("calendar3.reminder")
                },
                {
                    "type" : "page",
                    "id" : "url",
                    "property" : "workingUrl",
                    "label" : AJS.I18n.getText("calendar3.eventlink")
                }
            ]
        };
        const JiraEventFieldProcess = DarkFeatures.isEnabled('confluence.team-calendar.jira-combined-query-dialog') ? JiraEventFieldProcessUnited : JiraEventFieldProcessDivided;

        var EventTypes = {
            DefaultEventType : {
                "travel" : $.extend(
                    {}, basePeopleEventType,
                    {
                        "id" : "travel",
                        "name" : AJS.I18n.getText("calendar3.event.type.travel")
                    }
                ),

                "leaves" : $.extend(
                    {}, basePeopleEventType,
                    {
                        "id" : "leaves",
                        "name" : AJS.I18n.getText("calendar3.event.type.leaves")
                    }
                ),

                "birthdays" : $.extend(
                    true, // support recursive
                    {}, basePeopleEventType,
                    {
                        "id" : "birthdays",
                        "name" : AJS.I18n.getText("calendar3.subcalendar.type.birthdays"),
                        "fields": [
                            {},
                            {},
                            {
                                defaultRecur: {
                                    freq: "YEARLY"
                                }
                            }
                        ]
                    }
                ),

                "jira" : {
                    "id" : "jira",
                    "name" : AJS.I18n.getText("calendar3.subcalendar.type.jira-issue-dates"),
                    "hiddenFromEventCreation" : true,
                    "fields" : [
                        {
                            "type" : "text",
                            "id" : "what",
                            "property" : "title",
                            "label" : AJS.I18n.getText("calendar3.event.field.what"),
                            "required" : true,
                            "readOnly" : true
                        },
                        {
                            "type" : "when",
                            "id" : "simple",
                            "disableEndDateTime" : false,
                            "disableAllDay" : true
                        },
                        {
                            "type" : "reminder",
                            "id" : "reminder",
                            "label" : AJS.I18n.getText("calendar3.reminder")
                        },
                        {
                            "type" : "page",
                            "id" : "url",
                            "property" : "workingUrl",
                            "label" : AJS.I18n.getText("calendar3.eventlink"),
                            "readOnly" : true
                        },
                        {
                            "type" : "textarea",
                            "id" : "description",
                            "property" : "description",
                            "label" : AJS.I18n.getText("calendar3.event.field.description"),
                            "size" : 5,
                            "readOnly" : true
                        }
                    ]
                },

                "jira-agile-sprint" : {
                    "id" : "jira-agile-sprint",
                    "name" : AJS.I18n.getText("calendar3.subcalendar.type.jira-agile-sprint"),
                    "hiddenFromEventCreation" : true,
                    "fields" : [
                        {
                            "type" : "text",
                            "id" : "what",
                            "property" : "title",
                            "label" : AJS.I18n.getText("calendar3.event.field.what"),
                            "required" : true,
                            "readOnly" : true
                        },
                        {
                            "type" : "when",
                            "id" : "simple",
                            "disableEndDateTime" : true,
                            "disableAllDay" : true
                        },
                        {
                            "type" : "reminder",
                            "id" : "reminder",
                            "label" : AJS.I18n.getText("calendar3.reminder")
                        },
                        {
                            "type" : "page",
                            "id" : "url",
                            "property" : "workingUrl",
                            "label" : AJS.I18n.getText("calendar3.eventlink"),
                            "readOnly" : true
                        },
                        {
                            "type" : "textarea",
                            "id" : "description",
                            "property" : "description",
                            "label" : AJS.I18n.getText("calendar3.event.field.description"),
                            "size" : 5,
                            "readOnly" : true
                        }
                    ]
                },

                "jira-project-releases" : {
                    "id" : "jira-project-releases",
                    "name" : AJS.I18n.getText("calendar3.subcalendar.type.jira-project-releases"),
                    "hiddenFromEventCreation" : true,
                    "fields" : [
                        {
                            "type" : "text",
                            "id" : "what",
                            "property" : "title",
                            "label" : AJS.I18n.getText("calendar3.event.field.what"),
                            "required" : true,
                            "readOnly" : true
                        },
                        {
                            "type" : "when",
                            "id" : "simple",
                            "disableEndDateTime" : true,
                            "disableAllDay" : true

                        },
                        {
                            "type" : "reminder",
                            "id" : "reminder",
                            "label" : AJS.I18n.getText("calendar3.reminder")
                        },
                        {
                            "type" : "page",
                            "id" : "url",
                            "property" : "workingUrl",
                            "label" : AJS.I18n.getText("calendar3.eventlink"),
                            "readOnly" : true
                        },
                        {
                            "type" : "textarea",
                            "id" : "description",
                            "property" : "description",
                            "label" : AJS.I18n.getText("calendar3.event.field.description"),
                            "size" : 5,
                            "readOnly" : true
                        }
                    ]
                },

                "other" : {
                    "id" : "other",
                    "name" : AJS.I18n.getText("calendar3.subcalendar.type.other"),
                    "fields" : [
                        {
                            "type" : "text",
                            "id" : "what",
                            "property" : "title",
                            "label" : AJS.I18n.getText("calendar3.event.field.what"),
                            "required" : true,
                            "copyto" : "description"
                        },
                        {
                            "type" : "user",
                            "id" : "who",
                            "label" : AJS.I18n.getText("calendar3.who"),
                            "property" : "what"
                        },
                        {
                            "type" : "when",
                            "id" : "simple"
                        },
                        {
                            "type" : "repeats2",
                            "id" : "simple"
                        },
                        {
                            "type" : "reminder",
                            "id" : "reminder",
                            "label" : AJS.I18n.getText("calendar3.reminder")
                        },
                        {
                            "type" : "text",
                            "id" : "where",
                            "property" : "where",
                            "label" : AJS.I18n.getText("calendar3.event.field.where")
                        },
                        {
                            "type" : "page",
                            "id" : "url",
                            "property" : "workingUrl",
                            "label" : AJS.I18n.getText("calendar3.eventlink")
                        },
                        {
                            "type" : "textarea",
                            "id" : "description",
                            "property" : "description",
                            "label" : AJS.I18n.getText("calendar3.event.field.description"),
                            "size" : 5
                        }
                    ]
                },

                "jira-calendar" : {
                    "id" : "jira-calendar",
                    "name" : AJS.I18n.getText("calendar3.subcalendar.type.jira-issue-dates"),
                    "customHandler" : JiraEventFieldProcess.CustomSubmitter.JiraIssues,
                    "hiddenFromEventCreation" : !Confluence.TeamCalendars.hasJiraLink,
                    "fields" : [
                        {
                            "type" : "jira-server-select",
                            "id" : "server",
                            "property" : "server",
                            "label" : AJS.I18n.getText("calendar3.event.field.server"),
                            "required" : true
                        },
                        {
                            "type" : "text",
                            "id" : "name",
                            "property" : "name",
                            "required" : true,
                            "label" : AJS.I18n.getText("calendar3.event.field.name")
                        },
                        {
                            "type" : "reminder",
                            "id" : "reminder",
                            "label" : AJS.I18n.getText("calendar3.reminder")
                        },
                        {
                            "type" : "jira-dates",
                            "id" : "jira-dates"
                        }
                    ]
                },

                "jira-agile-sprint-calendar" : {
                    "id" : "jira-agile-sprint-calendar",
                    "name" : AJS.I18n.getText("calendar3.subcalendar.type.jira-agile-sprint"),
                    "customHandler" : JiraEventFieldProcess.CustomSubmitter.JiraAgileSprints,
                    "hiddenFromEventCreation" : !Confluence.TeamCalendars.hasJiraLink,
                    "fields" : [
                        {
                            "type" : "jira-hidden-fields",
                            "id" : "",
                            "property" : "",
                            "required" : true,
                            "label" : ""
                        },
                        {
                            "type" : "jira-server-select",
                            "id" : "server",
                            "property" : "server",
                            "label" : AJS.I18n.getText("calendar3.event.field.server"),
                            "required" : true
                        },
                        {
                            "type" : "jira-project-select",
                            "id" : "project",
                            "property" : "project",
                            "label" : AJS.I18n.getText("calendar3.event.field.project"),
                            "required" : true
                        },
                        {
                            "type" : "text",
                            "id" : "name",
                            "property" : "title",
                            "required" : true,
                            "label" : AJS.I18n.getText("calendar3.event.field.name")
                        },
                        {
                            "type" : "reminder",
                            "id" : "reminder",
                            "label" : AJS.I18n.getText("calendar3.reminder")
                        }
                    ]
                },

                "jira-project-releases-calendar" : {
                    "id" : "jira-project-releases-calendar",
                    "name" : AJS.I18n.getText("calendar3.subcalendar.type.jira-project-releases"),
                    "customHandler" : JiraEventFieldProcess.CustomSubmitter.JiraProjectReleases,
                    "hiddenFromEventCreation" : !Confluence.TeamCalendars.hasJiraLink,
                    "fields" : [
                        {
                            "type" : "jira-hidden-fields",
                            "id" : "",
                            "property" : "",
                            "required" : true,
                            "label" : ""
                        },
                        {
                            "type" : "jira-server-select",
                            "id" : "server",
                            "property" : "server",
                            "label" : AJS.I18n.getText("calendar3.event.field.server"),
                            "required" : true
                        },
                        {
                            "type" : "jira-project-select",
                            "id" : "project",
                            "property" : "project",
                            "label" : AJS.I18n.getText("calendar3.event.field.project"),
                            "required" : true
                        },
                        {
                            "type" : "text",
                            "id" : "name",
                            "property" : "title",
                            "required" : true,
                            "label" : AJS.I18n.getText("calendar3.event.field.name")
                        },
                        {
                            "type" : "reminder",
                            "id" : "reminder",
                            "label" : AJS.I18n.getText("calendar3.reminder")
                        }
                    ]
                }
            },
            CustomEventType : {
                "id" : "custom",
                "name" : AJS.I18n.getText("calendar3.event.type.other"),
                "fields" : [
                    {
                        "type" : "text",
                        "id" : "what",
                        "property" : "title",
                        "label" : AJS.I18n.getText("calendar3.event.field.what"),
                        "required" : true,
                        "copyto" : "description"
                    },
                    {
                        "type" : "user",
                        "id" : "who",
                        "label" : AJS.I18n.getText("calendar3.who"),
                        "property" : "what"
                    },
                    {
                        "type" : "when",
                        "id" : "simple"
                    },
                    {
                        "type" : "repeats2",
                        "id" : "simple"
                    },
                    {
                        "type" : "reminder",
                        "id" : "reminder",
                        "label" : AJS.I18n.getText("calendar3.reminder")
                    },
                    {
                        "type" : "text",
                        "id" : "where",
                        "property" : "where",
                        "label" : AJS.I18n.getText("calendar3.event.field.where")
                    },
                    {
                        "type" : "page",
                        "id" : "url",
                        "property" : "workingUrl",
                        "label" : AJS.I18n.getText("calendar3.eventlink")
                    },
                    {
                        "type" : "textarea",
                        "id" : "description",
                        "property" : "description",
                        "label" : AJS.I18n.getText("calendar3.event.field.description"),
                        "size" : 5
                    }
                ]
            }
        };
        return EventTypes;
    }
);
