define('tc/jira-event-field-process-common', ['ajs'], function(AJS) {
    const setupSearchFilterSelect = ($input, data, onChange) => {
        const isReadonly = $input.prop('readonly');
        const formatOption = (row) => row.name;

        $input.auiSelect2({
            allowClear: true,
            placeholder: AJS.I18n.getText('calendar3.jira.fields.searchfilter.hint'),
            data: { results: data, text: formatOption },
            formatResult: formatOption,
            formatSelection: formatOption
        });

        $input.on('change', () => {
            onChange();
        });

        if (isReadonly) {
            disableSearchFilterSelect($input);
        }
    }

    const disableSearchFilterSelect = ($input) => {
        $input.auiSelect2('readonly', true);
        $input.prop('readonly', true); // in case select2 is not initialized yet
    }

    const enableSearchFilterSelect = ($input) => {
        $input.auiSelect2('readonly', false);
        $input.prop('readonly', false); // in case select2 is not initialized yet
    }

    const setValueOfSearchFilterSelect = ($input, value) => {
        $input.auiSelect2('val', value);
    }

    return {
        setupSearchFilterSelect,
        disableSearchFilterSelect,
        enableSearchFilterSelect,
        setValueOfSearchFilterSelect
    }
});