define("tc/repeat-base-child-component",
    [
        "jquery",
        "tc/rrule",
        "tc-backbone"
    ],
    function (
        $,
        TCRRule,
        Backbone
    ) {
        "use strict";

        var baseChildComponent = Backbone.View.extend({
            /**
             * Hacky to dynamically set $el on view
             *
             * @param new$el
             */
            setJQueryEl: function(new$el){
                this.undelegateEvents();
                this.$el = new$el;
                this.delegateEvents();
            },
            /**
             * Contain logic to hide dom element if condition does not match
             *
             * @param notShowInFrequencys array of frequency view want to hide
             * @param currentFrequency current selected frequency value
             * @param current$El current $el of the view
             * @return true if hidden and false if not
             * @private
             */
            hideIfNotMatch: function(notShowInFrequencys, currentFrequency, current$El) {
                if (notShowInFrequencys && notShowInFrequencys.indexOf(currentFrequency) >= 0 ) {
                    if (!current$El.hasClass("hidden")) {
                        current$El.addClass("hidden");
                    }
                    return true;
                }

                if (current$El.hasClass("hidden")) {
                    current$El.removeClass("hidden");
                }

                return false;
            }
        });

        return baseChildComponent;
    });