define("tc/repeat-component",
    [
        "jquery",
        "tc/rrule",
        "tc-backbone",
        "tc/calendar-util",
        "tc/repeat-frequency",
        "tc/repeat-interval",
        "tc/repeat-recur-end",
        "tc/repeat-on",
        "underscore"
    ],
    function (
        $,
        TCRRule,
        Backbone,
        CalUtil,
        RepeatFrequencyView,
        RepeatIntervalView,
        RecurEndView,
        RepeatOnView,
        _
    ) {
        "use strict";

        var repeatComponentView = Backbone.View.extend({
            template: Confluence.TeamCalendars.Templates.Fields.repeatComponent,
            unsupportedTemplate: Confluence.TeamCalendars.Templates.Fields.repeatComponentUnSupported,
            fieldsDiv: null,
            _calendarDiv: null,
            _calendarPlugin: null,
            _editThisInstanceOnlyContainer: null,
            _isEditRecurrenceEvent: false,
            frequencyView: null,
            intervalView: null,
            recurEndView: null,
            repeatOnView: null,
            initialize: function (options) {
                if (!this.validateInput()) {
                    this.model.set({isUnsupportedRrule: true});
                }

                // ideally $el will be fieldsDiv so we just append content of this component
                this.$el = $(this.template(this.model.attributes));
                this.fieldsDiv = options.fieldsDiv;
                this._calendarDiv = options._calendarDiv;
                this._calendarPlugin = options._calendarPlugin;
                this._isEditRecurrenceEvent = this.model.event.recur ? true : false;
                this._editThisInstanceOnlyContainer = this.$el.find(".edit-this-instance-only-container");
                this._editThisInstanceOnlyContainer.change(_.bind(this.updateModel, this));

                this.frequencyView = new RepeatFrequencyView({
                    model: this.model,
                    $el: this.$el.find(".field-group.frequency-container")
                });

                this.intervalView = new RepeatIntervalView({
                    model: this.model,
                    $el: this.$el.find(".field-group.interval-container")
                });

                this.repeatOnView = new RepeatOnView({
                    model: this.model,
                    $el: this.$el.find(".group.repeat-on-container")
                });

                this.recurEndView = new RecurEndView({
                    model: this.model,
                    $el: this.$el.find(".date-select.recur-ends-container"),
                    _calendarDiv: this._calendarDiv,
                    _calendarPlugin: this._calendarPlugin
                });

                this.model.set({isDisable: this._isEditRecurrenceEvent});
                this.model.on("change:isUnsupportedRrule", this.render, this);
            },
            validateInput: function() {
                var modelAttribute = this.model.attributes;
                var unsupportedAttrs = ["bysetpos", "bymonth", "byyearday",
                    "byweekno", "bynweekday", "byhour", "byminute", "bysecond", "byeaster"];
                for (var key in modelAttribute) {
                    if (unsupportedAttrs.indexOf(key) !== -1) {
                        if (modelAttribute[key]) {
                            return false;
                        }
                    }
                }

                return true;
            },
            updateModel: function() {
                // Only update model if we are editing recurrence event
                if (this._isEditRecurrenceEvent) {
                    var isDisableRepeat = this._editThisInstanceOnlyContainer.find("#editthisinstanceonly").prop('checked');
                    this.model.set({isDisable: isDisableRepeat});
                }

                console.debug("Update model for repeat component");
            },
            render: function() {
                if (this.model.attributes.isUnsupportedRrule) {
                    this.$el.html($(this.unsupportedTemplate()).html());
                    this.$el.addClass("field-group");
                    if (!$.contains(this.fieldsDiv[0], this.$el[0])) {
                        this.fieldsDiv.append(this.$el);
                    }
                    return;
                }

                if (this._isEditRecurrenceEvent) {
                    if (this._editThisInstanceOnlyContainer.hasClass("hidden")) {
                        this._editThisInstanceOnlyContainer.removeClass("hidden");
                    }

                    this._editThisInstanceOnlyContainer.find("#editthisinstanceonly").prop('checked', this.model.attributes.isDisable);
                } else {
                    if (!this._editThisInstanceOnlyContainer.hasClass("hidden")) {
                        this._editThisInstanceOnlyContainer.addClass("hidden");
                    }
                }

                this.frequencyView.render();
                this.intervalView.render();
                this.recurEndView.render();
                this.repeatOnView.render();

                // concat el to fieldsDiv
                this.fieldsDiv.append(this.$el);

                console.debug("Render repeat component: " + JSON.stringify({
                    innerHtml : this.$el.html(),
                    modelAttrs: this.model.attributes
                }));
            }
        });

        return repeatComponentView;
    });
