define("tc/repeat-frequency",
    [
        "jquery",
        "tc/rrule",
        "tc-backbone",
        "tc/calendar-util",
        "underscore",
        "tc/repeat-base-child-component"
    ],
    function (
        $,
        TCRRule,
        Backbone,
        CalUtil,
        _,
        BaseChildComponentView
    ) {
        "use strict";

        var repeatFrequencyView = BaseChildComponentView.extend({
            template: Confluence.TeamCalendars.Templates.Fields.repeatFrequency,
            _freqSelect: null,
            events: {
                "change select#freq-select": "updateModel"
            },
            /**
             * This view relies on freq attribute of model
             */
            initialize: function (options) {
                var modelAttributes = this.model.attributes;

                this.setJQueryEl(options.$el);

                this.$el.html($(this.template()).html());
                this._freqSelect = this.$el.find("select#freq-select");
                if ($.fn.auiSelect2) {
                    // only enable select2 if we have it
                    this._freqSelect.auiSelect2({
                        minimumResultsForSearch: -1
                    });
                }

                var frequencySelection = "";
                switch(TCRRule.FREQUENCIES[modelAttributes.freq]) {
                    case TCRRule.FREQUENCIES[TCRRule.WEEKLY]:
                    case TCRRule.FREQUENCIES[TCRRule.DAILY]:
                    case TCRRule.FREQUENCIES[TCRRule.MONTHLY]:
                    case TCRRule.FREQUENCIES[TCRRule.YEARLY]:
                        frequencySelection = TCRRule.FREQUENCIES[modelAttributes.freq];
                        break;
                    case TCRRule.FREQUENCIES[TCRRule.HOURLY]:
                    case TCRRule.FREQUENCIES[TCRRule.MINUTELY]:
                    case TCRRule.FREQUENCIES[TCRRule.SECONDLY]:
                    default:
                        // no value
                        frequencySelection = "";
                }
                // view model for this view
                this.model.set({frequencySelection: frequencySelection});
                this.model.on('change:isDisable', this.render, this);
                this.model.on('change:frequencySelection', this.render, this);
                this.model.on('rrule-string', this.updateModel, this);
            },
        /**
             *  For updating model
             */
            updateModel: function() {
                var modelAttributes = this.model.attributes;
                if (modelAttributes.isDisable){
                    console.debug("Won't update model for repeat frequency component because model is disable state");
                    return;
                }

                var selected = this._freqSelect.val();
                this.model.set({frequencySelection: selected});
                this.model.set({freq: TCRRule.FREQUENCIES.indexOf(selected)});
                console.debug("Update model for repeat frequency component");
            },
            /**
             * Rendering whatever value in model except WEEKLY
             *
             * @returns {repeatFrequencyView}
             */
            render: function() {
                var modelAttributes = this.model.attributes;
                if (this.hideIfNotMatch &&
                    this.hideIfNotMatch(this._notShowInFrequency, modelAttributes.frequencySelection, this.$el)) {
                    return;
                }

                if ($.fn.auiSelect2) {
                    this._freqSelect.auiSelect2("enable");
                    this._freqSelect.auiSelect2('val', modelAttributes.frequencySelection);
                } else {
                    this._freqSelect.prop("disabled", false);
                    this._freqSelect.val(modelAttributes.frequencySelection);
                }

                console.debug("Render repeat frequency component: " + JSON.stringify({
                    innerHtml : this.$el.html(),
                    modelAttrs: modelAttributes
                }));

                // Disable after fill up data
                if (modelAttributes.isDisable) {
                    console.debug("Disable repeat frequency component because model is disable state");
                    if ($.fn.auiSelect2) {
                        console.debug("AUI disable only");
                        this._freqSelect.auiSelect2("disable");
                    } else {
                        console.debug("Normal disable");
                        this._freqSelect.prop("disabled", true);
                    }
                }
            }
        });

        return repeatFrequencyView;
    });