define("tc/repeat-interval",
    [
        "jquery",
        "tc/rrule",
        "tc-backbone",
        "tc/calendar-util",
        "underscore",
        "tc/repeat-base-child-component"
    ],
    function (
        $,
        TCRRule,
        Backbone,
        CalUtil,
        _,
        BaseChildComponentView
    ) {
        "use strict";

        var repeatIntervalView = BaseChildComponentView.extend({
            template: Confluence.TeamCalendars.Templates.Fields.repeatInterval,
            _intervalTxtField: null,
            _intervalLabel: null,
            _notShowInFrequency: [""],
            events: {
                "change input#repeat-interval-txtField": "updateModel"
            },
            /**
             * This view relies on freq and interval attributes of model
             */
            initialize: function (options) {
                this.setJQueryEl(options.$el);

                this.$el.html($(this.template()).html());
                this._intervalLabel = this.$el.find(".interval-label");
                this._intervalTxtField = this.$el.find("#repeat-interval-txtField");

                this.model.on('change:frequencySelection', this.render, this);
                this.model.on('change:isDisable', this.render, this);
                this.model.on('rrule-string', this.updateModel, this);

                this.model.set({interval: this.model.attributes.interval || 1});
            },
            /**
             *  For updating model.
             *  We call this method on both UI changes and 'rrule-string' which means that
             *  we won't remember last inputted value
             */
            updateModel: function() {
                var modelAttributes = this.model.attributes;
                if (this.hideIfNotMatch &&
                    this.hideIfNotMatch(this._notShowInFrequency, modelAttributes.frequencySelection, this.$el)) {
                    this.model.set({interval: null});
                    return;
                }

                var modelAttributes = this.model.attributes;
                if (modelAttributes.isDisable){
                    console.debug("Won't update model for repeat interval component because model is disable state");
                    return;
                }

                var intervalVal = this._intervalTxtField.val();
                intervalVal = parseInt(intervalVal);
                intervalVal = intervalVal >= 1 ? intervalVal : 1;
                this.model.set({interval: intervalVal});
                console.debug("update model for repeat interval component");
                this.render();
            },
            /**
             * Rendering interval setting
             */
            render: function (){
                var modelAttributes = this.model.attributes;
                if (this.hideIfNotMatch &&
                    this.hideIfNotMatch(this._notShowInFrequency, modelAttributes.frequencySelection, this.$el)) {
                    return;
                }

                this._intervalTxtField.prop("readonly", false);
                this._intervalTxtField.val(modelAttributes.interval);
                this._createLabelInterval(modelAttributes.frequencySelection, this._intervalTxtField.val(), this._intervalLabel);

                console.debug("Render repeat interval component: " + JSON.stringify({
                    innerHtml : this.$el.html(),
                    modelAttrs: modelAttributes
                }));

                // Disable after fill up data
                if (modelAttributes.isDisable) {
                    console.debug("Disable repeat interval because model is disable state");
                    this._intervalTxtField.prop("readonly", true);
                    this._intervalTxtField.prop("disabled", true);
                } else {
                    this._intervalTxtField.prop("readonly", false);
                    this._intervalTxtField.prop("disabled", false);
                }
            },
            /**
             * Update interval label according to selectedFreq value
             * @param selectedFreq
             * @param interval
             * @param intervalSpan
             * @private
             */
            _createLabelInterval : function(selectedFreq, interval, intervalSpan) {
                if (/^[1-9]\d*$/.test(interval) || interval === "0") {
                    if (selectedFreq === "DAILY") {
                        intervalSpan.text(
                            parseInt(interval) > 1 ? AJS.I18n.getText("calendar3.repeat.interval.days") :
                                AJS.I18n.getText("calendar3.repeat.interval.day"));
                    } else if (selectedFreq === TCRRule.FREQUENCIES[TCRRule.WEEKLY]) {
                        intervalSpan.text(
                            parseInt(interval) > 1 ? AJS.I18n.getText("calendar3.repeat.interval.weeks") :
                                AJS.I18n.getText("calendar3.repeat.interval.week"));
                    } else if (selectedFreq === TCRRule.FREQUENCIES[TCRRule.MONTHLY]) {
                        intervalSpan.text(
                            parseInt(interval) > 1 ? AJS.I18n.getText("calendar3.repeat.interval.months") :
                                AJS.I18n.getText("calendar3.repeat.interval.month"));
                    } else if (selectedFreq === TCRRule.FREQUENCIES[TCRRule.YEARLY]) {
                        intervalSpan.text(
                            parseInt(interval) > 1 ? AJS.I18n.getText("calendar3.repeat.interval.years") :
                                AJS.I18n.getText("calendar3.repeat.interval.year"));
                    }
                } else {
                    intervalSpan.text("");
                }
            }
        });


        return repeatIntervalView;
    });