define("tc/repeat-recur-end",
    [
        "jquery",
        "confluence/date-time",
        "tc/rrule",
        "tc-backbone",
        "tc/calendar-util",
        "underscore",
        "tc/repeat-base-child-component"
    ],
    function (
        $,
        dateTime,
        TCRRule,
        Backbone,
        CalUtil,
        _,
        BaseChildComponentView
    ) {
        "use strict";
        var recurEndView = BaseChildComponentView.extend({
            template: Confluence.TeamCalendars.Templates.Fields.repeatRecurEnd,
            _recurEndNeverChbox: null,
            _recurEndTimesChBox: null,
            _recurEndTimesTxt: null,
            _recurEndUtilChBox: null,
            _recurEndUtilDatePicker: null,
            _notShowInFrequency: [""],
            _calendarDiv: null,
            _calendarPlugin: null,
            events: {
                "change input#recur-end-times-txtField": "updateModel",
                "change input[type='radio']": "updateModel",
            },
            /**
             * This view relies on count and until attributes of model
             */
            initialize: function (options) {
                if (!this.validateInput()){
                    this.model.set({isUnsupportedRrule: true});
                    return;
                }

                this.setJQueryEl(options.$el);

                this.$el.html($(this.template()).html());
                this._calendarDiv = options._calendarDiv;
                this._calendarPlugin = options._calendarPlugin;
                this._recurEndNeverChbox = this.$el.find("#recur-end-never");
                this._recurEndTimesChBox = this.$el.find("#recur-end-times");
                this._recurEndTimesTxt = this.$el.find("#recur-end-times-txtField");

                this._recurEndUtilChBox = this.$el.find("#recur-end-until");
                this._recurEndUtilDatePicker = this.$el.find("input.datepicker-field#until");

                // register some attributes as view model for this view
                var attributes = this.model.attributes;
                var isSelectedEndNever = (attributes.count === null || attributes.count === 0) && attributes.until === null;
                var isSelectedEndTimes = isSelectedEndNever ? !isSelectedEndNever : attributes.count > 0;
                var isSelectedEndUntil = isSelectedEndNever ? !isSelectedEndNever : attributes.until !== null;

                if (attributes.until == null){
                    this.model.set({ until: this.model.event.start });
                }
                this.model.set({isSelectedEndNever: isSelectedEndNever});
                this.model.set({isSelectedEndTimes: isSelectedEndTimes});
                this.model.set({isSelectedEndUntil: isSelectedEndUntil});

                this.model.on('change:isDisable', this.render, this);
                this.model.on('change:frequencySelection', this.recalculateRecurEndDate, this);
                this.model.on('change:startDate', this.recalculateRecurEndDate, this);

                this.model.on('rrule-string', this.updateModel, this);
            },
            recalculateRecurEndDate: function() {
                var attributes = this.model.attributes;
                var startDate = attributes.startDate;
                var frequencySelection = attributes.frequencySelection;
                if (!attributes.isDisable && startDate && frequencySelection) {
                    var until =  new Date(startDate);
                    switch(frequencySelection) {
                        case 'DAILY':
                            until.setMonth(startDate.getMonth() + 1);
                            break;
                        case 'WEEKLY':
                            until.setMonth(startDate.getMonth() + 3);
                            break;
                        case 'MONTHLY':
                            until.setMonth(startDate.getMonth() + 12);
                            break;
                        case 'YEARLY':
                            until.setMonth(startDate.getMonth() + 12 * 5);
                            break;
                    }
                    if (attributes.isSelectedEndUntil) {
                        this.model.set({until : until});
                    } else {
                        this._lastCalculatedUntil = until;
                    }
                }
                this.render();
            },
            validateInput: function () {
                var attributes = this.model.attributes;
                // ical4j RRULE sets COUNT=-1 after deleting future events - i.e. if count is not set it can be null or -1
                // and we don't allow users to set count = 0
                if (attributes.count > 0 && attributes.until) {
                    console.debug("Validate failed on repeat end because having both 'count' and 'until'");
                    return false;
                }

                return true;
            },
            /**
             *  For updating model according to selected option
             *
             *  From UI to Model
             */
            updateModel: function() {
                var modelAttributes = this.model.attributes;
                if (this.hideIfNotMatch &&
                    this.hideIfNotMatch(this._notShowInFrequency, modelAttributes.frequencySelection, this.$el)) {
                    // if not visible then those attributes should be empty
                    this.model.set({count : null, until: null});
                    return;
                }

                if (modelAttributes.isDisable){
                    console.debug("Won't update model for repeat recur end component because model is disable state");
                    return;
                }

                var isSelectedEndNever = this._recurEndNeverChbox.is(':checked');
                var isSelectedEndTimes = this._recurEndTimesChBox.is(':checked');
                var isSelectedEndUntil = this._recurEndUtilChBox.is(':checked');
                var updatedCount = modelAttributes.count > 0 ? modelAttributes.count : 1;
                var updatedUntil = modelAttributes.until || this.model.event.start;

                if(isSelectedEndNever) {
                    updatedCount = null;
                    updatedUntil = null;
                } else if (isSelectedEndTimes) {
                    var count = this._recurEndTimesTxt.val();
                    updatedCount = count && count >= 1 ? count : updatedCount;
                    updatedUntil = null;
                } else if (isSelectedEndUntil) {
                    if (this._lastCalculatedUntil) {
                        updatedUntil = this._lastCalculatedUntil;
                        this._lastCalculatedUntil = null;
                    } else {
                        var endUntilDateOnly = this._recurEndUtilDatePicker.val();
                        var selectedDate = dateTime.parse(endUntilDateOnly);
                        updatedUntil = selectedDate || null;
                    }
                    updatedCount = null;
                }

                // Notify change to update UI
                this.model.set({count: updatedCount});
                this.model.set({until: updatedUntil});
                this.model.set({untilDateOnly: endUntilDateOnly});
                this.model.set({isSelectedEndNever: isSelectedEndNever});
                this.model.set({isSelectedEndTimes: isSelectedEndTimes});
                this.model.set({isSelectedEndUntil: isSelectedEndUntil});
                console.debug("Update model for repeat recur end component: " + JSON.stringify({
                    innerHtml : this.$el.html(),
                    modelAttrs: modelAttributes
                }));
                this.render();
            },
            /**
             * Rendering option based on value we have in our model
             *
             * From Model to UI
             */
            render: function (){
                var modelAttributes = this.model.attributes;
                if (this.hideIfNotMatch &&
                    this.hideIfNotMatch(this._notShowInFrequency, modelAttributes.frequencySelection, this.$el)) {
                    return;
                }

                // First enable UI component
                this._recurEndNeverChbox.prop("disabled", false);
                this._recurEndTimesChBox.prop("disabled", false);
                this._recurEndTimesTxt.prop("disabled", false);
                this._recurEndTimesTxt.prop("readonly", false);
                this._recurEndUtilChBox.prop("disabled", false);

                // Check option never end
                if (modelAttributes.isSelectedEndNever) {
                    this.changeStateOfEndNever(true);
                    this.changeStateOfEndTimes(false);
                    this.changeStateOfEndUtil(false);
                }

                // Check option end after times
                if (modelAttributes.isSelectedEndTimes) {
                    this.changeStateOfEndNever(false);
                    this.changeStateOfEndTimes(true);
                    this.changeStateOfEndUtil(false);
                }

                // Check option end until
                if (modelAttributes.isSelectedEndUntil) {
                    this.changeStateOfEndNever(false);
                    this.changeStateOfEndTimes(false);
                    this.changeStateOfEndUtil(true);
                }

                // Disable after fill up data
                if (modelAttributes.isDisable) {
                    console.debug("Disable repeat recur end because model is disable state");
                    this._recurEndNeverChbox.prop("disabled", true);
                    this._recurEndTimesChBox.prop("disabled", true);
                    this._recurEndTimesTxt.prop("disabled", true);
                    this._recurEndUtilChBox.prop("disabled", true);
                    this._recurEndUtilDatePicker.prop("disabled", true);
                }

                console.debug("Render repeat recur end component: " + JSON.stringify({
                    innerHtml : this.$el.html(),
                    modelAttrs: modelAttributes
                }));
            },
            changeStateOfEndNever: function(isEnable) {
                // enable by default
                this._recurEndNeverChbox.prop('checked', isEnable);
            },
            changeStateOfEndTimes: function(isEnable) {
                var attributes = this.model.attributes;
                var recurEndTimesTxt = this._recurEndTimesTxt;
                this._recurEndTimesChBox.prop('checked', isEnable);
                if (isEnable) {
                    recurEndTimesTxt.prop("disabled", false);
                    recurEndTimesTxt.prop("readonly", false);
                    recurEndTimesTxt.val(attributes.count > 0 ? attributes.count : 1);
                } else {
                    recurEndTimesTxt.prop("disabled", true);
                    recurEndTimesTxt.prop("readonly", true);
                    recurEndTimesTxt.val("");
                }
            },
            changeStateOfEndUtil: function (isEnable) {
                var attributes = this.model.attributes;
                var recurEndUtilDatePicker = this._recurEndUtilDatePicker;

                this._recurEndUtilChBox.prop('checked', isEnable);
                if (isEnable) {
                    recurEndUtilDatePicker.prop('disabled', false);
                    if (attributes.until) {
                        recurEndUtilDatePicker.val(dateTime.formatPlainDate(attributes.until));
                    }
                } else {
                    recurEndUtilDatePicker.prop('disable', true);
                }
            },
        });

        return recurEndView;
    });
