define("tc/update-event",
    [
        "jquery",
        "tc/calendar-util",
        "tc/event-edit-analytics"
    ],
    function (
        $,
        CalUtil,
        eventEditAnalytics
    ) {
        "use strict";

        var eventEditCallbacks;

        var updateEvent = function(CalendarPlugin, calendarDiv, fieldsDiv, eventEditForm, fieldHandlers, dialog, data) {
            setEventCallbacks(CalendarPlugin, calendarDiv, fieldsDiv, eventEditForm, fieldHandlers, dialog, data)
            tryUpdateEvent(CalendarPlugin, calendarDiv, fieldHandlers, data, false);
        }

        var tryUpdateEvent = function(CalendarPlugin, calendarDiv, fieldHandlers, data, confirmRemoveInvalidUsers) {
            CalendarPlugin.updateEvent(
                calendarDiv,
                getData(confirmRemoveInvalidUsers, fieldHandlers, data),
                eventEditCallbacks.updateEventErrorCallback,
                eventEditCallbacks.updateEventSuccessCallback
            );
        }

        /*
        * Dialog shown when invalid users are present on the event
        */
        var confirmRemoveUsersDialog = function(CalendarPlugin, calendarDiv, fieldsDiv, eventEditForm, fieldHandlers, dialog, data) {
            var $confirmDialog = $(Confluence.TeamCalendars.Templates.userSaveConfirmation());

            $("#dialog-cancel-button", $confirmDialog).click(function () {
                dialog.show();
                AJS.dialog2($confirmDialog).remove();
                AJS.dim();
                CalendarPlugin.setProcessingEvent(calendarDiv, false, eventEditForm);
                return false;
            });

            $("#dialog-remove-and-save-button", $confirmDialog).click(
                function () {
                    AJS.dialog2($confirmDialog).remove();
                    fieldsDiv.closest('#edit-event-dialog').show();
                    AJS.dim();
                    tryUpdateEvent(CalendarPlugin, calendarDiv, fieldHandlers, data, true);
                    return false;
                });

            dialog.hide();
            AJS.dialog2($confirmDialog).show();
            return $confirmDialog;
        }

        var getData = function(confirmRemoveInvalidUsers, fieldHandlers, data) {
            var dataCopy = {
                confirmRemoveInvalidUsers: confirmRemoveInvalidUsers
            };
            dataCopy = $.extend(dataCopy, data);
            $.each(fieldHandlers, function(i, handler) {
                $.extend(dataCopy, removeUndefined(handler.getData()));
            });

            return dataCopy;
        }

        //HACK to convert undefined to "" so jQuery each will not ignore them
        function removeUndefined(data) {
            var fixedData = {};
            $.each(data, function(name, value) {
                if (value === undefined) {
                    fixedData[name] = "";
                } else {
                    fixedData[name] = value;
                }
            });
            return fixedData;
        }

        var setEventCallbacks = function (CalendarPlugin, calendarDiv, fieldsDiv, eventEditForm, fieldHandlers, dialog, data) {
            eventEditCallbacks = {
                updateEventErrorCallback : function(XMLHttpRequest, textStatus, errorThrown) {
                    CalendarPlugin.getCalendarPanel(calendarDiv).fullCalendar("unselect");
                    CalendarPlugin.showAjaxError(calendarDiv, XMLHttpRequest, textStatus, errorThrown, CalendarPlugin.ERROR_CLASS_EVENT_UPDATE);
                    CalendarPlugin.setProcessingEvent(calendarDiv, false, eventEditForm);
                },
                updateEventSuccessCallback : function(responseEntity) {
                    CalendarPlugin.getCalendarPanel(calendarDiv).fullCalendar("unselect");
                    CalendarPlugin.setGenericErrors(calendarDiv, null, CalendarPlugin.ERROR_CLASS_EVENT_UPDATE);
                    if (responseEntity.success) {
                        eventEditAnalytics.analyticEventTrigger(
                            calendarDiv,
                            {
                                rruleLength: (data.rruleStr || "").length,
                                eventType: data.eventType
                            },
                            data.uid,
                            data.eventType
                        );
                        Confluence.TeamCalendars.setFieldErrors(fieldsDiv, null);
                        var subCalendar = CalendarPlugin.getSubCalendar(calendarDiv, responseEntity.subCalendar.id);
                        if (!subCalendar) {
                            // New event type
                            var parentSubCalendar = CalendarPlugin.getSubCalendar(calendarDiv, responseEntity.subCalendar.parentId);
                            subCalendar = responseEntity.subCalendar;

                            //update list custom for change event type to other subcalendar
                            if(subCalendar.type === "custom" || subCalendar.subscriptionType === "custom") {
                                var rsCustomEventType = subCalendar.customEventTypes;
                                var parentCustomEventType = parentSubCalendar.customEventTypes;
                                if(rsCustomEventType && rsCustomEventType.length) {
                                    if(parentCustomEventType && parentCustomEventType.length) {
                                        var isExistCustomEventType = false;
                                        for(var i = 0; i < parentCustomEventType.length; i++) {
                                            if(parentCustomEventType[i].customEventTypeId === rsCustomEventType[0].customEventTypeId) {
                                                isExistCustomEventType = true;
                                                break;
                                            }
                                        }

                                        if(!isExistCustomEventType) {
                                            parentCustomEventType.push(rsCustomEventType[0]);
                                        }
                                    } else {
                                        parentSubCalendar.customEventTypes.push(rsCustomEventType[0]);
                                    }
                                }
                            }

                            parentSubCalendar.childSubCalendars = $.merge([ subCalendar ], parentSubCalendar.childSubCalendars || []);
                            CalendarPlugin.updateAvailableSubCalendarsInSubCalendarPanel(calendarDiv);
                            CalendarPlugin.addSubCalendarEventSource(calendarDiv, subCalendar.id);
                            if(data.originalEventSubCalendarId && responseEntity.subCalendar && (responseEntity.subCalendar.parentId !== data.originalSubCalendarId || subCalendar.id !== data.originalEventSubCalendarId)) {
                                CalendarPlugin.reloadSubCalendar(calendarDiv, data.originalEventSubCalendarId);
                            }
                        } else {
                            // Existing event type
                            var listSubcalendarId = [subCalendar.id];
                            if(data.originalEventSubCalendarId && (subCalendar.id !== data.originalEventSubCalendarId || responseEntity.subCalendar.parentId !== data.originalSubCalendarId )) {
                                listSubcalendarId.push(data.originalEventSubCalendarId);
                            }
                            CalendarPlugin.reloadSubCalendar(calendarDiv, listSubcalendarId);
                        }
                        dialog.remove();
                        CalendarPlugin.setProcessingEvent(calendarDiv, false, eventEditForm);
                    } else {
                        var fieldErrors = responseEntity.fieldErrors;
                        var validFieldErrorsCount = Confluence.TeamCalendars.setFieldErrors(fieldsDiv, fieldErrors);
                        if (!validFieldErrorsCount && fieldErrors.filter(function (el) {return el.field === "invaliduser"}).length > 0) {
                            confirmRemoveUsersDialog(CalendarPlugin, calendarDiv, fieldsDiv, eventEditForm, fieldHandlers, dialog, data);
                        } else {
                            CalendarPlugin.setProcessingEvent(calendarDiv, false, eventEditForm);
                        }
                    }

                    var firstErrorField = dialog.getCurrentPanel().body.find('.field-group:has(.error:has(div)):visible input')[0];
                    firstErrorField && firstErrorField.focus();
                }
            }
        }

        return {
            updateEvent : updateEvent,
        }
    });
