define("tc/non-space-calendars-handler",
    [
        "jquery",
        "underscore",
        "tc/calendar-util",
        "tc/non-space-calendars-warning-view"
    ],
    function (
        $,
        _,
        CalUtil,
        NonSpaceCalendarsWarningView
    ) {

        "use strict";

        var warningView;

        return {
            handle: function (CalendarPlugin, calendarDiv, cache, subCalendars) {
                // only show non-space message in my calendar view
                if (CalUtil.isMyCalendarView(calendarDiv)) {
                    var nonSpaceSubCalendars = _.filter(subCalendars, function (subCalendar) {
                        return subCalendar.eventsEditable && (subCalendar.spaceKey === undefined || subCalendar.spaceKey === "");
                    });

                    if (!warningView) {
                        warningView = new NonSpaceCalendarsWarningView({
                            el: ".non-space-calendars-warning",
                            CalendarPlugin: CalendarPlugin,
                            _calendarDiv: calendarDiv,
                            cache: cache
                        });
                    }

                    warningView.render(nonSpaceSubCalendars);
                }
            }
        };
    }
);