define("tc/migrate-space-calendars-settings",
    [
        "ajs",
        "tc/templates",
        "tc/rebuild-data-settings"
    ],
    function (
        AJS,
        Templates,
        RebuildDataSetting
    )
    {
        "use strict";

        var MigrateSpaceCalendarsSettings = RebuildDataSetting.extend({

            initialize: function () {
                var options = {
                    url: "/migration/spacecalendars",
                    container: "#rebuild-space-calendars",
                    button: "button.rebuild-space-calendars",
                    loggingDiv: "#logs-rebuild-space-calendars"
                };

                RebuildDataSetting.prototype.initialize.apply(this, [options]);
            },

            renderSuccess: function () {
                return Templates.rebuildData(this.buildRenderParams(
                        "success",
                        AJS.I18n.getText("calendar3.admin.spacecalendars.rebuild.info.success.label"),
                        AJS.I18n.getText("calendar3.admin.spacecalendars.rebuild.info.success")))

            },

            renderError: function () {
                return Templates.rebuildData(that.buildRenderParams(
                        "fail",
                        AJS.I18n.getText("calendar3.admin.spacecalendars.rebuild.info.fail.label"),
                        AJS.I18n.getText("calendar3.admin.spacecalendars.rebuild.info.fail")))

            },

            renderProcessing: function () {
                return Templates.rebuildData(this.buildRenderParams(
                        "process",
                        AJS.I18n.getText("calendar3.admin.spacecalendars.rebuild.info.process.label"),
                        AJS.I18n.getText("calendar3.admin.spacecalendars.rebuild.info.process")));
            }
        });

        return MigrateSpaceCalendarsSettings;
});