define("tc/rebuild-data-settings",
    [
        "jquery",
        "tc/util",
        "tc/templates"
    ],
    function (
        $,
        CalUtil,
        Templates
     )
    {
        "use strict";

        var RebuildDataSetting = Backbone.View.extend({

            initialize: function (options) {

                this.url = options.url;

                this.$container = $(options.container);
                this.$button = $(options.button, this.$container);
                this.$loggingDiv = $(options.loggingDiv);


                var that = this;
                this.$button.bind("click", function () {
                    that.disableButton();

                    that.$loggingDiv.html(that.renderProcessing());

                    var resultReindex = that.sendRequest(CalUtil.getRestBaseUrl() + that.url);

                    resultReindex.done(function(response) {
                        that.$loggingDiv.empty();

                        if(response.success === true) {
                            that.$loggingDiv.html(that.renderSuccess());
                        } else {
                            that.$loggingDiv.html(that.renderError());
                        }

                        that.enableButton();
                    });
                });
            },

            buildRenderParams: function(status, title, description) {
                return {"status": status, title: title, description: description};
            },

            sendRequest : function (url) {
                return AJS.safe.ajax({
                    data: {},
                    contentType: "application/json",
                    type : "POST",
                    url : url
                });
            },
            disableButton : function() {
                this.$button.prop("disabled", true);
            },

            enableButton : function() {
                this.$button.prop("disabled", false);
            }
        });

        return RebuildDataSetting;
});