define("tc/child-subcalendar-entry-view",
    [
        "jquery",
        "tc-backbone",
        "tc/calendar-util",
        "tc/subcalendar-menu-view",
        "tc/subcalendar-displayer"
    ],
    function (
        $,
        Backbone,
        CalUtil,
        SubCalendarMenuView,
        SubCalendarDisplayer
    ) {

        "use strict";

        var ChildSubCalendarEntryView = Backbone.View.extend({
            initialize: function(options) {
                this.cache = options.cache;
                this.parentSubCalendar = options.parentSubCalendar;
                this.childSubCalendar = options.childSubCalendar;
                this.customEventType = options.customEventType;
                this.CalendarPlugin = options.CalendarPlugin;
                this._calendarDiv = options._calendarDiv;

                this.parentView = options.parentView;
                this.template = options.template;
            },

            render: function() {
                this.$el.html(this.template({
                    "childSubCalendar": this.childSubCalendar,
                    "customEventType": this.customEventType
                }));

                this.entryView = this.$(".child-subcalendar");
                this.entryView.hover(this._onHover.bind(this));
                this.entryView.click(this._onClick.bind(this)); // Encompasses entire lozenge including checkbox

                var options = {
                    "cache": this.cache,
                    "CalendarPlugin": this.CalendarPlugin,
                    "_calendarDiv": this._calendarDiv,

                    "subCalendar": this.childSubCalendar,
                    "parentSubCalendar": this.parentSubCalendar,
                    "subCalendarEntryView": this.entryView,

                    "autoConvertSupported": this.CalendarPlugin.isAutoConvertSupported(this._calendarDiv),
                    "subCalendarClasses": this.CalendarPlugin.getParameter(this._calendarDiv, "subCalendarColorClass")
                };

                if (this.customEventType) {
                    options.template = Confluence.TeamCalendars.Templates.customEventTypeMenu;
                } else {
                    options.template = Confluence.TeamCalendars.Templates.childSubCalendarMenu;
                }

                this.entryView.append(new SubCalendarMenuView(options).render());

                this._ellipsisChildSubCalendarName();

                this.subcalendarDisplayer = new SubCalendarDisplayer({
                    CalendarPlugin: this.CalendarPlugin,
                    _calendarDiv: this._calendarDiv,
                    entryView: this.entryView,
                    subCalendar: this.childSubCalendar,
                    parentView: this.parentView,
                    parentSubCalendar: this.parentSubCalendar
                });

                return this.$el;
            },

            _ellipsisChildSubCalendarName: function () {
                var $childSubCalendarName = this.$(".child-subcalendar-name");
                if(!$childSubCalendarName.attr("threedots")) {
                    $childSubCalendarName.attr("title", this.$(".ellipsis_text").text());
                }
            },

            _onHover: function() {
                this.entryView.toggleClass("active-child-subcalendar");
            },

            _onClick: function(event) {
                if ($(event.target).closest('.subcalendar-dropdown-menu').length > 0) {
                    // Don't switch event visibility when options is pressed
                    return;
                }

                this.subcalendarDisplayer.toggleVisibility();
            }
        });

        return ChildSubCalendarEntryView;
    }
);
