define("tc/subcalendar-panel",
    [
        "jquery",
        "tc/calendar-util",
        "tc/myCalendarTour",
        "tc/subcalendar-entry-view",
        "tc/subcalendar-menu-builder",
        "tc/non-space-calendars-handler",
        "tc/event-edit-dialog",
        "tc/calendar-caldav-subscribe-model",
        "tc/subcalendar-subscribe-dialog",
        "tc/calendar-caldav-subscribe-service",
        "confluence/meta"
    ],
    function (
        $,
        CalUtil,
        CalendarTour,
        SubCalendarEntryView,
        SubCalendarMenuBuilder,
        nonSpaceCalendarsHandler,
        EventEditDialog,
        CalendarSubscribeModel,
        CalendarSubscribeDialog,
        CalendarSubscribeService,
        Meta
    )
    {
        "use strict";

        var isAnonymous = Meta.get('remote-user') === '';

        var SubCalendarPanel = function(CalendarPlugin, calendarDiv, cache) {
            var subCalendarNamesDiv = $("div.sub-calendar-names", calendarDiv);

            //Add an entry to the subCalendar panel for subcalendar
            var createCalendarEntry = function(subCalendar) {

                var subCalendarEntry = (function() {
                    var theEntry = new SubCalendarEntryView({
                        "CalendarPlugin": CalendarPlugin,
                        "subCalendar": subCalendar,
                        "_calendarDiv": calendarDiv,
                        "cache": cache
                    }).render();

                    return theEntry;
                })();

                return subCalendarEntry;
            };

            //Show/hide the quick create event button
            var initAddEventButton = function() {
                if (CalendarPlugin.getSubCalendarsWhichCanAddEvents(calendarDiv).length) {
                    $(".add-event-button", calendarDiv).removeClass("hidden");
                } else {
                    $(".add-event-button", calendarDiv).addClass("hidden");
                }
            };

            var initSubscribeButton = function () {
                if (!isAnonymous && CalendarPlugin.getSubCalendars(calendarDiv).length) {
                    $(".subscribe-calendar-button").removeClass("hidden");
                }
                else {
                    $(".subscribe-calendar-button").addClass("hidden");
                }
            };

            //Show/hide the add calendar button
            //Note: In conf versions < 5 there is both an 'Add Calendar' and 'Add Jira Calendar' button.
            //In conf 5+ we use a single split button.
            var initAddCalendarButton = function() {
                if ("true" === CalendarPlugin.getParameter(calendarDiv, "readOnly")) {
                    $("#add-calendar-menu").addClass("hidden");
                }
                else {
                    $("#add-calendar-menu").removeClass("hidden");
                }
            };

            var showNoCalendarsMessage = function() {
                $("<div/>", {
                    "class" :"no-subcalendars-msg",
                    "text" : AJS.I18n.getText("calendar3.havenotcreatedorsubscribedtosubcalendars")
                }).appendTo(subCalendarNamesDiv);
            };

            var updateWatchingStatusForSubCalendarMenuOptions = function (subCalendarNamesDiv, subCalendars) {
                var parentSubCalendars = $.grep(subCalendars, function (element, index) {
                    return element.type === "parent" || element.subscriptionType === "parent";
                });

                var successCallback = function(watchingStatuses) {
                    var $items = $(subCalendarNamesDiv).find(".subcalendar-item");

                    $items.each(function (index, item) {
                        var $item = $(item);
                        var subCalendarId = $item.data("sub-calendar-id");
                        var matchedItems = $.grep(watchingStatuses, function(ws){ return ws.subCalendarId == subCalendarId; });
                        var isHideWatchMenuItem = CalendarPlugin.getParameter(calendarDiv, "hideWatchMenuItem") === "true";

                        if (matchedItems.length > 0 && matchedItems[0].isWatchable && !isHideWatchMenuItem) {
                            var className = "not-watched";
                            if (matchedItems[0].watchedViaContent) {
                                className = "watching-via-content";
                            } else if (matchedItems[0].watched) {
                                className = "watched";
                            }

                            $item.addClass(className);
                        }

                        //disable loading watching status
                        $item.addClass("disable-loading-watching-status");
                        CalendarTour.reposition();
                    });

                    AJS.trigger("calendar.watch.statuses.loaded", watchingStatuses);
                };

                var requestData = { };
                var parentSubCalendarIds = $.map(parentSubCalendars , function (parentSubCalendar, i) {
                    return parentSubCalendar.id;
                });
                requestData.include = parentSubCalendarIds ;

                $.ajax({
                    cache : false,
                    data : requestData,
                    dataType : "json",
                    error : function(XMLHttpRequest, textStatus, errorThrown) {
                        CalendarPlugin.showAjaxError(calendarDiv, XMLHttpRequest, textStatus, errorThrown, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_LIST);
                    },
                    success : function(responseEntity) {
                        if (responseEntity.success) {
                            var watchingStatuses = responseEntity.payload;
                            successCallback(watchingStatuses);

                            CalendarPlugin.setGenericErrors(calendarDiv, null, CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_LIST);
                        } else {
                            CalendarPlugin.setGenericErrors(calendarDiv, AJS.I18n.getText("calendar3.error.unknown"), CalendarPlugin.ERROR_CLASS_SUB_CALENDAR_LIST);
                        }
                    },
                    type: "GET",
                    timeout: CalendarPlugin.ajaxTimeout,
                    url : Confluence.TeamCalendars.getCalendarServiceBaseUrl("/subcalendars/watching/status.json")
                });
            };

            //Set the menu options and display name for each subcalendar and child subcalendar
            var setSubCalendarMenuOptions = function(subCalendars) {
                SubCalendarMenuBuilder.build(calendarDiv, CalendarPlugin, subCalendars);
            };

            return {
                initSubCalendarPanel: function() {
                    var showAddEventDialog = function(_calendarDiv) {
                        new EventEditDialog().getEditEventDialog({
                                start : new Date(),
                                localizedStartTime : CalendarPlugin.getDefaultStartTime(),
                                localizedEndTime : CalendarPlugin.getDefaultEndTime(),
                                allDay : (_calendarDiv.data(CalendarPlugin.PREF_LAST_ALL_DAY_USED) || "true") === "true"
                            },
                            null,
                            CalendarPlugin,
                            calendarDiv).show();
                    };

                    $(".calendar-toolbar .add-event-button", calendarDiv).click(function() {
                        showAddEventDialog(calendarDiv);
                        return false;
                    });

                    $(".subscribe-calendar-button", calendarDiv).click(function(){
                        var subCalendars = CalendarPlugin.getSubCalendars(calendarDiv);
                        var service = new CalendarSubscribeService(CalendarPlugin, calendarDiv);
                        var model = new CalendarSubscribeModel({
                            subCalendars: subCalendars,
                            baseUrl: CalUtil.getParameter(calendarDiv, "baseUrl"),
                            isPrivateUrlsEnabled: CalendarPlugin.getParameter(calendarDiv, "privateUrlsEnabled"),
                            privateUrlProvider: _.bind(service.getPrivateUrlProvider, service)
                        });
                        var subscribeDialogView = new CalendarSubscribeDialog({
                            calendarPlugin: CalendarPlugin,
                            calendarDiv: calendarDiv,
                            model: model
                        });
                        subscribeDialogView.render();
                        return false;
                    });

                    var spinnerDefer = CalendarPlugin.setSubCalendarSpinnerIconVisible(true);
                    var resolveSpinner = function(){
                        if (spinnerDefer) spinnerDefer.resolve();
                    };

                    CalendarPlugin.refreshCachedSubCalendars(calendarDiv, function(subCalendars) {
                        if ("true" === CalendarPlugin.getParameter(calendarDiv, "showHiddenSubCalendars") && $.isArray(subCalendars)) {
                            $.each(subCalendars, function(subCalendarIdx, subCalendar) {
                                subCalendar.eventsHidden = false;
                            });
                        }

                        CalendarPlugin.updateAvailableSubCalendarsInSubCalendarPanel(calendarDiv);
                        CalendarPlugin.getRenderedMacroCallbackHandler(calendarDiv).refreshCalendarInfo(subCalendars);
                        resolveSpinner();

                        if (CalendarPlugin.isCalendarInEditMode(calendarDiv)) {
                            var popupDialogForFirstUses = function() {
                                calendarDiv.unbind("calendar-plugin.resized", popupDialogForFirstUses);

                                if ("true" === CalendarPlugin.getParameter(calendarDiv, "isShowCalendarWizard"))
                                {
                                    var showPopularDialog = function() {
                                        Confluence.TeamCalendars.Dialogs.getSubCalendarSubscribeDialog({
                                            heading: AJS.I18n.getText("calendar3.welcometoconfluencecalendars"),
                                            callbackHandler: CalendarPlugin.getRenderedMacroCallbackHandler(calendarDiv)
                                        }).show();
                                    };

                                    var showCalendarDialog = function() {
                                        Confluence.TeamCalendars.Dialogs.getAddDialog(
                                            CalendarPlugin.getRenderedMacroCallbackHandler(calendarDiv),
                                            {
                                                title : AJS.I18n.getText("calendar3.welcometoconfluencecalendars"),
                                                addClass : "create-calendar-first-time"
                                            }
                                        );
                                    };

                                    CalUtil.showCalendarPopupHaveAnEmptySubcalendar(showPopularDialog, showCalendarDialog);
                                }
                            };

                            calendarDiv.bind("calendar-plugin.resized", popupDialogForFirstUses);
                        }
                    }, function() {
                        resolveSpinner();
                    });
                },

                updateAvailableSubCalendarsInSubCalendarPanel : function() {
                    subCalendarNamesDiv.empty();
                    initAddEventButton();
                    initSubscribeButton();
                    initAddCalendarButton();

                    var subCalendars = CalUtil.getSortedSubCalendarsByTypeAndName(CalendarPlugin.getSubCalendars(calendarDiv));
                    setSubCalendarMenuOptions(subCalendars);

                    window.isTeamCalendarsLoaded = true;

                    // if no calendars
                    if (!subCalendars.length) {
                        CalUtil.toggleNoCalendarPage(true);
                        $(".no-calendar-page #add-button").click(function (event) {
                            Confluence.TeamCalendars.Dialogs.getAddDialog(CalendarPlugin.getRenderedMacroCallbackHandler(calendarDiv));
                            event.preventDefault();
                        });
                        showNoCalendarsMessage();
                    } else {
                        CalUtil.toggleNoCalendarPage(false);
                    }

                    $.each(subCalendars, function (idx, subCalendar) {
                        subCalendarNamesDiv.append(createCalendarEntry(subCalendar));
                    });

                    if(!CalUtil.isSingleCalendarView(calendarDiv)) {
                        CalendarTour.start();
                    }


                    updateWatchingStatusForSubCalendarMenuOptions(subCalendarNamesDiv, subCalendars);


                    nonSpaceCalendarsHandler.handle(CalendarPlugin, calendarDiv, cache, subCalendars);

                }
            };
        };
        return SubCalendarPanel;
    }
);
