define("tc/user-timezone-setup",
    [
        "jquery",
        "tc/util",
        "tc-backbone",
        "tc/templates",
        "tc/form-state-control"
    ],
    function(
        $,
        Util,
        Backbone,
        Templates,
        FormStateControl) {
        "use strict";

    var UserTimeZoneSetup = Backbone.View.extend({
        dialog: null, //instance of AJS.ConfluenceDialog,
        options: null,

        $userTimeZoneSelectContainer: null,
        userTimeZone: "",
        isPDLEnabled: false,
        baseUrlRest: "",
        baseUrlCalendarService: "",
        ajaxTimeout: 120000,

        template: Templates.userTimezoneSetup(),

        defaults: {
            callbackHandler: null,
            textTitleDialog: AJS.I18n.getText("calendar3.setup.title"),
            textDescTimeZoneSetup: AJS.I18n.getText("calendar3.setup.timezonenotsetup"),
            textBtnOk: AJS.I18n.getText("ok")
        },

        initialize: function(options){
            this.options = $.extend({}, this.defaults, options);

            if (!this.options.callbackHandler) {
                AJS.debug("tc/user-timezone-setup: requires 'callbackHandler' object");
            }

            //TODO: should we move Confluence.TeamCalendars to an AMD module
            var TeamCalendars = Confluence.TeamCalendars;
            this.userTimeZone = TeamCalendars.getUserTimeZone();
            this.isPDLEnabled = TeamCalendars.isPDLEnabled();
            this.baseUrlRest = TeamCalendars.getRestBaseUrl();
            this.baseUrlCalendarService = TeamCalendars.getCalendarServiceBaseUrl("/preferences/timezone.json");
            this.ajaxTimeout = TeamCalendars.ajaxTimeout;

            this.options.textDescTimeZoneSetup = AJS.format(this.options.textDescTimeZoneSetup, this.userTimeZone);
        },

        render: function(){
            this._createDialog();
            this._populateTimeZoneDropDown();
            return this.dialog;
        },

        _createDialog: function(){
            var that = this;

            //create dialog
            this.dialog = new AJS.Dialog({
                "width": 512,
                "height": this.isPDLEnabled ? 220 : 200,
                "id" : "team-calendars-timezone-setup-dialog"
            });

            this.dialog.addHeader(this.options.textTitleDialog);
            this.dialog.addPanel("", this.template, "setup-calendar-panel");

             //Set okay button
            this.dialog.addButton(this.options.textBtnOk, function() {
                that.dialog.hide();
                that.dialog.remove();
                // remove element that flags timezone setup is still required
                $('#team-calendars-show-timezone-setup').remove();
                that.options.callbackHandler.showCalendarWizard();
            }, "set-timezone-button");

            this.el = this.dialog.getCurrentPanel().body;
            this.$el = $(this.el);

            //set text
            this.$el.find(".user-time-zone-desc").text(this.options.textDescTimeZoneSetup);

            //Post to server to set timezone
            this.$userTimeZoneSelectContainer = this.$el.find(".user-time-zone-select");
            this.$userTimeZoneSelectContainer.removeClass("hidden");

            this.$userTimeZoneSelectContainer.find("select").change(_.bind(this._changeSelectionTimeZone, this));

            //tell the server not to send this message again
            this.options.callbackHandler.suppressMessage("MESSAGE_KEY_TIMEZONE_SETUP");
            return this.dialog;
        },

        _populateTimeZoneDropDown: function() {
            var that = this,
                timeZoneSelect = this.$el.find("#userTimeZoneSetupSelect"),
                okButton = this.dialog.popup.element.find(".set-timezone-button");

            FormStateControl.disableElement(okButton);
            that.$userTimeZoneSelectContainer.addClass("loading");

            $.ajax({
                type: "GET",
                url: this.baseUrlRest + "/timezones/user",
                success: function(timeZones) {
                    timeZoneSelect
                        .html(Templates.timeZoneDropDown(timeZones))
                        .val(that.userTimeZone)
                        // For some reasons, this attribute (might work with other attributes) has to be rmemoved
                        // so the dropdown height in IE is right.
                        // Doensn't matter if the select was actually disabled in the first place.
                        .prop("disabled", false);

                    that.$userTimeZoneSelectContainer.removeClass("loading");
                    FormStateControl.enableElement(okButton);
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    that.options.callbackHandler.showAjaxError(XMLHttpRequest, textStatus, errorThrown);
                    that.$userTimeZoneSelectContainer.removeClass("loading");
                },
                timeout: this.ajaxTimeout
            });
        },

        _changeSelectionTimeZone: function() {
            var that = this;

            this.$userTimeZoneSelectContainer.addClass("loading");

            var setTimeZoneButton = this.dialog.popup.element.find(".set-timezone-button").prop("disabled", true);
            var selectedOption = this.$userTimeZoneSelectContainer.find("option:selected");

            $.ajax({
                url: this.baseUrlCalendarService,
                cache: false,
                data: {
                    timeZoneId : selectedOption.val()
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    that.options.callbackHandler.showAjaxError(XMLHttpRequest, textStatus, errorThrown, "error-config-update");
                    setTimeZoneButton.prop("disabled", false);
                    that.$userTimeZoneSelectContainer.removeClass("loading");
                },
                success: function() {
                    that.options.callbackHandler.setGenericErrors(null, "error-config-update");
                    that.options.callbackHandler.setParameter("userTimeZoneId", selectedOption.val());
                    that.$el.find(".user-time-zone-desc").text(that.options.textDescTimeZoneSetup);
                    setTimeZoneButton.prop("disabled", false);
                    that.$userTimeZoneSelectContainer.removeClass("loading");
                },
                type: "PUT",
                timeout: this.ajaxTimeout
            });
        }
    });

    return UserTimeZoneSetup;
});