define('tc/event-macro-utilities', ['confluence/templates', 'ajs'], function (templates, AJS) {
    /**
     * Transforms comma separated list string into an array
     * @param {String} listString
     * @return {Array}
     */
    function parseCommaSeparatedList(listString) {
        if (!listString || !listString.trim()) return [];
        return listString.split(',').map(function(part) { return part.trim(); });
    }

    /**
     * Creates and returns html for a reply row in the replies table
     * @method buildReplyElement
     * @param occurrence macro id
     * @param eventMacroContainer jQuery element of macro container
     * @param {Object} replyRowParams Object containing reply info
     * @return {String} Html for the reply row
     */
    function buildReplyElement(occurrence, eventMacroContainer, replyRowParams) {
        replyRowParams.guests = replyRowParams.guests || 0;
        replyRowParams.occurrence = occurrence;
        replyRowParams.isAdmin = eventMacroContainer.data('context-is-admin');
        replyRowParams.hasComments = eventMacroContainer.data('context-has-comments');
        replyRowParams.allowGuests = eventMacroContainer.data('context-allow-guests');
        const columnList = parseCommaSeparatedList(eventMacroContainer.data('context-custom-columns'));
        const checkboxList = parseCommaSeparatedList(eventMacroContainer.data('context-custom-checkboxes'));

        replyRowParams.customColumnsList = columnList.map(function (columnKey) {
            return {
                key: columnKey,
                value: replyRowParams.customColumnsMap[columnKey]
            };
        });

        replyRowParams.customCheckboxesList = checkboxList.map(function(checkboxKey) {
            return {
                key: checkboxKey,
                value: replyRowParams.customCheckboxsMap[checkboxKey] ? AJS.I18n.getText("yes.name") : AJS.I18n.getText("no.name")
            };
        });

        return templates.TeamCalendars.EventMacro.replyTableRow(replyRowParams);
    }

    return {
        buildReplyElement: buildReplyElement
    };
});