// If you think this code is confusing I agree with you.
// See https://developer.atlassian.com/display/CONFDEV/Including+Information+in+your+Macro+for+the+Macro+Browser
// The reason it exists is to ensure that a value is set for the id parameter when a new macro is created.
define("tc/macro-browser-event-macro",
    ['jquery', 'tinymce'],
    function($, tinymceEditor) {
        var initTeamCalendarsMacroForBrowser = function () {
            var generateId = function (){
                return Math.random().toString(36).substring(2);
            };

            if (parseInt(tinymce.majorVersion) >= 4) {

                // Reset the `id` for pasted Event macro
                tinymceEditor.activeEditor.on('PastePostProcess', function(e) {
                    var macroSerializer = Confluence.MacroParameterSerializer;
                    var pastedEventMacros = e.node.querySelectorAll('.editor-inline-macro[data-macro-name="event"]');
                    if (pastedEventMacros.length === 0) {
                        return;
                    }
                    // IE does not support pastedEventMacros.forEach
                    Array.prototype.forEach.call(pastedEventMacros, function (macro) {
                        var params = macroSerializer.deserialize(macro.getAttribute('data-macro-parameters'));
                        params.id = generateId();
                        macro.setAttribute("data-macro-parameters", macroSerializer.serialize(params));
                    });
                });

            } else {
                // Tinymce 3.x code - can be deleted once support for Confluence with Tinymce 3.4 is dropped (probably 7.something)

                //handle copy and paste Event Macro
                tinymceEditor.activeEditor.onPostProcess.add(function(ed, pasteText) {
                    try {
                        //hack to get pasted text
                        // Beware that `PostProcess` event fires at each content serialization, which means pretty much after every change.
                        // This condition is abusing internal tinymce property and in 4.x API causes this routine to run each time -> resetting `id`.
                        if (pasteText.getInner) {
                            // find out whether pasted text contains macro (including nested macro) or not
                            if(pasteText.content.indexOf("editor-inline-macro") === -1) {
                                return;
                            }

                            // help JQuery to deal with all html element which has same level
                            var $pastedElement = $('<div>').html(pasteText.content);
                            $pastedElement.find('.editor-inline-macro').each(function(index, macroNode) {
                                var $macroNode = $(macroNode);
                                var macroDeserializer = Confluence.MacroParameterSerializer;
                                var isMacro = $macroNode.hasClass('editor-inline-macro');
                                if (isMacro) {
                                    var macroName = $macroNode.attr("data-macro-name");
                                    if (macroName === "event") {
                                        var params = macroDeserializer.deserialize($macroNode.attr("data-macro-parameters"));
                                        params.id = generateId();
                                        $macroNode.attr("data-macro-parameters", macroDeserializer.serialize(params));
                                    }
                                }
                            });

                            // get back the pasted text
                            pasteText.content = $pastedElement.html();
                        }
                    } catch(err){
                        if (AJS.logError){
                            AJS.logError("Could not parse paste content to handle copy Event Macro", err);
                        }
                    }
                });

            }

            // Make sure a value is set for the id field.
            AJS.MacroBrowser.setMacroJsOverride("event", {
                beforeParamsRetrieved : function(paramMap, macro, sharedParamMap) {
                    var id = AJS.$("#macro-param-id").val();
                    if (!id) {
                        id = generateId();
                        //If no id generate a random one.
                        AJS.$("#macro-param-id").val(id);
                        paramMap['id'] = id;
                    }

                    return paramMap;
                }
            });

            // Seems like we have to make sure this exists ourselves...
            AJS.MacroBrowser.getMacroJsOverride("event").fields = {};

            //Hide the id field.
            AJS.MacroBrowser.getMacroJsOverride("event").fields.string = {
                "id": function(param) {
                    return AJS.MacroBrowser.ParameterFields["_hidden"] (param, {});
                }
            };
        }

        return {
            init: initTeamCalendarsMacroForBrowser
        };
    }
);
