define("tc/get-add-dialog-for-macro",
    ['jquery', 'confluence/meta', 'aui/dialog2', 'window', 'tc/get-add-dialog-for-macro'],
    function($, Meta, dialog2, window) {
        var isAnonymous = Meta.get('remote-user') === '';

        function createAnonymousWarning() {
            var dialog = AJS.dialog2();
            dialog.$el.find('.aui-dialog2-header .aui-dialog2-header-main').text(
                AJS.I18n.getText("com.atlassian.confluence.extra.team-calendars.calendar.anonymous.warning.dialog.title")
            );
            dialog.$el.find('.aui-dialog2-content').text(
                AJS.I18n.getText("com.atlassian.confluence.extra.team-calendars.calendar.anonymous.warning.dialog.body")
            );
            dialog.$el.find('.aui-dialog2-footer').html(
                '<div class="aui-dialog2-footer-actions"> ' +
                '    <button class="aui-button aui-button-light cancel-btn">'+
                AJS.I18n.getText("com.atlassian.confluence.extra.team-calendars.calendar.anonymous.warning.dialog.cancel.button.title") +
                '   </button> ' +
                '    <button class="aui-button aui-button-primary login-btn">' +
                AJS.I18n.getText("com.atlassian.confluence.extra.team-calendars.calendar.anonymous.warning.dialog.login.button.title") +
                '   </button> ' +
                '</div>'
            );
            dialog.$el.find('.aui-dialog2-header-close').hide();
            dialog.$el.find('.cancel-btn').click(function () {
                dialog.hide();
            });
            dialog.$el.find('.login-btn').click(function () {
                window.location.href = $('#login-link').prop('href');
            });
            return dialog;
        }

        var anonymousWarningDialog;
        function showAnonymousWarning() {
            anonymousWarningDialog = anonymousWarningDialog || createAnonymousWarning();
            anonymousWarningDialog.show();
        }

        Confluence.TeamCalendars = Confluence.TeamCalendars || {};
        Confluence.TeamCalendars.Dialogs = Confluence.TeamCalendars.Dialogs || {};

        Confluence.TeamCalendars.Dialogs.getAddDialogForMacro = function(macro) {
            if (!macro.params && isAnonymous) {
                showAnonymousWarning();
                return;
            }
            var existingMacroCals = macro.params ? macro.params.id : "";

            var callbackHandler = {
                //Define a callback handler to handle callbacks from the create calendar dialogs
                isProcessingSubCalendar: function () {
                    return false;
                },

                setProcessingSubCalendar: function (aBool) {
                    //do nothing
                },

                setSubCalendarSpinnerIconVisible: function (aBool) {
                    //do nothing
                },

                getIncludedCalendars: function () {
                    return existingMacroCals ? existingMacroCals.split(",") : [];
                },

                showAjaxUpdateError: function (XMLHttpRequest, textStatus, errorThrown) {
                    Confluence.TeamCalendars.showAjaxError($("#editor-messages"), XMLHttpRequest, textStatus, errorThrown, "error-subcalendar-update");
                },

                showAjaxError: function (XMLHttpRequest, textStatus, errorThrown, errorClass) {
                    Confluence.TeamCalendars.showAjaxError($("#editor-messages"), XMLHttpRequest, textStatus, errorThrown, errorClass);
                },

                setGenericErrors: function (message, errorClass) {
                    Confluence.TeamCalendars.setGenericErrors($("#editor-messages"), null, errorClass)
                },

                setGenericUpdateError: function () {
                    Confluence.TeamCalendars.setGenericErrors($("#editor-messages"), null, "error-subcalendar-update")
                },

                setSubCalendars: function (newCalendars) {
                    if (!existingMacroCals) {
                        Confluence.TeamCalendars.fireEventForAnalytics("subcalendar.parent.embedded");
                    }

                    var calIds = newCalendars + (existingMacroCals ? "," + existingMacroCals : "");

                    macro.params = $.extend(macro.params, {id: calIds});
                    macro.body = '';

                    //Make sure something is selected in IE
                    AJS.Rte.BookmarkManager.restoreBookmark();
                    tinymce.confluence.MacroUtils.insertMacro({
                        macro: macro,
                        contentId: Confluence.Editor.getContentId()
                    });
                },

                setParameter: function (configKey, value) {
                    //do nothing
                },

                getParameter: function (configKey) {
                    // Return null - does nothing
                },

                reloadSubCalendar: function (subCalendarId) {
                    //Do nothing, not needed in the editor
                },

                getSubCalendars: function () {
                    return macro.params;
                },

                updateAvailableSubCalendarsInSubCalendarPanel: function () {
                    //Do nothing. Not needed in editor
                },

                getNextCalendarColor: function () {
                    return ""; //We let the server pick a color for us
                },

                isAutoWatchSet: function () {
                    return false;
                },

                refreshCachedSubCalendars: function (successHandler, errorHandler) {
                    //Do nothing, not needed in the editor
                },

                handleImport: function (subcalendarId) {
                    this.setSubCalendars(subcalendarId);
                },

                isCalendarInEditMode: function () {
                    //You cannot edit calendars from the editor, only create them, so they are always in edit mode
                    return true;
                },

                suppressMessage: function (messageKey, successCallback) {
                    Confluence.TeamCalendars.suppressMessage($("#editor-messages"), messageKey, successCallback)
                },

                showCalendarWizard: function () {
                    Confluence.TeamCalendars.Dialogs.getAddDialog(callbackHandler);
                },

                getSubCalendarsWhichCanAddEvents: function () {
                    return []; // It doesn't make sense to be able to add a JIRA event series from the editor.
                }
            };

            if (Confluence.TeamCalendars.shouldShowTimezoneSetup()) {
                Confluence.TeamCalendars.Dialogs.getTimeZoneSetupDialog(callbackHandler).show();
            } else {
                AJS.Rte.BookmarkManager.storeBookmark();
                Confluence.TeamCalendars.Dialogs.getAddDialog(callbackHandler, {"title": AJS.I18n.getText("calendar3.rte.addcalendardialog.title")});
            }
        };
    }
);
