(function($) {
    var FormStateControl = require('tc/form-state-control');

    /**
     * Returns a helper object that contains functionality common to subcalendar edit dialogs.
     */
    Confluence.TeamCalendars.getEditCalendarDialogHelper = function(editForm, subCalendar, callbackHandler) {
        var okButton,
            formMode = $(".form-mode", editForm),
            spaceKeyField = $("input[name='spaceKey']", editForm),
            spaceKeyAutocompleteField = $("input[name='spaceKeyAutocomplete']", editForm);

        return {
            initSpaceDropDown : function() {
                spaceKeyAutocompleteField.keypress(function(e) {
                    if (e.which !== 13) {
                        spaceKeyField.val(e.which);
                    }
                });

                spaceKeyAutocompleteField.bind("selected.autocomplete-content", function(e, selection) {
                    spaceKeyField.val(selection.content.key);
                    $(this).val(selection.content.name);
                    $(".spaceKeyAutocomplete-error", editForm).empty();
                });
            },

            initTimeZoneSelect : function() {
                $("select[name='timeZoneIdSelect']", editForm).change(function() {
                    $("input[name='timeZoneId']", editForm).val($("option:selected", this).val());
                });
            },

            initCloseButton : function(dialog, callBackCancel) {
                dialog.addCancel(
                        AJS.I18n.getText("cancel.name"),
                        function() {
                            if(typeof callBackCancel === "function") {
                                callBackCancel();
                            }
                            dialog.remove();
                            return false;
                        }
                );
            },

            initOkButton : function(label, dialog) {
                dialog.addButton(
                    label,
                    function() {
                        editForm.submit();
                        return false;
                    },
                    "submit"
                );

                okButton = dialog.popup.element.find(".submit");
            },

            populateTimeZoneDropDown : function(editPanel) {
                var timeZoneToSelect = subCalendar ? subCalendar.timeZoneId : Confluence.TeamCalendars.getUserTimeZone();
                var timeZoneIdSelect = $("#timeZoneIdSelect", editPanel.body);

                FormStateControl.disableElement(okButton);

                Confluence.TeamCalendars.populateTimeZoneDropDown(
                        timeZoneIdSelect,
                        timeZoneToSelect,
                        function() {
                            FormStateControl.enableElement(okButton);
                            timeZoneIdSelect.addClass("ready");
                        },
                        function(XMLHttpRequest, textStatus, errorThrown) {
                            callbackHandler.showAjaxError(XMLHttpRequest, textStatus, errorThrown);
                        });
            },

            disableOkButton : function(label) {
                okButton.text(label)
                    .prop("disabled", true).addClass("ui-state-disabled");
            },

            enableOkButton : function(label) {
                okButton.text(label)
                    .prop("disabled", false).removeClass("ui-state-disabled");
            },

            isNewCalendar : function() {
                return subCalendar ? false : true;
            },

            resetFieldErrors : function() {
                Confluence.TeamCalendars.setFieldErrors(editForm, null);
            },

            setFormModeEdit : function() {
                formMode.removeClass().addClass("form-mode edit");
            },

            setFormModeCreate : function() {
                formMode.removeClass().addClass("form-mode create");
            },

            setFormModeReadOnly : function() {
                formMode.removeClass().addClass("form-mode read-only");
            },

            setHeading : function(heading, dialog) {
                return dialog.getCurrentPanel().page.header.empty().text(heading).addClass("calendar-heading");
            },

            setSubCalendarIdField : function(id) {
                $("input[name='subCalendarId']", editForm).val(id);
            },

            setNameField : function(name) {
                $("input[name='name']", editForm).val(name);
            },

            setDescriptionField : function(description) {
                $("textarea[name='description']", editForm).val(description);
            },

            setColorField : function(color) {
                $("input[name='color']", editForm).val(color);
            },

            setSpaceKeyField : function(spaceKey) {
                spaceKeyField.val(spaceKey);
            },

            setSpaceKeyAutocompleteField : function(spaceName) {
                spaceKeyAutocompleteField.val(spaceName);
            },

            setTimeZoneIdField : function(timeZoneId) {
                $("input[name='timeZoneId']", editForm).val(timeZoneId);
            },

            setTimeZoneIdDisplayField : function(timeZoneId) {
                $(".timeZoneIdDisplay", editForm).text(timeZoneId);
            },

            setSubscriptionIdField : function(subscriptionId) {
                $("input[name='subscriptionId']", editForm).val(subscriptionId);
            },

            setLocationField : function(location) {
                $("input[name='location']", editForm).val(location);
            },

            setUserNameField : function(userName) {
                $("input[name='username']", editForm).val(userName);
            },

            setSpaceToDefault : function() {
                //If we are in a space set the space field to the current space, otherwise blank
                spaceKeyField.val(AJS.Meta.get("space-key") || "");
                spaceKeyAutocompleteField.val(AJS.Meta.get("space-name") || "");
            }
        }
    };

    Confluence.TeamCalendars.Dialogs.getSubCalendarCreateDialog = function(subCalendar, callbackHandler) {
        var Util = require("tc/util"),
            subCalendarType = (typeof subCalendar === "string") ? subCalendar : subCalendar.type,
            editForm,
            subCalendarTypeObj = Confluence.TeamCalendars.subcalendar[subCalendarType],
            editDialog = new AJS.ConfluenceDialog ({
                    width : subCalendarTypeObj.dialogWidth || 521,
                    height : "auto",
                    onSubmit : function() {
                        editForm.submit();
                        return false;
                    },
                    id : "create-calendar-dialog",
                    onCancel: function() {
                        editDialog.remove();
                    }
                }
            ),
            subCalendarTypeHandler = subCalendarTypeObj.getDialog(
                editDialog,
                $.isPlainObject(subCalendar) ? subCalendar : null,
                callbackHandler
            );

        //Make overflow visible so that the JQL autocomplete etc are not cut off
        editDialog.popup.element.css("overflow", "visible");
        editForm = subCalendarTypeHandler.initializeForm();

        editForm.submit(function() {
           if (callbackHandler.isProcessingSubCalendar())
               return false;

           callbackHandler.setProcessingSubCalendar(true);
           var spinnerDefer = callbackHandler.setSubCalendarSpinnerIconVisible(true);
           subCalendarTypeHandler.onSubmitStart();

           var requestData = subCalendarTypeHandler.getFormDataAsAjaxData();
           if (callbackHandler.getIncludedCalendars())
               requestData.include = callbackHandler.getIncludedCalendars();

           var subCalendarId = requestData.subCalendarId;

           $.ajax({
               cache : false,
               converters : {
                   "text json" : function(jsonObject) {
                       return jsonObject;
                   }
               },
               data : requestData,
               dataFilter : function(data) {
                   var subCalendarsResponseEntity = data ? JSON.parse(data) : null;
                   if (subCalendarsResponseEntity.success)
                       Confluence.TeamCalendars.mergeSubCalendarObjectsToArray(subCalendarsResponseEntity.payload);
                   return subCalendarsResponseEntity;
               },
               dataType : "json",
               error : function(XMLHttpRequest, textStatus, errorThrown) {
                   callbackHandler.showAjaxUpdateError(XMLHttpRequest, textStatus, errorThrown);
                   subCalendarTypeHandler.onSubmitEnd();
                   callbackHandler.setProcessingSubCalendar(false);
               },
               success : function(responseEntity) {
                   callbackHandler.setGenericUpdateError();

                   if (responseEntity.success) {
                       Confluence.TeamCalendars.setFieldErrors(editForm, null);

                       var subCalendarEdited = subCalendarId;
                       if (subCalendarEdited) {
                           //TODO: rename this
                           callbackHandler.setSubCalendars(subCalendarId, responseEntity.payload);
                           callbackHandler.reloadSubCalendar(subCalendarId);
                       } else {
                           subCalendarId = responseEntity.modifiedSubCalendarId;
                           $("input[name='subCalendarId']", editForm).val(subCalendarId);
                           callbackHandler.setSubCalendars(subCalendarId, responseEntity.payload);
                       }

                       callbackHandler.updateAvailableSubCalendarsInSubCalendarPanel();
                       subCalendarTypeHandler.onSubmitEnd();
                       editDialog.remove();

                       if (!subCalendarEdited) {
                           // start the calendar tour for new calendar
                           Confluence.TeamCalendars.CalendarTour().start(subCalendarId);
                       }
                   } else {
                       Confluence.TeamCalendars.setFieldErrors(editForm, responseEntity.fieldErrors);
                       subCalendarTypeHandler.onSubmitEnd();

                       if (!subCalendarTypeObj.dynamicDialogHeight) {
                           Util.showDialogInUpdatedHeight(editDialog);
                       }
                   }

                   callbackHandler.setProcessingSubCalendar(false);
               },
               complete: function(){
                   if (spinnerDefer) spinnerDefer.resolve();
               },
               type : "PUT",
               timeout: Confluence.TeamCalendars.ajaxTimeout,
               url : Confluence.TeamCalendars.getCalendarServiceBaseUrl("/subcalendars.json")
           });

           return false;
        });

        return editDialog;
    };
}(AJS.$));
