define("tc/macro-button-panel",
    ['jquery', 'confluence/meta', 'tc/get-add-dialog-for-macro'],
    function($, Meta) {
        var CalendarMacroButtonPanel = {
            _filterButtonsBasedOnUser: function (buttons) {
                var isAnonymous = Meta.get('remote-user') === '';
                if (!isAnonymous) {
                    return;
                }
                var anonymousButtons = buttons.filter(
                    function (button) { return button.parameterName !== 'add-subcalendar';}
                );
                // we need to mutate the actual array
                buttons.length = 0;
                anonymousButtons.forEach(
                    function (button) { buttons.push(button); }
                );
            },
            initViewButtons : function() {
                var that = this;
                $.each(CalendarMacroButtonPanel.getButtonIdToViewMap(), function(buttonId, buttonValue) {
                    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler(buttonId, function(e, macroNode) {
                        var $macroContainer = $(macroNode);
                        AJS.Rte.getEditor().selection.select($macroContainer[0]);
                        AJS.Rte.BookmarkManager.storeBookmark();

                        tinymce.confluence.MacroUtils.insertMacro({
                            contentId: Confluence.Editor.getContentId(),
                            macro: {
                                name: CalendarMacroButtonPanel.getMacroName($macroContainer),
                                params: $.extend(CalendarMacroButtonPanel.parseMacroParams($macroContainer), { "defaultView": buttonValue }),
                                defaultParameterValue: "",
                                body : ""
                            }
                        });
                    });
                });


                AJS.Confluence.PropertyPanel.Macro.registerInitHandler(
                    function(macroNode, buttons) {
                        that._filterButtonsBasedOnUser(buttons);
                    },
                    "calendar"
                );
            },

            initAddButton : function(){
                AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("add-subcalendar", function(e, macroNode) {
                    var $macroContainer = $(macroNode);
                    Confluence.TeamCalendars.Dialogs.getAddDialogForMacro({
                        name: CalendarMacroButtonPanel.getMacroName($macroContainer),
                        params: CalendarMacroButtonPanel.parseMacroParams($macroContainer),
                        defaultParameterValue: "",
                        body : ""
                    });
                });
            },

            parseMacroParams : function($macroContainer) {
                var macroParamsString = $macroContainer.attr("data-macro-parameters") || "", valuePairs = macroParamsString.split("|"), macroParams = {};

                if (valuePairs) {
                    $.each(valuePairs, function(valuePairIdx, valuePair) {
                        var valuePairTokens = valuePair.split("=", 2);
                        if (valuePairTokens.length > 0)
                            macroParams[valuePairTokens[0]] = valuePairTokens.length > 1 ? valuePairTokens[1] : "";
                    });
                }

                return macroParams;
            },

            getMacroName : function($macroContainer) {
                return $macroContainer.attr("data-macro-name");
            },

            getButtonIdToViewMap : function() {
                return {
                    "calendar-view-month" : "month",
                    "calendar-view-week" : "week",
                    "calendar-view-list" : "list",
                    "calendar-view-upcoming" : "upcoming",
                    "calendar-view-timeline" : "timeline"
                };
            },

            initViewButtonHighlight : function() {
                AJS.bind("created.property-panel", function (e, data) {
                    var viewButtonToHighlight = CalendarMacroButtonPanel.parseMacroParams($(data.anchor))["defaultView"] || "month";
                    if (viewButtonToHighlight === "upcoming")
                        viewButtonToHighlight = "list";

                    $(".macro-property-panel-calendar-view-" + viewButtonToHighlight, data.panel).addClass("selected");
                });
            }
        };

        return {
            init: function() {
                CalendarMacroButtonPanel.initViewButtons();
                CalendarMacroButtonPanel.initAddButton();
                CalendarMacroButtonPanel.initViewButtonHighlight();
            }
        };
});
