(function($) {
    if (!window.Confluence.TeamCalendars.subcalendar)
        window.Confluence.TeamCalendars.subcalendar = {};

    if (!window.Confluence.TeamCalendars.subcalendar.parent) {
        var CalUtil = require("tc/calendar-util");

        window.Confluence.TeamCalendars.subcalendar.parent = {
            getDialog : function(editDialog, subCalendar, callbackHandler) {
                var editForm,
                    helper;

                var populateForm = function() {
                    var editPanel = editDialog.getCurrentPanel();

                    helper.resetFieldErrors();
                    helper.populateTimeZoneDropDown(editPanel);

                    var timeZoneSelect = $("select[name='timeZoneIdSelect']", editForm);

                    if (helper.isNewCalendar()) {
                        helper.setFormModeCreate();
                        helper.setHeading(AJS.I18n.getText("calendar3.createeventscalendar"), editDialog);
                        helper.setSubCalendarIdField("");
                        helper.setNameField("");
                        helper.setDescriptionField("");
                        helper.setColorField(callbackHandler.getNextCalendarColor());
                        helper.setSpaceToDefault();
                        helper.setTimeZoneIdField("");
                    } else {
                        helper.setFormModeEdit();
                        helper.setHeading(subCalendar.name, editDialog);
                        helper.setSubCalendarIdField(subCalendar.id);
                        helper.setNameField(subCalendar.name);
                        helper.setDescriptionField(subCalendar.description);
                        helper.setColorField(subCalendar.color);
                        helper.setSpaceKeyField(subCalendar.spaceKey);
                        helper.setSpaceKeyAutocompleteField(subCalendar.spaceName);
                        helper.setTimeZoneIdField(subCalendar.timeZoneId);
                    }

                    var textInputs = $("input[name='name'], textarea[name='description'], input[name='spaceKeyAutocomplete']", editForm);
                    if (callbackHandler.isCalendarInEditMode()) {
                        textInputs.prop("readonly", false);
                        timeZoneSelect.prop("disabled", false);
                    } else {
                        helper.setFormModeReadOnly();
                        textInputs.prop("readonly", true);
                        timeZoneSelect.prop("disabled", true);
                    }

                    // hidden space field when create TC on space
                    if(helper.isNewCalendar() && AJS.Meta.get("space-key")) {
                        var spaceDiv = $(".field-group-space-permission", editForm);
                        spaceDiv.addClass("hidden");
                    }
                };

                return {
                    initializeForm: function(callBackCancel) {
                        editDialog.addHeader(AJS.I18n.getText("calendar3.createeventscalendar"));
                        editDialog.addPanel(AJS.I18n.getText("com.atlassian.confluence.extra.team-calendars.editcalendar.panel.general"), Confluence.TeamCalendars.Templates.editLocalCalendar(), "calendar-dialog-panel create-calendar-dialog");

                        editForm = $("form.sub-calendar-edit-form", editDialog.getCurrentPanel().body);
                        helper = Confluence.TeamCalendars.getEditCalendarDialogHelper(editForm, subCalendar, callbackHandler);

                        helper.initSpaceDropDown();
                        helper.initTimeZoneSelect();
                        helper.initOkButton(AJS.I18n.getText("ok"), editDialog);
                        helper.initCloseButton(editDialog, callBackCancel);
                        populateForm();
                        return editForm;
                    },

                    getFormDataAsAjaxData : function() {
                        var data = {
                            type : "parent",
                            subCalendarId : $("input[name='subCalendarId']", editForm).val(),
                            name : $("input[name='name']", editForm).val(),
                            description : $("textarea[name='description']", editForm).val(),
                            color : $("input[name='color']", editForm).val(),
                            spaceKey : $("input[name='spaceKeyAutocomplete']", editForm).val() ? $("input[name='spaceKey']", editForm).val() : "",
                            timeZoneId : $("input[name='timeZoneId']", editForm).val() || $("select[name='timeZoneIdSelect'] option:selected", editForm).val()
                        };

                        CalUtil.putCalendarContextParams(data);

                        return data;
                    },

                    onSubmitStart : function() {
                        helper.disableOkButton(AJS.I18n.getText("calendar3.adding"));
                    },

                    onSubmitEnd : function() {
                        helper.enableOkButton(AJS.I18n.getText("ok"));
                    }
                }
            },
            weight : 1,
            typeName : AJS.I18n.getText("calendar3.subcalendar.type.parent")
        };
    }
})(jQuery);
