(function($) {
    if (!window.Confluence.TeamCalendars.subcalendar)
        window.Confluence.TeamCalendars.subcalendar = {};

    if (!window.Confluence.TeamCalendars.subcalendar.subscription) {
        var CalUtil = require("tc/calendar-util");

        window.Confluence.TeamCalendars.subcalendar.subscription = {
            getDialog : function(editDialog, subCalendar, callbackHandler) {
                var helper,
                    editForm;

                var populateForm = function() {
                    helper.resetFieldErrors();

                    var createHelpLink = function() {
                        return $(document.createElement("div")).addClass("calendar-dialog-help-link").append(
                                $(document.createElement("a"))
                                        .attr("href", AJS.I18n.getText("help.teamcal.subscribe.third.party.calendars"))
                                        .attr("target", "_blank")
                                        .text(AJS.I18n.getText("help.name"))
                        )
                    };

                    if (helper.isNewCalendar()) {
                        helper.setFormModeCreate();
                        helper.setHeading(AJS.I18n.getText("calendar3.subscribe"), editDialog).append(createHelpLink());
                        helper.setSubCalendarIdField("");
                        helper.setNameField("");
                        helper.setDescriptionField("");
                        helper.setColorField(callbackHandler.getNextCalendarColor());
                        helper.setSpaceToDefault();
                        helper.setLocationField("");
                        helper.setUserNameField("");
                        helper.setTimeZoneIdDisplayField("");
                    } else {
                        helper.setFormModeEdit();
                        helper.setHeading(subCalendar.name, editDialog).append(createHelpLink());
                        helper.setSubCalendarIdField(subCalendar.id);
                        helper.setNameField(subCalendar.name);
                        helper.setDescriptionField(subCalendar.description);
                        helper.setColorField(subCalendar.color);
                        helper.setSpaceKeyField(subCalendar.spaceKey);
                        helper.setSpaceKeyAutocompleteField(subCalendar.spaceName);
                        helper.setLocationField(subCalendar.sourceLocation);
                        helper.setUserNameField(subCalendar.userName || "");
                        helper.setTimeZoneIdDisplayField(subCalendar.timeZoneId);
                    }

                    var textInputs = $("input[name='name'], textarea[name='description'], input[name='spaceKeyAutocomplete'], input[name='location'], input[name='username'], input[name='password']", editForm);
                    if (callbackHandler.isCalendarInEditMode()) {
                        textInputs.prop("readonly", false);
                    } else {
                        helper.setFormModeReadOnly();
                        textInputs.prop("readonly", true);
                    }

                    //hidden space field when TC on space
                    if(AJS.Meta.get("space-key")) {
                        var spaceDiv = $(".field-group-space-permission", editForm);
                        spaceDiv.css("display", "none");
                    }
                };

                return {
                    initializeForm: function() {
                        editDialog.addHeader(AJS.I18n.getText("calendar3.subscribe"));
                        editDialog.addPanel(AJS.I18n.getText("com.atlassian.confluence.extra.team-calendars.editcalendar.panel.general"), Confluence.TeamCalendars.Templates.editSubscriptionSubcalendar(), "calendar-dialog-panel subscribe-dialog");

                        editForm = $("form.sub-calendar-edit-form", editDialog.getCurrentPanel().body);
                        helper = Confluence.TeamCalendars.getEditCalendarDialogHelper(editForm, subCalendar, callbackHandler);

                        helper.initSpaceDropDown();
                        helper.initOkButton(AJS.I18n.getText("calendar3.subscribe"), editDialog);
                        helper.initCloseButton(editDialog);

                        populateForm();

                        return editForm;
                    },

                    getFormDataAsAjaxData : function() {
                        var data = {
                            type: "subscription",
                            subCalendarId: $("input[name='subCalendarId']", editForm).val(),
                            name: $("input[name='name']", editForm).val(),
                            description: $("textarea[name='description']", editForm).val(),
                            color: $("input[name='color']", editForm).val(),
                            spaceKey: !!$("input[name='spaceKeyAutocomplete']", editForm).val() ? $("input[name='spaceKey']", editForm).val() : "",
                            location: $("input[name='location']", editForm).val(),
                            userName: $("input[name='username']", editForm).val(),
                            password: $("input[name='password']", editForm).val()
                        };

                        CalUtil.putCalendarContextParams(data);

                        return data;

                    },

                    onSubmitStart : function() {
                        helper.disableOkButton(AJS.I18n.getText("calendar3.subscribing"));
                    },

                    onSubmitEnd : function() {
                        helper.enableOkButton(AJS.I18n.getText("calendar3.subscribe"));
                    }
                }
            },
            weight : 6,
            typeName : AJS.I18n.getText("calendar3.subcalendar.type.subscription")
        }
    }
})(jQuery);
