/**
 * @file timeline.js
 *
 * @brief
 * The Timeline is an interactive visualization chart to visualize events in
 * time, having a start and end date.
 * You can freely move and zoom in the timeline by dragging
 * and scrolling in the Timeline. Items are optionally dragable. The time
 * scale on the axis is adjusted automatically, and supports scales ranging
 * from milliseconds to years.
 *
 * Timeline is part of the CHAP Links library.
 *
 * Timeline is tested on Firefox 3.6, Safari 5.0, Chrome 6.0, Opera 10.6, and
 * Internet Explorer 6+.
 *
 * @license
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 * Copyright (c) 2011-2013 Almende B.V.
 *
 * @author     Jos de Jong, <jos@almende.org>
 * @date    2013-04-18
 * @version 2.4.2
 */
"undefined"==typeof links&&(links={}),"undefined"==typeof google&&(google=void 0),links.Timeline=function(container){if(container){this.dom={},this.conversion={},this.eventParams={},this.groups=[],this.groupIndexes={},this.items=[],this.renderQueue={show:[],hide:[],update:[]},this.renderedItems=[],this.clusterGenerator=new links.Timeline.ClusterGenerator(this),this.currentClusters=[],this.selection=void 0,this.listeners={},this.size={actualHeight:0,axis:{characterMajorHeight:0,characterMajorWidth:0,characterMinorHeight:0,characterMinorWidth:0,height:0,labelMajorTop:0,labelMinorTop:0,line:0,lineMajorWidth:0,lineMinorHeight:0,lineMinorTop:0,lineMinorWidth:0,top:0},contentHeight:0,contentLeft:0,contentWidth:0,frameHeight:0,frameWidth:0,groupsLeft:0,groupsWidth:0,items:{top:0}},this.dom.container=container,this.options={width:"100%",height:"auto",minHeight:0,autoHeight:!0,eventMargin:10,eventMarginAxis:20,dragAreaWidth:10,min:void 0,max:void 0,zoomMin:10,zoomMax:31536e10,moveable:!0,zoomable:!0,selectable:!0,editable:!1,snapEvents:!0,groupChangeable:!0,showCurrentTime:!0,showCustomTime:!1,showMajorLabels:!0,showMinorLabels:!0,showNavigation:!1,showButtonNew:!1,groupsOnRight:!1,axisOnTop:!1,stackEvents:!0,animate:!0,animateZoom:!0,cluster:!1,style:"box",customStackOrder:!1,locale:"en",MONTHS:new Array("January","February","March","April","May","June","July","August","September","October","November","December"),DAYS:new Array("Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"),MONTHS_SHORT:new Array("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"),DAYS_SHORT:new Array("Sun","Mon","Tue","Wed","Thu","Fri","Sat"),ZOOM_IN:"Zoom in",ZOOM_OUT:"Zoom out",MOVE_LEFT:"Move left",MOVE_RIGHT:"Move right",NEW:"New",CREATE_NEW_EVENT:"Create new event"},this.clientTimeOffset=0;for(var dom=this.dom;dom.container.hasChildNodes();)dom.container.removeChild(dom.container.firstChild);this.step=new links.Timeline.StepDate,this.itemTypes={box:links.Timeline.ItemBox,range:links.Timeline.ItemRange,dot:links.Timeline.ItemDot},this.data=[],this.firstDraw=!0,this.setVisibleChartRange(void 0,void 0,!1),this.render();var me=this;setTimeout(function(){me.trigger("ready")},0)}},links.Timeline.prototype.draw=function(data,options){this.setOptions(options),this.setData(data),options&&(options.start||options.end)?this.setVisibleChartRange(options.start,options.end):this.firstDraw&&this.setVisibleChartRangeAuto(),this.firstDraw=!1},links.Timeline.prototype.setOptions=function(options){if(options){for(var i in options)options.hasOwnProperty(i)&&(this.options[i]=options[i]);if(void 0!==links.locales&&"en"!==this.options.locale){var localeOpts=links.locales[this.options.locale];if(localeOpts)for(var l in localeOpts)localeOpts.hasOwnProperty(l)&&(this.options[l]=localeOpts[l])}null!=options.showButtonAdd&&(this.options.showButtonNew=options.showButtonAdd,console.log("WARNING: Option showButtonAdd is deprecated. Use showButtonNew instead")),null!=options.intervalMin&&(this.options.zoomMin=options.intervalMin,console.log("WARNING: Option intervalMin is deprecated. Use zoomMin instead")),null!=options.intervalMax&&(this.options.zoomMax=options.intervalMax,console.log("WARNING: Option intervalMax is deprecated. Use zoomMax instead")),options.scale&&options.step&&this.step.setScale(options.scale,options.step)}this.options.autoHeight="auto"===this.options.height},links.Timeline.prototype.addItemType=function(typeName,typeFactory){this.itemTypes[typeName]=typeFactory},links.Timeline.mapColumnIds=function(dataTable){for(var cols={},colMax=dataTable.getNumberOfColumns(),allUndefined=!0,col=0;col<colMax;col++){var id=dataTable.getColumnId(col)||dataTable.getColumnLabel(col);cols[id]=col,"start"!=id&&"end"!=id&&"content"!=id&&"group"!=id&&"className"!=id&&"editable"!=id||(allUndefined=!1)}return allUndefined&&(cols.start=0,cols.end=1,cols.content=2),cols},links.Timeline.prototype.setData=function(data){this.unselectItem(),data||(data=[]),this.stackCancelAnimation(),this.clearItems(),this.data=data;var items=this.items;if(this.deleteGroups(),google&&google.visualization&&data instanceof google.visualization.DataTable)for(var cols=links.Timeline.mapColumnIds(data),row=0,rows=data.getNumberOfRows();row<rows;row++)items.push(this.createItem({start:null!=cols.start?data.getValue(row,cols.start):void 0,end:null!=cols.end?data.getValue(row,cols.end):void 0,content:null!=cols.content?data.getValue(row,cols.content):void 0,group:null!=cols.group?data.getValue(row,cols.group):void 0,className:null!=cols.className?data.getValue(row,cols.className):void 0,editable:null!=cols.editable?data.getValue(row,cols.editable):void 0}));else{if(!links.Timeline.isArray(data))throw"Unknown data type. DataTable or Array expected.";for(row=0,rows=data.length;row<rows;row++){var itemData=data[row],item=this.createItem(itemData);items.push(item)}}this.options.cluster&&this.clusterGenerator.setData(this.items),this.render({animate:!1})},links.Timeline.prototype.getData=function(){return this.data},links.Timeline.prototype.updateData=function(index,values){var prop,data=this.data;if(google&&google.visualization&&data instanceof google.visualization.DataTable){var missingRows=index+1-data.getNumberOfRows();missingRows>0&&data.addRows(missingRows);var cols=links.Timeline.mapColumnIds(data);for(prop in values)if(values.hasOwnProperty(prop)){var col=cols[prop];if(null==col){var value=values[prop],valueType="string";"number"==typeof value?valueType="number":"boolean"==typeof value?valueType="boolean":value instanceof Date&&(valueType="datetime"),col=data.addColumn(valueType,prop)}data.setValue(index,col,values[prop])}}else{if(!links.Timeline.isArray(data))throw"Cannot update data, unknown type of data";var row=data[index];for(prop in null==row&&(row={},data[index]=row),values)values.hasOwnProperty(prop)&&(row[prop]=values[prop])}},links.Timeline.prototype.getItemIndex=function(element){for(var e=element,frame=this.dom.items.frame,items=this.items,index=void 0;e.parentNode&&e.parentNode!==frame;)e=e.parentNode;if(e.parentNode===frame)for(var i=0,iMax=items.length;i<iMax;i++)if(items[i].dom===e){index=i;break}return index},links.Timeline.prototype.setSize=function(width,height){width&&(this.options.width=width,this.dom.frame.style.width=width),height&&(this.options.height=height,this.options.autoHeight="auto"===this.options.height,"auto"!==height&&(this.dom.frame.style.height=height)),this.render({animate:!1})},links.Timeline.prototype.setVisibleChartRange=function(start,end,redraw){var range={};start&&end||(range=this.getDataRange(!0)),start||(end?range.min&&range.min.valueOf()<end.valueOf()?start=range.min:(start=new Date(end.valueOf())).setDate(start.getDate()-7):(start=new Date).setDate(start.getDate()-3)),end||(range.max?end=range.max:(end=new Date(start.valueOf())).setDate(end.getDate()+7)),end<=start&&(end=new Date(start.valueOf())).setDate(end.getDate()+7);var min=this.options.min?this.options.min:void 0;null!=min&&start.valueOf()<min.valueOf()&&(start=new Date(min.valueOf()));var max=this.options.max?this.options.max:void 0;null!=max&&end.valueOf()>max.valueOf()&&(end=new Date(max.valueOf())),this.applyRange(start,end),null==redraw||1==redraw?this.render({animate:!1}):this.recalcConversion()},links.Timeline.prototype.setVisibleChartRangeAuto=function(){var range=this.getDataRange(!0);this.setVisibleChartRange(range.min,range.max)},links.Timeline.prototype.setVisibleChartRangeNow=function(){var now=new Date,diff=this.end.valueOf()-this.start.valueOf(),startNew=new Date(now.valueOf()-diff/2),endNew=new Date(startNew.valueOf()+diff);this.setVisibleChartRange(startNew,endNew)},links.Timeline.prototype.getVisibleChartRange=function(){return{start:new Date(this.start.valueOf()),end:new Date(this.end.valueOf())}},links.Timeline.prototype.getDataRange=function(withMargin){var items=this.items,min=void 0,max=void 0;if(items)for(var i=0,iMax=items.length;i<iMax;i++){var item=items[i],start=null!=item.start?item.start.valueOf():void 0,end=null!=item.end?item.end.valueOf():start;min=null!=min&&null!=start?Math.min(min.valueOf(),start.valueOf()):start,max=null!=max&&null!=end?Math.max(max,end):end}if(min&&max&&withMargin){var diff=max-min;min-=.05*diff,max+=.05*diff}return{min:null!=min?new Date(min):void 0,max:null!=max?new Date(max):void 0}},links.Timeline.prototype.render=function(options){this.reflowFrame(),this.reflowAxis(),this.reflowGroups(),this.reflowItems();var animate=this.options.animate;if(options&&null!=options.animate&&(animate=options.animate),this.recalcConversion(),this.clusterItems(),this.filterItems(),this.stackItems(animate),this.recalcItems(),this.repaint()){var renderTimesLeft=options?options.renderTimesLeft:void 0;null==renderTimesLeft&&(renderTimesLeft=5),renderTimesLeft>0&&this.render({animate:options?options.animate:void 0,renderTimesLeft:renderTimesLeft-1})}},links.Timeline.prototype.repaint=function(){var frameNeedsReflow=this.repaintFrame(),axisNeedsReflow=this.repaintAxis(),groupsNeedsReflow=this.repaintGroups(),itemsNeedsReflow=this.repaintItems();return this.repaintCurrentTime(),this.repaintCustomTime(),frameNeedsReflow||axisNeedsReflow||groupsNeedsReflow||itemsNeedsReflow},links.Timeline.prototype.reflowFrame=function(){var dom=this.dom,size=(this.options,this.size),resized=!1,frameWidth=dom.frame?dom.frame.offsetWidth:0,frameHeight=dom.frame?dom.frame.children[0].clientHeight:0;return resized=(resized=resized||size.frameWidth!==frameWidth)||size.frameHeight!==frameHeight,size.frameWidth=frameWidth,size.frameHeight=frameHeight,resized},links.Timeline.prototype.repaintFrame=function(){var needsReflow=!1,dom=this.dom,options=this.options,size=this.size;dom.frame||(dom.frame=document.createElement("DIV"),dom.frame.className="timeline-frame",dom.frame.style.position="relative",dom.frame.style.overflowX="hidden",dom.frame.style.overflowY="auto",dom.container.appendChild(dom.frame),needsReflow=!0);var height=options.autoHeight?size.actualHeight+"px":options.height||"100%",width=options.width||"100%";if(needsReflow=(needsReflow=needsReflow||dom.frame.style.height!=height)||dom.frame.style.width!=width,dom.frame.style.height=options.viewHeight?options.viewHeight:height,dom.frame.style.width=width,!dom.content){dom.content=document.createElement("DIV"),dom.content.style.position="relative",dom.content.style.overflow="hidden",dom.frame.appendChild(dom.content);var timelines=document.createElement("DIV");timelines.style.position="absolute",timelines.style.left="0px",timelines.style.top="0px",timelines.style.height="100%",timelines.style.width="0px",dom.content.appendChild(timelines),dom.contentTimelines=timelines;var params=this.eventParams,me=this;params.onMouseDown||(params.onMouseDown=function(event){me.onMouseDown(event)},links.Timeline.addEventListener(dom.content,"mousedown",params.onMouseDown)),params.onTouchStart||(params.onTouchStart=function(event){me.onTouchStart(event)},links.Timeline.addEventListener(dom.content,"touchstart",params.onTouchStart)),params.onDblClick||(params.onDblClick=function(event){me.onDblClick(event)},links.Timeline.addEventListener(dom.content,"dblclick",params.onDblClick)),needsReflow=!0}return dom.content.style.left=size.contentLeft+"px",dom.content.style.top="0px",dom.content.style.width=size.contentWidth+"px",dom.content.style.height=height,this.repaintNavigation(),this.reflowAxis(),this.repaintAxis(),needsReflow},links.Timeline.prototype.reflowAxis=function(){var resized=!1,dom=this.dom,options=this.options,size=this.size,axisDom=dom.axis,characterMinorWidth=axisDom&&axisDom.characterMinor?axisDom.characterMinor.clientWidth:0,characterMinorHeight=axisDom&&axisDom.characterMinor?axisDom.characterMinor.clientHeight:0,characterMajorWidth=axisDom&&axisDom.characterMajor?axisDom.characterMajor.clientWidth:0,characterMajorHeight=axisDom&&axisDom.characterMajor?axisDom.characterMajor.clientHeight:0,axisHeight=(options.showMinorLabels?characterMinorHeight:0)+(options.showMajorLabels?characterMajorHeight:0),frameHeight=dom.frame?dom.frame.children[0].clientHeight:size.frameHeight,axisTop=options.axisOnTop?0:frameHeight-axisHeight,axisLine=options.axisOnTop?axisHeight:axisTop;resized=(resized=(resized=resized||size.axis.top!==axisTop)||size.axis.line!==axisLine)||size.axis.height!==axisHeight,size.axis.top=axisTop,size.axis.line=axisLine,size.axis.height=axisHeight,size.axis.labelMajorTop=options.axisOnTop?0:axisLine+(options.showMinorLabels?characterMinorHeight:0),size.axis.labelMinorTop=options.axisOnTop?options.showMajorLabels?characterMajorHeight:0:axisLine,size.axis.lineMinorTop=options.axisOnTop?size.axis.labelMinorTop:0,size.axis.lineMinorHeight=options.showMajorLabels?size.frameHeight-characterMajorHeight:size.frameHeight,axisDom&&axisDom.minorLines&&axisDom.minorLines.length?size.axis.lineMinorWidth=axisDom.minorLines[0].offsetWidth:size.axis.lineMinorWidth=1,axisDom&&axisDom.majorLines&&axisDom.majorLines.length?size.axis.lineMajorWidth=axisDom.majorLines[0].offsetWidth:size.axis.lineMajorWidth=1,resized=(resized=(resized=(resized=resized||size.axis.characterMinorWidth!==characterMinorWidth)||size.axis.characterMinorHeight!==characterMinorHeight)||size.axis.characterMajorWidth!==characterMajorWidth)||size.axis.characterMajorHeight!==characterMajorHeight,size.axis.characterMinorWidth=characterMinorWidth,size.axis.characterMinorHeight=characterMinorHeight,size.axis.characterMajorWidth=characterMajorWidth,size.axis.characterMajorHeight=characterMajorHeight;var contentHeight=Math.max(size.frameHeight-axisHeight,0);return size.contentLeft=options.groupsOnRight?0:size.groupsWidth,size.contentWidth=Math.max(size.frameWidth-size.groupsWidth,0),size.contentHeight=contentHeight,size.axis.lineMinorHeight=contentHeight,resized},links.Timeline.prototype.repaintAxis=function(){var needsReflow=!1,dom=this.dom,options=this.options,size=this.size,step=this.step,axis=dom.axis;axis||(axis={},dom.axis=axis),size.axis.properties||(size.axis.properties={}),axis.minorTexts||(axis.minorTexts=[]),axis.minorLines||(axis.minorLines=[]),axis.majorTexts||(axis.majorTexts=[]),axis.majorLines||(axis.majorLines=[]),axis.frame||(axis.frame=document.createElement("DIV"),axis.frame.style.position="absolute",axis.frame.style.left="0px",axis.frame.style.top="0px",dom.content.appendChild(axis.frame)),dom.content.removeChild(axis.frame),axis.frame.style.width=size.contentWidth+"px",axis.frame.style.height=size.axis.height+"px";var start=this.screenToTime(0),end=this.screenToTime(size.contentWidth);size.axis.characterMinorWidth&&(this.minimumStep=this.screenToTime(6*size.axis.characterMinorWidth)-this.screenToTime(0),step.setRange(start,end,this.minimumStep));var charsNeedsReflow=this.repaintAxisCharacters();needsReflow=needsReflow||charsNeedsReflow,this.repaintAxisStartOverwriting(),step.start();for(var xFirstMajorLabel=void 0,max=0;!step.end()&&max<1e3;){max++;var cur=step.getCurrent(),x=this.timeToScreen(cur),isMajor=step.isMajor();options.showMinorLabels&&this.repaintAxisMinorText(x,step.getLabelMinor(options)),isMajor&&options.showMajorLabels?(x>0&&(null==xFirstMajorLabel&&(xFirstMajorLabel=x),this.repaintAxisMajorText(x,step.getLabelMajor(options))),this.repaintAxisMajorLine(x)):this.repaintAxisMinorLine(x),step.next()}if(options.showMajorLabels){var leftTime=this.screenToTime(0),leftText=this.step.getLabelMajor(options,leftTime),width=leftText.length*size.axis.characterMajorWidth+10;(null==xFirstMajorLabel||width<xFirstMajorLabel)&&this.repaintAxisMajorText(0,leftText,leftTime)}return this.repaintAxisEndOverwriting(),this.repaintAxisHorizontal(),dom.content.insertBefore(axis.frame,dom.content.firstChild),needsReflow},links.Timeline.prototype.repaintAxisCharacters=function(){var text,needsReflow=!1,axis=this.dom.axis;if(!axis.characterMinor){text=document.createTextNode("0");var characterMinor=document.createElement("DIV");characterMinor.className="timeline-axis-text timeline-axis-text-minor",characterMinor.appendChild(text),characterMinor.style.position="absolute",characterMinor.style.visibility="hidden",characterMinor.style.paddingLeft="0px",characterMinor.style.paddingRight="0px",axis.frame.appendChild(characterMinor),axis.characterMinor=characterMinor,needsReflow=!0}if(!axis.characterMajor){text=document.createTextNode("0");var characterMajor=document.createElement("DIV");characterMajor.className="timeline-axis-text timeline-axis-text-major",characterMajor.appendChild(text),characterMajor.style.position="absolute",characterMajor.style.visibility="hidden",characterMajor.style.paddingLeft="0px",characterMajor.style.paddingRight="0px",axis.frame.appendChild(characterMajor),axis.characterMajor=characterMajor,needsReflow=!0}return needsReflow},links.Timeline.prototype.repaintAxisStartOverwriting=function(){var properties=this.size.axis.properties;properties.minorTextNum=0,properties.minorLineNum=0,properties.majorTextNum=0,properties.majorLineNum=0},links.Timeline.prototype.repaintAxisEndOverwriting=function(){var num,dom=this.dom,props=this.size.axis.properties,frame=this.dom.axis.frame,minorTexts=dom.axis.minorTexts;for(num=props.minorTextNum;minorTexts.length>num;){var minorText=minorTexts[num];frame.removeChild(minorText),minorTexts.splice(num,1)}var minorLines=dom.axis.minorLines;for(num=props.minorLineNum;minorLines.length>num;){var minorLine=minorLines[num];frame.removeChild(minorLine),minorLines.splice(num,1)}var majorTexts=dom.axis.majorTexts;for(num=props.majorTextNum;majorTexts.length>num;){var majorText=majorTexts[num];frame.removeChild(majorText),majorTexts.splice(num,1)}var majorLines=dom.axis.majorLines;for(num=props.majorLineNum;majorLines.length>num;){var majorLine=majorLines[num];frame.removeChild(majorLine),majorLines.splice(num,1)}},links.Timeline.prototype.repaintAxisHorizontal=function(){var axis=this.dom.axis,size=this.size,options=this.options,hasAxis=options.showMinorLabels||options.showMajorLabels;if(hasAxis){if(!axis.backgroundLine){var backgroundLine=document.createElement("DIV");backgroundLine.className="timeline-axis",backgroundLine.style.position="absolute",backgroundLine.style.left="0px",backgroundLine.style.width="100%",backgroundLine.style.border="none",axis.frame.insertBefore(backgroundLine,axis.frame.firstChild),axis.backgroundLine=backgroundLine}axis.backgroundLine&&(axis.backgroundLine.style.top=size.axis.top+"px",axis.backgroundLine.style.height=size.axis.height+"px")}else axis.backgroundLine&&(axis.frame.removeChild(axis.backgroundLine),delete axis.backgroundLine);if(hasAxis){if(axis.line){var line=axis.frame.removeChild(axis.line);axis.frame.appendChild(line)}else{(line=document.createElement("DIV")).className="timeline-axis",line.style.position="absolute",line.style.left="0px",line.style.width="100%",line.style.height="0px",axis.frame.appendChild(line),axis.line=line}axis.line.style.top=size.axis.line+"px"}else axis.line&&axis.line.parentElement&&(axis.frame.removeChild(axis.line),delete axis.line)},links.Timeline.prototype.repaintAxisMinorText=function(x,text){var label,size=this.size,dom=this.dom,props=size.axis.properties,frame=dom.axis.frame,minorTexts=dom.axis.minorTexts,index=props.minorTextNum;if(index<minorTexts.length)label=minorTexts[index];else{var content=document.createTextNode("");(label=document.createElement("DIV")).appendChild(content),label.className="timeline-axis-text timeline-axis-text-minor",label.style.position="absolute",frame.appendChild(label),minorTexts.push(label)}label.childNodes[0].nodeValue=text,label.style.left=x-8+"px",label.style.top=size.axis.labelMinorTop+"px",props.minorTextNum++},links.Timeline.prototype.repaintAxisMinorLine=function(x){var line,axis=this.size.axis,dom=this.dom,props=axis.properties,frame=dom.axis.frame,minorLines=dom.axis.minorLines,index=props.minorLineNum;index<minorLines.length?line=minorLines[index]:((line=document.createElement("DIV")).className="timeline-axis-grid timeline-axis-grid-minor",line.style.position="absolute",line.style.width="0px",frame.appendChild(line),minorLines.push(line)),line.style.top=axis.lineMinorTop+"px",line.style.height=axis.lineMinorHeight+"px",line.style.left=x-axis.lineMinorWidth/2+"px",props.minorLineNum++},links.Timeline.prototype.repaintAxisMajorText=function(x,text){var label,size=this.size,props=size.axis.properties,frame=this.dom.axis.frame,majorTexts=this.dom.axis.majorTexts,index=props.majorTextNum;if(index<majorTexts.length)label=majorTexts[index];else{var content=document.createTextNode(text);(label=document.createElement("DIV")).className="timeline-axis-text timeline-axis-text-major",label.appendChild(content),label.style.position="absolute",label.style.top="0px",frame.appendChild(label),majorTexts.push(label)}label.childNodes[0].nodeValue=text,label.style.top=size.axis.labelMajorTop+"px",label.style.left=x+"px",props.majorTextNum++},links.Timeline.prototype.repaintAxisMajorLine=function(x){var line,size=this.size,props=size.axis.properties,axis=this.size.axis,frame=this.dom.axis.frame,majorLines=this.dom.axis.majorLines,index=props.majorLineNum;index<majorLines.length?line=majorLines[index]:((line=document.createElement("DIV")).className="timeline-axis-grid timeline-axis-grid-major",line.style.position="absolute",line.style.top="0px",line.style.width="0px",frame.appendChild(line),majorLines.push(line)),line.style.left=x-axis.lineMajorWidth/2+"px",line.style.height=size.contentHeight+"px",props.majorLineNum++},links.Timeline.prototype.reflowItems=function(){var i,iMax,group,resized=!1,groups=this.groups,renderedItems=this.renderedItems;for(groups&&AJS.$.each(groups,function(groupIdx,group){group.itemsHeight=0}),i=0,iMax=renderedItems.length;i<iMax;i++){var item=renderedItems[i],domItem=item.dom;if(group=item.group,domItem){var width=domItem?domItem.clientWidth:0,height=domItem?domItem.clientHeight:0;resized=(resized=resized||item.width!=width)||item.height!=height,item.width=width,item.height=height,item.reflow()}group&&(group.itemsHeight=group.itemsHeight?Math.max(group.itemsHeight,item.height):item.height)}return resized},links.Timeline.prototype.recalcItems=function(){var i,iMax,item,finalItem,finalItems,group,resized=!1,groups=this.groups,size=this.size,options=this.options,renderedItems=this.renderedItems,actualHeight=0;if(0==groups.length){if(options.autoHeight||options.cluster){var min=0,max=0;if(this.stack&&this.stack.finalItems)for((finalItem=(finalItems=this.stack.finalItems)[0])&&finalItem.top&&(min=finalItem.top,max=finalItem.top+finalItem.height),i=1,iMax=finalItems.length;i<iMax;i++)finalItem=finalItems[i],min=Math.min(min,finalItem.top),max=Math.max(max,finalItem.top+finalItem.height);else for((item=renderedItems[0])&&item.top&&(min=item.top,max=item.top+item.height),i=1,iMax=renderedItems.length;i<iMax;i++)(item=renderedItems[i]).top&&(min=Math.min(min,item.top),max=Math.max(max,item.top+item.height));if((actualHeight=max-min+2*options.eventMarginAxis+size.axis.height)<options.minHeight&&(actualHeight=options.minHeight),size.actualHeight!=actualHeight&&options.autoHeight&&!options.axisOnTop){var diff=actualHeight-size.actualHeight;if(this.stack&&this.stack.finalItems)for(i=0,iMax=(finalItems=this.stack.finalItems).length;i<iMax;i++)finalItems[i].top+=diff,finalItems[i].item.top+=diff;else for(i=0,iMax=renderedItems.length;i<iMax;i++)renderedItems[i].top+=diff}}}else{for(actualHeight=size.axis.height+2*options.eventMarginAxis,i=0,iMax=groups.length;i<iMax;i++){group=groups[i];var groupHeight=Math.max(group.labelHeight||0,group.itemsHeight||0);resized=resized||groupHeight!=group.height,group.height=groupHeight,actualHeight+=groups[i].height+options.eventMargin}var eventMargin=options.eventMargin,top=options.axisOnTop?options.eventMarginAxis+eventMargin/2:size.contentHeight-options.eventMarginAxis+eventMargin/2,axisHeight=size.axis.height;for(i=0,iMax=groups.length;i<iMax;i++)group=groups[i],options.axisOnTop?(group.top=top+axisHeight,group.labelTop=top+axisHeight+(group.height-group.labelHeight)/2,group.lineTop=top+axisHeight+group.height+eventMargin/2,top+=group.height+eventMargin):(top-=group.height+eventMargin,group.top=top,group.labelTop=top+(group.height-group.labelHeight)/2,group.lineTop=top-eventMargin/2);for(i=0,iMax=renderedItems.length;i<iMax;i++)(group=(item=renderedItems[i]).group)&&(item.top=group.top);resized=!0}return actualHeight<options.minHeight&&(actualHeight=options.minHeight),resized=resized||actualHeight!=size.actualHeight,size.actualHeight=actualHeight,resized},links.Timeline.prototype.clearItems=function(){var hideItems=this.renderQueue.hide;AJS.$.each(this.renderedItems,function(itemIdx,item){hideItems.push(item)}),this.clusterGenerator.clear(),this.items=[]},links.Timeline.prototype.repaintItems=function(){var item,index,needsReflow=!1,dom=this.dom,size=this.size,timeline=this,renderedItems=this.renderedItems;dom.items||(dom.items={});var frame=dom.items.frame;frame||((frame=document.createElement("DIV")).style.position="relative",dom.content.appendChild(frame),dom.items.frame=frame),frame.style.left="0px",frame.style.top=size.items.top+"px",frame.style.height="0px",dom.content.removeChild(frame);var queue=this.renderQueue,newImageUrls=[];for(needsReflow=needsReflow||queue.show.length>0||queue.update.length>0||queue.hide.length>0;item=queue.show.shift();)item.showDOM(frame),item.getImageUrls(newImageUrls),renderedItems.push(item);for(;item=queue.update.shift();)item.updateDOM(frame),item.getImageUrls(newImageUrls),-1==(index=AJS.$.inArray(item,this.renderedItems))&&renderedItems.push(item);for(;item=queue.hide.shift();)item.hideDOM(frame),-1!=(index=AJS.$.inArray(item,this.renderedItems))&&renderedItems.splice(index,1);if(AJS.$.each(renderedItems,function(itemIdx,item){item.updatePosition(timeline)}),this.repaintDeleteButton(),this.repaintDragAreas(),dom.content.appendChild(frame),newImageUrls.length){links.imageloader.loadAll(newImageUrls,function(){timeline.render()},!1)}return needsReflow},links.Timeline.prototype.reflowGroups=function(){for(var resized=!1,options=this.options,size=this.size,dom=this.dom,groupsWidth=0,groups=this.groups,labels=this.dom.groups?this.dom.groups.labels:[],i=0,iMax=groups.length;i<iMax;i++){var group=groups[i],label=labels[i];group.labelWidth=label?label.clientWidth:0,group.labelHeight=label?label.clientHeight:0,group.width=group.labelWidth,groupsWidth=Math.max(groupsWidth,group.width)}void 0!==options.groupsWidth&&(groupsWidth=dom.groups.frame?dom.groups.frame.clientWidth:0),groupsWidth+=1;var groupsLeft=options.groupsOnRight?size.frameWidth-groupsWidth:0;return resized=(resized=resized||size.groupsWidth!==groupsWidth)||size.groupsLeft!==groupsLeft,size.groupsWidth=groupsWidth,size.groupsLeft=groupsLeft,resized},links.Timeline.prototype.repaintGroups=function(){var dom=this.dom,timeline=this,options=this.options,size=this.size,groups=this.groups;void 0===dom.groups&&(dom.groups={});var labels=dom.groups.labels;labels||(labels=[],dom.groups.labels=labels);var labelLines=dom.groups.labelLines;labelLines||(labelLines=[],dom.groups.labelLines=labelLines);var itemLines=dom.groups.itemLines;itemLines||(itemLines=[],dom.groups.itemLines=itemLines);var frame=dom.groups.frame;frame||((frame=document.createElement("DIV")).className="timeline-groups-axis",frame.style.position="absolute",frame.style.overflow="hidden",frame.style.top="0px",frame.style.height="100%",dom.frame.appendChild(frame),dom.groups.frame=frame),frame.style.left=size.groupsLeft+"px",frame.style.width=void 0!==options.groupsWidth?options.groupsWidth:size.groupsWidth+"px",0==groups.length?frame.style.display="none":frame.style.display="";for(var current=labels.length,needed=groups.length,i=0,iMax=Math.min(current,needed);i<iMax;i++){var group=groups[i];(label=labels[i]).innerHTML=this.getGroupName(group),label.style.display=""}for(i=current;i<needed;i++){group=groups[i];(label=document.createElement("DIV")).className="timeline-groups-text",label.style.position="absolute",void 0===options.groupsWidth&&(label.style.whiteSpace="nowrap"),label.innerHTML=this.getGroupName(group),frame.appendChild(label),labels[i]=label,(labelLine=document.createElement("DIV")).className="timeline-axis-grid timeline-axis-grid-minor",labelLine.style.position="absolute",labelLine.style.left="0px",labelLine.style.width="100%",labelLine.style.height="0px",labelLine.style.borderTopStyle="solid",frame.appendChild(labelLine),labelLines[i]=labelLine,(itemLine=document.createElement("DIV")).className="timeline-axis-grid timeline-axis-grid-minor",itemLine.style.position="absolute",itemLine.style.left="0px",itemLine.style.width="100%",itemLine.style.height="0px",itemLine.style.borderTopStyle="solid",dom.content.insertBefore(itemLine,dom.content.firstChild),itemLines[i]=itemLine}for(i=needed;i<current;i++){var label=labels[i],labelLine=labelLines[i],itemLine=itemLines[i];frame.removeChild(label),frame.removeChild(labelLine),dom.content.removeChild(itemLine)}labels.splice(needed,current-needed),labelLines.splice(needed,current-needed),itemLines.splice(needed,current-needed),frame.style.borderStyle=options.groupsOnRight?"none none none solid":"none solid none none";for(i=0,iMax=groups.length;i<iMax;i++){group=groups[i],label=labels[i],labelLine=labelLines[i],itemLine=itemLines[i];label.style.top=group.labelTop+"px",labelLine.style.top=group.lineTop+"px",itemLine.style.top=group.lineTop+"px",itemLine.style.width=size.contentWidth+"px"}if(!dom.groups.background){var background=document.createElement("DIV");background.className="timeline-axis",background.style.position="absolute",background.style.left="0px",background.style.width="100%",background.style.border="none",frame.appendChild(background),dom.groups.background=background}if(dom.groups.background.style.top=size.axis.top+"px",dom.groups.background.style.height=size.axis.height+"px",!dom.groups.line){var line=document.createElement("DIV");line.className="timeline-axis",line.style.position="absolute",line.style.left="0px",line.style.width="100%",line.style.height="0px",frame.appendChild(line),dom.groups.line=line}if(dom.groups.line.style.top=size.axis.line+"px",dom.groups.frame&&groups.length){var imageUrls=[];if(links.imageloader.filterImageUrls(dom.groups.frame,imageUrls),imageUrls.length){links.imageloader.loadAll(imageUrls,function(){timeline.render()},!1)}}},links.Timeline.prototype.repaintCurrentTime=function(){var options=this.options,dom=this.dom,size=this.size;if(options.showCurrentTime){if(dom.currentTime)dom.currentTime.style.height=size.contentHeight+"px";else{var currentTime=document.createElement("DIV");currentTime.className="timeline-currenttime",currentTime.style.position="absolute",currentTime.style.top="0px",currentTime.style.height="100%",dom.contentTimelines.appendChild(currentTime),dom.currentTime=currentTime}var now=new Date,nowOffset=new Date(now.valueOf()+this.clientTimeOffset),x=this.timeToScreen(nowOffset),visible=x>-size.contentWidth&&x<2*size.contentWidth;dom.currentTime.style.display=visible?"":"none",dom.currentTime.style.left=x+"px",dom.currentTime.title="Current time: "+nowOffset,null!=this.currentTimeTimer&&(clearTimeout(this.currentTimeTimer),delete this.currentTimeTimer);var timeline=this,interval=1/this.conversion.factor/2;interval<30&&(interval=30),this.currentTimeTimer=setTimeout(function(){timeline.repaintCurrentTime()},interval)}else dom.currentTime&&(dom.contentTimelines.removeChild(dom.currentTime),delete dom.currentTime)},links.Timeline.prototype.repaintCustomTime=function(){var options=this.options,dom=this.dom,size=this.size;if(options.showCustomTime){if(!dom.customTime){var customTime=document.createElement("DIV");customTime.className="timeline-customtime",customTime.style.position="absolute",customTime.style.top="0px",customTime.style.height="100%";var drag=document.createElement("DIV");drag.style.position="relative",drag.style.top="0px",drag.style.left="-10px",drag.style.height="100%",drag.style.width="20px",customTime.appendChild(drag),dom.contentTimelines.appendChild(customTime),dom.customTime=customTime,this.customTime=new Date}var x=this.timeToScreen(this.customTime),visible=x>-size.contentWidth&&x<2*size.contentWidth;dom.customTime.style.display=visible?"":"none",dom.customTime.style.left=x+"px",dom.customTime.title="Time: "+this.customTime}else dom.customTime&&(dom.contentTimelines.removeChild(dom.customTime),delete dom.customTime)},links.Timeline.prototype.repaintDeleteButton=function(){var dom=this.dom,frame=dom.items.frame,deleteButton=dom.items.deleteButton;deleteButton||((deleteButton=document.createElement("DIV")).className="timeline-navigation-delete",deleteButton.style.position="absolute",frame.appendChild(deleteButton),dom.items.deleteButton=deleteButton);var index=this.selection?this.selection.index:-1,item=this.selection?this.items[index]:void 0;if(item&&item.rendered&&this.isEditable(item)){var right=item.getRight(this),top=item.top;deleteButton.style.left=right+"px",deleteButton.style.top=top+"px",deleteButton.style.display="",frame.removeChild(deleteButton),frame.appendChild(deleteButton)}else deleteButton.style.display="none"},links.Timeline.prototype.repaintDragAreas=function(){var options=this.options,dom=this.dom,frame=this.dom.items.frame,dragLeft=dom.items.dragLeft;dragLeft||((dragLeft=document.createElement("DIV")).className="timeline-event-range-drag-left",dragLeft.style.position="absolute",frame.appendChild(dragLeft),dom.items.dragLeft=dragLeft);var dragRight=dom.items.dragRight;dragRight||((dragRight=document.createElement("DIV")).className="timeline-event-range-drag-right",dragRight.style.position="absolute",frame.appendChild(dragRight),dom.items.dragRight=dragRight);var index=this.selection?this.selection.index:-1,item=this.selection?this.items[index]:void 0;if(item&&item.rendered&&this.isEditable(item)&&item instanceof links.Timeline.ItemRange){var left=this.timeToScreen(item.start),right=this.timeToScreen(item.end),top=item.top,height=item.height;dragLeft.style.left=left+"px",dragLeft.style.top=top+"px",dragLeft.style.width=options.dragAreaWidth+"px",dragLeft.style.height=height+"px",dragLeft.style.display="",frame.removeChild(dragLeft),frame.appendChild(dragLeft),dragRight.style.left=right-options.dragAreaWidth+"px",dragRight.style.top=top+"px",dragRight.style.width=options.dragAreaWidth+"px",dragRight.style.height=height+"px",dragRight.style.display="",frame.removeChild(dragRight),frame.appendChild(dragRight)}else dragLeft.style.display="none",dragRight.style.display="none"},links.Timeline.prototype.repaintNavigation=function(){var timeline=this,options=this.options,dom=this.dom,navBar=(dom.frame,dom.navBar);if(!navBar){var showButtonNew=options.showButtonNew&&options.editable,showNavigation=options.showNavigation&&(options.zoomable||options.moveable);if((showNavigation||showButtonNew)&&((navBar=document.createElement("DIV")).style.position="absolute",navBar.className="timeline-navigation",options.groupsOnRight?navBar.style.left="10px":navBar.style.right="32px",options.axisOnTop?navBar.style.bottom="10px":navBar.style.top="10px",dom.navBar=navBar,dom.container.appendChild(navBar)),showButtonNew){navBar.addButton=document.createElement("DIV"),navBar.addButton.className="timeline-navigation-new",navBar.addButton.title=options.CREATE_NEW_EVENT;links.Timeline.addEventListener(navBar.addButton,"mousedown",function(event){links.Timeline.preventDefault(event),links.Timeline.stopPropagation(event);var w=timeline.size.contentWidth,x=w/2,xstart=timeline.screenToTime(x-w/10),xend=timeline.screenToTime(x+w/10);options.snapEvents&&(timeline.step.snap(xstart),timeline.step.snap(xend));var content=options.NEW,group=timeline.groups.length?timeline.groups[0].content:void 0;timeline.addItem({start:xstart,end:xend,content:content,group:group},!0);var index=timeline.items.length-1;timeline.selectItem(index),timeline.applyAdd=!0,timeline.trigger("add"),timeline.applyAdd?(timeline.render({animate:!1}),timeline.selectItem(index)):timeline.deleteItem(index)}),navBar.appendChild(navBar.addButton)}if(showButtonNew&&showNavigation&&(navBar.addButton.style.borderRightWidth="1px",navBar.addButton.style.borderRightStyle="solid"),showNavigation){if(options.zoomable){navBar.zoomInButton=document.createElement("DIV"),navBar.zoomInButton.className="timeline-navigation-zoom-in aui-icon aui-icon-small aui-iconfont-add",navBar.zoomInButton.role="button",navBar.zoomInButton.ariaLabel=this.options.ZOOM_IN,navBar.zoomInButton.title=this.options.ZOOM_IN;links.Timeline.addEventListener(navBar.zoomInButton,"mousedown",function(event){links.Timeline.preventDefault(event),links.Timeline.stopPropagation(event),timeline.zoom(.4),timeline.trigger("rangechange"),timeline.trigger("rangechanged")}),navBar.appendChild(navBar.zoomInButton),navBar.zoomOutButton=document.createElement("DIV"),navBar.zoomOutButton.className="timeline-navigation-zoom-out aui-icon aui-icon-small aui-iconfont-horizontal-rule",navBar.zoomInButton.role="button",navBar.zoomInButton.ariaLabel=this.options.ZOOM_OUT,navBar.zoomInButton.title=this.options.ZOOM_OUT;links.Timeline.addEventListener(navBar.zoomOutButton,"mousedown",function(event){links.Timeline.preventDefault(event),links.Timeline.stopPropagation(event),timeline.zoom(-.4),timeline.trigger("rangechange"),timeline.trigger("rangechanged")}),navBar.appendChild(navBar.zoomOutButton)}if(options.moveable){navBar.moveLeftButton=document.createElement("DIV"),navBar.moveLeftButton.className="timeline-navigation-move-left",navBar.moveLeftButton.title=this.options.MOVE_LEFT;links.Timeline.addEventListener(navBar.moveLeftButton,"mousedown",function(event){links.Timeline.preventDefault(event),links.Timeline.stopPropagation(event),timeline.move(-.2),timeline.trigger("rangechange"),timeline.trigger("rangechanged")}),navBar.appendChild(navBar.moveLeftButton),navBar.moveRightButton=document.createElement("DIV"),navBar.moveRightButton.className="timeline-navigation-move-right",navBar.moveRightButton.title=this.options.MOVE_RIGHT;links.Timeline.addEventListener(navBar.moveRightButton,"mousedown",function(event){links.Timeline.preventDefault(event),links.Timeline.stopPropagation(event),timeline.move(.2),timeline.trigger("rangechange"),timeline.trigger("rangechanged")}),navBar.appendChild(navBar.moveRightButton)}}}},links.Timeline.prototype.setCurrentTime=function(time){var now=new Date;this.clientTimeOffset=time.valueOf()-now.valueOf(),this.repaintCurrentTime()},links.Timeline.prototype.getCurrentTime=function(){var now=new Date;return new Date(now.valueOf()+this.clientTimeOffset)},links.Timeline.prototype.setCustomTime=function(time){this.customTime=new Date(time.valueOf()),this.repaintCustomTime()},links.Timeline.prototype.getCustomTime=function(){return new Date(this.customTime.valueOf())},links.Timeline.prototype.setScale=function(scale,step){this.step.setScale(scale,step),this.render()},links.Timeline.prototype.setAutoScale=function(enable){this.step.setAutoScale(enable),this.render()},links.Timeline.prototype.redraw=function(){this.setData(this.data)},links.Timeline.prototype.checkResize=function(){this.render()},links.Timeline.prototype.isEditable=function(item){return!!item&&(null!=item.editable?item.editable:this.options.editable)},links.Timeline.prototype.recalcConversion=function(){this.conversion.offset=this.start.valueOf(),this.conversion.factor=this.size.contentWidth/(this.end.valueOf()-this.start.valueOf())},links.Timeline.prototype.screenToTime=function(x){var conversion=this.conversion;return new Date(x/conversion.factor+conversion.offset)},links.Timeline.prototype.timeToScreen=function(time){var conversion=this.conversion;return(time.valueOf()-conversion.offset)*conversion.factor},links.Timeline.prototype.onTouchStart=function(event){var params=this.eventParams,me=this;if(!params.touchDown){params.touchDown=!0,params.zoomed=!1,this.onMouseDown(event),params.onTouchMove||(params.onTouchMove=function(event){me.onTouchMove(event)},links.Timeline.addEventListener(document,"touchmove",params.onTouchMove)),params.onTouchEnd||(params.onTouchEnd=function(event){me.onTouchEnd(event)},links.Timeline.addEventListener(document,"touchend",params.onTouchEnd));var target=links.Timeline.getTarget(event),item=this.getItemIndex(target);params.doubleTapStartPrev=params.doubleTapStart,params.doubleTapStart=(new Date).valueOf(),params.doubleTapItemPrev=params.doubleTapItem,params.doubleTapItem=item,links.Timeline.preventDefault(event)}},links.Timeline.prototype.onTouchMove=function(event){var params=this.eventParams;if(event.scale&&1!==event.scale&&(params.zoomed=!0),params.zoomed){if(this.options.zoomable){params.zoomed=!0;var scale=event.scale,oldWidth=params.end.valueOf()-params.start.valueOf(),diff=oldWidth/scale-oldWidth,start=new Date(parseInt(params.start.valueOf()-diff/2)),end=new Date(parseInt(params.end.valueOf()+diff/2));this.setVisibleChartRange(start,end),this.trigger("rangechange")}}else this.onMouseMove(event);links.Timeline.preventDefault(event)},links.Timeline.prototype.onTouchEnd=function(event){var params=this.eventParams;params.touchDown=!1,params.zoomed&&this.trigger("rangechanged"),params.onTouchMove&&(links.Timeline.removeEventListener(document,"touchmove",params.onTouchMove),delete params.onTouchMove),params.onTouchEnd&&(links.Timeline.removeEventListener(document,"touchend",params.onTouchEnd),delete params.onTouchEnd),this.onMouseUp(event);var doubleTapEnd=(new Date).valueOf(),target=links.Timeline.getTarget(event);this.getItemIndex(target);params.doubleTapStartPrev&&doubleTapEnd-params.doubleTapStartPrev<500&&params.doubleTapItem==params.doubleTapItemPrev&&(params.touchDown=!0,this.onDblClick(event),params.touchDown=!1),links.Timeline.preventDefault(event)},links.Timeline.prototype.onMouseDown=function(event){event=event||window.event;var params=this.eventParams,options=this.options,dom=this.dom;if((event.which?1==event.which:1==event.button)||params.touchDown){params.mouseX=links.Timeline.getPageX(event),params.mouseY=links.Timeline.getPageY(event),params.frameLeft=links.Timeline.getAbsoluteLeft(this.dom.content),params.frameTop=links.Timeline.getAbsoluteTop(this.dom.content),params.previousLeft=0,params.previousOffset=0,params.moved=!1,params.start=new Date(this.start.valueOf()),params.end=new Date(this.end.valueOf()),params.target=links.Timeline.getTarget(event);var dragLeft=dom.items&&dom.items.dragLeft?dom.items.dragLeft:void 0,dragRight=dom.items&&dom.items.dragRight?dom.items.dragRight:void 0;if(params.itemDragLeft=params.target===dragLeft,params.itemDragRight=params.target===dragRight,params.itemDragLeft||params.itemDragRight?params.itemIndex=this.selection?this.selection.index:void 0:params.itemIndex=this.getItemIndex(params.target),params.customTime=params.target===dom.customTime||params.target.parentNode===dom.customTime?this.customTime:void 0,params.addItem=options.editable&&event.ctrlKey,params.addItem){var x=params.mouseX-params.frameLeft,y=params.mouseY-params.frameTop,xstart=this.screenToTime(x);options.snapEvents&&this.step.snap(xstart);var xend=new Date(xstart.valueOf()),content=options.NEW,group=this.getGroupFromHeight(y);this.addItem({start:xstart,end:xend,content:content,group:this.getGroupName(group)}),params.itemIndex=this.items.length-1,this.selectItem(params.itemIndex),params.itemDragRight=!0}var item=this.items[params.itemIndex],isSelected=this.isSelected(params.itemIndex);if(params.editItem=isSelected&&this.isEditable(item),params.editItem?(params.itemStart=item.start,params.itemEnd=item.end,params.itemGroup=item.group,params.itemLeft=item.start?this.timeToScreen(item.start):void 0,params.itemRight=item.end?this.timeToScreen(item.end):void 0):this.dom.frame.style.cursor="move",!params.touchDown){var me=this;params.onMouseMove||(params.onMouseMove=function(event){me.onMouseMove(event)},links.Timeline.addEventListener(document,"mousemove",params.onMouseMove)),params.onMouseUp||(params.onMouseUp=function(event){me.onMouseUp(event)},links.Timeline.addEventListener(document,"mouseup",params.onMouseUp)),links.Timeline.preventDefault(event)}}},links.Timeline.prototype.onMouseMove=function(event){event=event||window.event;var params=this.eventParams,size=this.size,dom=this.dom,options=this.options,mouseX=links.Timeline.getPageX(event),mouseY=links.Timeline.getPageY(event);null==params.mouseX&&(params.mouseX=mouseX),null==params.mouseY&&(params.mouseY=mouseY);var diffX=mouseX-params.mouseX;params.mouseY;if(Math.abs(diffX)>=1&&(params.moved=!0),params.customTime){var xnew=this.timeToScreen(params.customTime)+diffX;this.customTime=this.screenToTime(xnew),this.repaintCustomTime(),this.trigger("timechange")}else if(params.editItem){this.trigger("moved");var left,right,item=this.items[params.itemIndex];params.itemDragLeft?(left=params.itemLeft+diffX,right=params.itemRight,item.start=this.screenToTime(left),options.snapEvents&&(this.step.snap(item.start),left=this.timeToScreen(item.start)),left>right&&(left=right,item.start=this.screenToTime(left))):params.itemDragRight?(left=params.itemLeft,right=params.itemRight+diffX,item.end=this.screenToTime(right),options.snapEvents&&(this.step.snap(item.end),right=this.timeToScreen(item.end)),right<left&&(right=left,item.end=this.screenToTime(right))):(left=params.itemLeft+diffX,item.start=this.screenToTime(left),options.snapEvents&&(this.step.snap(item.start),left=this.timeToScreen(item.start)),item.end&&(right=left+(params.itemRight-params.itemLeft),item.end=this.screenToTime(right))),item.setPosition(left,right);var dragging=params.itemDragLeft||params.itemDragRight;if(this.groups.length&&!dragging){var y=mouseY-params.frameTop,group=this.getGroupFromHeight(y);if(options.groupsChangeable&&item.group!==group){var index=AJS.$.inArray(item,this.items);this.changeItem(index,{group:this.getGroupName(group)})}else this.repaintDeleteButton(),this.repaintDragAreas()}else this.render()}else if(options.moveable){var interval=params.end.valueOf()-params.start.valueOf(),diffMillisecs=Math.round(-diffX/size.contentWidth*interval),newStart=new Date(params.start.valueOf()+diffMillisecs),newEnd=new Date(params.end.valueOf()+diffMillisecs);this.applyRange(newStart,newEnd);var appliedDiff=this.start.valueOf()-newStart.valueOf();appliedDiff&&(diffMillisecs+=appliedDiff),this.recalcConversion();var previousLeft=params.previousLeft||0,currentLeft=parseFloat(dom.items.frame.style.left)||0,frameOffset=(params.previousOffset||0)+(currentLeft-previousLeft),frameLeft=-diffMillisecs/interval*size.contentWidth+frameOffset;dom.items.frame.style.left=frameLeft+"px",params.previousOffset=frameOffset,params.previousLeft=parseFloat(dom.items.frame.style.left)||frameLeft,this.repaintCurrentTime(),this.repaintCustomTime(),this.repaintAxis(),this.trigger("rangechange")}links.Timeline.preventDefault(event)},links.Timeline.prototype.onMouseUp=function(event){var params=this.eventParams,options=this.options;if(event=event||window.event,this.dom.frame.style.cursor="auto",params.onMouseMove&&(links.Timeline.removeEventListener(document,"mousemove",params.onMouseMove),delete params.onMouseMove),params.onMouseUp&&(links.Timeline.removeEventListener(document,"mouseup",params.onMouseUp),delete params.onMouseUp),params.customTime)this.trigger("timechanged");else if(params.editItem){var item=this.items[params.itemIndex];if(params.moved||params.addItem){if(this.applyChange=!0,this.applyAdd=!0,this.updateData(params.itemIndex,{start:item.start,end:item.end}),this.trigger(params.addItem?"add":"change"),params.addItem)this.applyAdd?this.updateData(params.itemIndex,{start:item.start,end:item.end,content:item.content,group:this.getGroupName(item.group)}):this.deleteItem(params.itemIndex);else if(this.applyChange)this.updateData(params.itemIndex,{start:item.start,end:item.end});else{delete this.applyChange,delete this.applyAdd;(item=this.items[params.itemIndex]).dom;item.start=params.itemStart,item.end=params.itemEnd,item.group=params.itemGroup,item.setPosition(params.itemLeft,params.itemRight)}this.options.cluster&&this.clusterGenerator.updateData(),this.render()}}else params.moved||params.zoomed?(this.render(),(params.moved&&options.moveable||params.zoomed&&options.zoomable)&&this.trigger("rangechanged")):params.target===this.dom.items.deleteButton?this.selection&&this.confirmDeleteItem(this.selection.index):options.selectable&&(null!=params.itemIndex?this.isSelected(params.itemIndex)||(this.selectItem(params.itemIndex),this.trigger("select")):(this.unselectItem(),this.trigger("select")))},links.Timeline.prototype.onDblClick=function(event){var params=this.eventParams,options=this.options;this.dom,this.size;if(event=event||window.event,null!=params.itemIndex){var item=this.items[params.itemIndex];item&&this.isEditable(item)&&this.trigger("edit")}else options.editable&&this.trigger("add");links.Timeline.preventDefault(event)},links.Timeline.prototype.onMouseWheel=function(event){if(this.options.zoomable){event||(event=window.event);var zoomFactor,frameLeft,mouseX,zoomAroundDate,delta=0;if(event.wheelDelta?delta=event.wheelDelta/120:event.detail&&(delta=-event.detail/3),delta){var timeline=this;zoomFactor=delta/5,frameLeft=links.Timeline.getAbsoluteLeft(timeline.dom.content),mouseX=links.Timeline.getPageX(event),zoomAroundDate=null!=mouseX&&null!=frameLeft?timeline.screenToTime(mouseX-frameLeft):void 0,timeline.zoom(zoomFactor,zoomAroundDate),timeline.trigger("rangechange"),timeline.trigger("rangechanged")}links.Timeline.preventDefault(event)}},links.Timeline.prototype.zoom=function(zoomFactor,zoomAroundDate){null==zoomAroundDate&&(zoomAroundDate=new Date((this.start.valueOf()+this.end.valueOf())/2)),zoomFactor>=1&&(zoomFactor=.9),zoomFactor<=-1&&(zoomFactor=-.9),zoomFactor<0&&(zoomFactor/=1+zoomFactor);var startDiff=this.start.valueOf()-zoomAroundDate,endDiff=this.end.valueOf()-zoomAroundDate,newStart=new Date(this.start.valueOf()-startDiff*zoomFactor),newEnd=new Date(this.end.valueOf()-endDiff*zoomFactor),interval=newEnd.valueOf()-newStart.valueOf(),zoomMin=Number(this.options.zoomMin)||10;zoomMin<10&&(zoomMin=10),interval>=zoomMin&&(this.applyRange(newStart,newEnd,zoomAroundDate),this.render({animate:this.options.animate&&this.options.animateZoom}))},links.Timeline.prototype.move=function(moveFactor){var diff=this.end.valueOf()-this.start.valueOf(),newStart=new Date(this.start.valueOf()+diff*moveFactor),newEnd=new Date(this.end.valueOf()+diff*moveFactor);this.applyRange(newStart,newEnd),this.render()},links.Timeline.prototype.applyRange=function(start,end,zoomAroundDate){var startValue=start.valueOf(),endValue=end.valueOf(),interval=endValue-startValue,options=this.options,year=31536e6,zoomMin=Number(options.zoomMin)||10;zoomMin<10&&(zoomMin=10);var zoomMax=Number(options.zoomMax)||1e4*year;zoomMax>1e4*year&&(zoomMax=1e4*year),zoomMax<zoomMin&&(zoomMax=zoomMin);var min=options.min?options.min.valueOf():void 0,max=options.max?options.max.valueOf():void 0;if(null!=min&&null!=max){if(min>=max){max=min+864e5}zoomMax>max-min&&(zoomMax=max-min),zoomMin>max-min&&(zoomMin=max-min)}if(startValue>=endValue&&(endValue+=864e5),interval<zoomMin){var diff=zoomMin-interval,f=zoomAroundDate?(zoomAroundDate.valueOf()-startValue)/interval:.5;startValue-=Math.round(diff*f),endValue+=Math.round(diff*(1-f))}if(interval>zoomMax){var diff=interval-zoomMax;f=zoomAroundDate?(zoomAroundDate.valueOf()-startValue)/interval:.5;startValue+=Math.round(diff*f),endValue-=Math.round(diff*(1-f))}null!=min&&((diff=startValue-min)<0&&(startValue-=diff,endValue-=diff));null!=max&&((diff=max-endValue)<0&&(startValue+=diff,endValue+=diff));this.start=new Date(startValue),this.end=new Date(endValue)},links.Timeline.prototype.confirmDeleteItem=function(index){this.applyDelete=!0,this.isSelected(index)||this.selectItem(index),this.trigger("delete"),this.applyDelete&&this.deleteItem(index),delete this.applyDelete},links.Timeline.prototype.deleteItem=function(index,preventRender){if(index>=this.items.length)throw"Cannot delete row, index out of range";this.selection&&(this.selection.index==index?this.unselectItem():this.selection.index>index&&this.selection.index--);var item=this.items.splice(index,1)[0];if(this.renderQueue.hide.push(item),this.data)if(google&&google.visualization&&this.data instanceof google.visualization.DataTable)this.data.removeRow(index);else{if(!links.Timeline.isArray(this.data))throw"Cannot delete row from data, unknown data type";this.data.splice(index,1)}this.options.cluster&&this.clusterGenerator.updateData(),preventRender||this.render()},links.Timeline.prototype.deleteAllItems=function(){if(this.unselectItem(),this.clearItems(),this.deleteGroups(),this.data)if(google&&google.visualization&&this.data instanceof google.visualization.DataTable)this.data.removeRows(0,this.data.getNumberOfRows());else{if(!links.Timeline.isArray(this.data))throw"Cannot delete row from data, unknown data type";this.data.splice(0,this.data.length)}this.options.cluster&&this.clusterGenerator.updateData(),this.render()},links.Timeline.prototype.getGroupFromHeight=function(height){var i,group,groups=this.groups;if(groups.length){if(this.options.axisOnTop){for(i=groups.length-1;i>=0;i--)if(height>(group=groups[i]).top)return group}else for(i=0;i<groups.length;i++)if(height>(group=groups[i]).top)return group;return group}},links.Timeline.Item=function(data,options){if(data&&(this.start=data.start,this.end=data.end,this.content=data.content,this.className=data.className,this.editable=data.editable,this.group=data.group),this.top=0,this.left=0,this.width=0,this.height=0,this.lineWidth=0,this.dotWidth=0,this.dotHeight=0,this.rendered=!1,options)for(var option in options)options.hasOwnProperty(option)&&(this[option]=options[option])},links.Timeline.Item.prototype.reflow=function(){return!1},links.Timeline.Item.prototype.getImageUrls=function(imageUrls){this.dom&&links.imageloader.filterImageUrls(this.dom,imageUrls)},links.Timeline.Item.prototype.select=function(){},links.Timeline.Item.prototype.unselect=function(){},links.Timeline.Item.prototype.createDOM=function(){},links.Timeline.Item.prototype.showDOM=function(container){},links.Timeline.Item.prototype.hideDOM=function(container){},links.Timeline.Item.prototype.updateDOM=function(){},links.Timeline.Item.prototype.updatePosition=function(timeline){},links.Timeline.Item.prototype.isRendered=function(){return this.rendered},links.Timeline.Item.prototype.isVisible=function(start,end){return!1},links.Timeline.Item.prototype.setPosition=function(left,right){},links.Timeline.Item.prototype.getRight=function(timeline){return 0},links.Timeline.Item.prototype.getWidth=function(timeline){return this.width||0},links.Timeline.ItemBox=function(data,options){links.Timeline.Item.call(this,data,options)},links.Timeline.ItemBox.prototype=new links.Timeline.Item,links.Timeline.ItemBox.prototype.reflow=function(){var dom=this.dom,dotHeight=dom.dot.offsetHeight,dotWidth=dom.dot.offsetWidth,lineWidth=dom.line.offsetWidth,resized=this.dotHeight!=dotHeight||this.dotWidth!=dotWidth||this.lineWidth!=lineWidth;return this.dotHeight=dotHeight,this.dotWidth=dotWidth,this.lineWidth=lineWidth,resized},links.Timeline.ItemBox.prototype.select=function(){var dom=this.dom;links.Timeline.addClassName(dom,"timeline-event-selected"),links.Timeline.addClassName(dom.line,"timeline-event-selected"),links.Timeline.addClassName(dom.dot,"timeline-event-selected")},links.Timeline.ItemBox.prototype.unselect=function(){var dom=this.dom;links.Timeline.removeClassName(dom,"timeline-event-selected"),links.Timeline.removeClassName(dom.line,"timeline-event-selected"),links.Timeline.removeClassName(dom.dot,"timeline-event-selected")},links.Timeline.ItemBox.prototype.createDOM=function(){var divBox=document.createElement("DIV");divBox.style.position="absolute",divBox.style.left=this.left+"px",divBox.style.top=this.top+"px";var divContent=document.createElement("DIV");divContent.className="timeline-event-content",divContent.innerHTML=this.content,divBox.appendChild(divContent);var divLine=document.createElement("DIV");divLine.style.position="absolute",divLine.style.width="0px",divBox.line=divLine;var divDot=document.createElement("DIV");return divDot.style.position="absolute",divDot.style.width="0px",divDot.style.height="0px",divBox.dot=divDot,this.dom=divBox,this.updateDOM(),divBox},links.Timeline.ItemBox.prototype.showDOM=function(container){var dom=this.dom;dom||(dom=this.createDOM()),dom.parentNode!=container&&(dom.parentNode&&this.hideDOM(),container.appendChild(dom),container.insertBefore(dom.line,container.firstChild),container.appendChild(dom.dot),this.rendered=!0)},links.Timeline.ItemBox.prototype.hideDOM=function(){var dom=this.dom;if(dom&&dom.parentNode){var removeChild=function(toRemove){toRemove&&toRemove.parentNode&&toRemove.parentNode.removeChild(toRemove)};removeChild(dom.line),removeChild(dom.dot),removeChild(dom),this.rendered=!1}},links.Timeline.ItemBox.prototype.updateDOM=function(){var divBox=this.dom;if(divBox){var divLine=divBox.line,divDot=divBox.dot;divBox.firstChild.innerHTML=this.content,divBox.className="timeline-event timeline-event-box",divLine.className="timeline-event timeline-event-line",divDot.className="timeline-event timeline-event-dot",this.isCluster&&(links.Timeline.addClassName(divBox,"timeline-event-cluster"),links.Timeline.addClassName(divLine,"timeline-event-cluster"),links.Timeline.addClassName(divDot,"timeline-event-cluster")),this.className&&(links.Timeline.addClassName(divBox,this.className),links.Timeline.addClassName(divLine,this.className),links.Timeline.addClassName(divDot,this.className))}},links.Timeline.ItemBox.prototype.updatePosition=function(timeline){var dom=this.dom;if(dom){var left=timeline.timeToScreen(this.start),axisOnTop=timeline.options.axisOnTop,axisTop=timeline.size.axis.top,axisHeight=timeline.size.axis.height,boxAlign=timeline.options.box&&timeline.options.box.align?timeline.options.box.align:void 0;dom.style.top=this.top+"px",dom.style.left="right"==boxAlign?left-this.width+"px":"left"==boxAlign?left+"px":left-this.width/2+"px";var line=dom.line,dot=dom.dot;line.style.left=left-this.lineWidth/2+"px",dot.style.left=left-this.dotWidth/2+"px",axisOnTop?(line.style.top=axisHeight+"px",line.style.height=Math.max(this.top-axisHeight,0)+"px",dot.style.top=axisHeight-this.dotHeight/2+"px"):(line.style.top=this.top+this.height+"px",line.style.height=Math.max(axisTop-this.top-this.height,0)+"px",dot.style.top=axisTop-this.dotHeight/2+"px")}},links.Timeline.ItemBox.prototype.isVisible=function(start,end){return!this.cluster&&(this.start>start&&this.start<end)},links.Timeline.ItemBox.prototype.setPosition=function(left,right){var dom=this.dom;dom.style.left=left-this.width/2+"px",dom.line.style.left=left-this.lineWidth/2+"px",dom.dot.style.left=left-this.dotWidth/2+"px",this.group&&(this.top=this.group.top,dom.style.top=this.top+"px")},links.Timeline.ItemBox.prototype.getRight=function(timeline){var boxAlign=timeline.options.box&&timeline.options.box.align?timeline.options.box.align:void 0,left=timeline.timeToScreen(this.start);return"right"==boxAlign?left:"left"==boxAlign?left+this.width:left+this.width/2},links.Timeline.ItemRange=function(data,options){links.Timeline.Item.call(this,data,options)},links.Timeline.ItemRange.prototype=new links.Timeline.Item,links.Timeline.ItemRange.prototype.select=function(){var dom=this.dom;links.Timeline.addClassName(dom,"timeline-event-selected")},links.Timeline.ItemRange.prototype.unselect=function(){var dom=this.dom;links.Timeline.removeClassName(dom,"timeline-event-selected")},links.Timeline.ItemRange.prototype.createDOM=function(){var divBox=document.createElement("DIV");divBox.style.position="absolute";var divContent=document.createElement("DIV");return divContent.className="timeline-event-content",divBox.appendChild(divContent),this.dom=divBox,this.updateDOM(),divBox},links.Timeline.ItemRange.prototype.showDOM=function(container){var dom=this.dom;dom||(dom=this.createDOM()),dom.parentNode!=container&&(dom.parentNode&&this.hideDOM(),container.appendChild(dom),this.rendered=!0)},links.Timeline.ItemRange.prototype.hideDOM=function(){var dom=this.dom;dom&&(dom.parentNode&&dom.parentNode.removeChild(dom),this.rendered=!1)},links.Timeline.ItemRange.prototype.updateDOM=function(){var divBox=this.dom;divBox&&(divBox.firstChild.innerHTML=this.content,divBox.className="timeline-event timeline-event-range",this.isCluster&&links.Timeline.addClassName(divBox,"timeline-event-cluster"),this.className&&links.Timeline.addClassName(divBox,this.className))},links.Timeline.ItemRange.prototype.updatePosition=function(timeline){var dom=this.dom;if(dom){var contentWidth=timeline.size.contentWidth,left=timeline.timeToScreen(this.start),right=timeline.timeToScreen(this.end);left<-contentWidth&&(left=-contentWidth),right>2*contentWidth&&(right=2*contentWidth),dom.style.top=this.top+"px",dom.style.left=left+"px",dom.style.width=Math.max(right-left,1)+"px"}},links.Timeline.ItemRange.prototype.isVisible=function(start,end){return!this.cluster&&(this.end>start&&this.start<end)},links.Timeline.ItemRange.prototype.setPosition=function(left,right){var dom=this.dom;dom.style.left=left+"px",dom.style.width=right-left+"px",this.group&&(this.top=this.group.top,dom.style.top=this.top+"px")},links.Timeline.ItemRange.prototype.getRight=function(timeline){return timeline.timeToScreen(this.end)},links.Timeline.ItemRange.prototype.getWidth=function(timeline){return timeline.timeToScreen(this.end)-timeline.timeToScreen(this.start)},links.Timeline.ItemDot=function(data,options){links.Timeline.Item.call(this,data,options)},links.Timeline.ItemDot.prototype=new links.Timeline.Item,links.Timeline.ItemDot.prototype.reflow=function(){var dom=this.dom,dotHeight=dom.dot.offsetHeight,dotWidth=dom.dot.offsetWidth,contentHeight=dom.content.offsetHeight,resized=this.dotHeight!=dotHeight||this.dotWidth!=dotWidth||this.contentHeight!=contentHeight;return this.dotHeight=dotHeight,this.dotWidth=dotWidth,this.contentHeight=contentHeight,resized},links.Timeline.ItemDot.prototype.select=function(){var dom=this.dom;links.Timeline.addClassName(dom,"timeline-event-selected")},links.Timeline.ItemDot.prototype.unselect=function(){var dom=this.dom;links.Timeline.removeClassName(dom,"timeline-event-selected")},links.Timeline.ItemDot.prototype.createDOM=function(){var divBox=document.createElement("DIV");divBox.style.position="absolute";var divContent=document.createElement("DIV");divContent.className="timeline-event-content",divBox.appendChild(divContent);var divDot=document.createElement("DIV");return divDot.style.position="absolute",divDot.style.width="0px",divDot.style.height="0px",divBox.appendChild(divDot),divBox.content=divContent,divBox.dot=divDot,this.dom=divBox,this.updateDOM(),divBox},links.Timeline.ItemDot.prototype.showDOM=function(container){var dom=this.dom;dom||(dom=this.createDOM()),dom.parentNode!=container&&(dom.parentNode&&this.hideDOM(),container.appendChild(dom),this.rendered=!0)},links.Timeline.ItemDot.prototype.hideDOM=function(){var dom=this.dom;dom&&(dom.parentNode&&dom.parentNode.removeChild(dom),this.rendered=!1)},links.Timeline.ItemDot.prototype.updateDOM=function(){if(this.dom){var divBox=this.dom,divDot=divBox.dot;divBox.firstChild.innerHTML=this.content,divDot.className="timeline-event timeline-event-dot",this.isCluster&&(links.Timeline.addClassName(divBox,"timeline-event-cluster"),links.Timeline.addClassName(divDot,"timeline-event-cluster")),this.className&&(links.Timeline.addClassName(divBox,this.className),links.Timeline.addClassName(divDot,this.className))}},links.Timeline.ItemDot.prototype.updatePosition=function(timeline){var dom=this.dom;if(dom){var left=timeline.timeToScreen(this.start);dom.style.top=this.top+"px",dom.style.left=left-this.dotWidth/2+"px",dom.content.style.marginLeft=1.5*this.dotWidth+"px",dom.dot.style.top=(this.height-this.dotHeight)/2+"px"}},links.Timeline.ItemDot.prototype.isVisible=function(start,end){return!this.cluster&&(this.start>start&&this.start<end)},links.Timeline.ItemDot.prototype.setPosition=function(left,right){var dom=this.dom;dom.style.left=left-this.dotWidth/2+"px",this.group&&(this.top=this.group.top,dom.style.top=this.top+"px")},links.Timeline.ItemDot.prototype.getRight=function(timeline){return timeline.timeToScreen(this.start)+this.width},links.Timeline.prototype.getItem=function(index){if(index>=this.items.length)throw"Cannot get item, index out of range";var item=this.items[index],properties={};return properties.start=new Date(item.start.valueOf()),item.end&&(properties.end=new Date(item.end.valueOf())),properties.content=item.content,item.group&&(properties.group=this.getGroupName(item.group)),"className"in item&&(properties.className=this.getGroupName(item.className)),item.hasOwnProperty("editable")&&void 0!==item.editable&&(properties.editable=item.editable),properties},links.Timeline.prototype.addItem=function(itemData,preventRender){var itemsData=[itemData];this.addItems(itemsData,preventRender)},links.Timeline.prototype.addItems=function(itemsData,preventRender){var timeline=this,items=this.items;AJS.$.each(itemsData,function(itemDataIdx,itemData){var index=items.length;items.push(timeline.createItem(itemData)),timeline.updateData(index,itemData)}),this.options.cluster&&this.clusterGenerator.updateData(),preventRender||this.render({animate:!1})},links.Timeline.prototype.createItem=function(itemData){var initialTop,type=itemData.end?"range":this.options.style,data={start:itemData.start,end:itemData.end,content:itemData.content,className:itemData.className,editable:itemData.editable,group:this.getGroup(itemData.group)},options=this.options;return initialTop=options.axisOnTop?this.size.axis.height+options.eventMarginAxis+options.eventMargin/2:this.size.contentHeight-options.eventMarginAxis-options.eventMargin/2,type in this.itemTypes?new this.itemTypes[type](data,{top:initialTop}):(console.log('ERROR: Unknown event style "'+type+'"'),new links.Timeline.Item(data,{top:initialTop}))},links.Timeline.prototype.changeItem=function(index,itemData,preventRender){var oldItem=this.items[index];if(!oldItem)throw"Cannot change item, index out of range";var newItem=this.createItem({start:itemData.hasOwnProperty("start")?itemData.start:oldItem.start,end:itemData.hasOwnProperty("end")?itemData.end:oldItem.end,content:itemData.hasOwnProperty("content")?itemData.content:oldItem.content,group:itemData.hasOwnProperty("group")?itemData.group:this.getGroupName(oldItem.group),className:itemData.hasOwnProperty("className")?itemData.className:oldItem.className,editable:itemData.hasOwnProperty("editable")?itemData.editable:oldItem.editable});this.items[index]=newItem,this.renderQueue.hide.push(oldItem),this.renderQueue.show.push(newItem),this.updateData(index,itemData),this.options.cluster&&this.clusterGenerator.updateData(),preventRender||(this.render({animate:!1}),newItem.select())},links.Timeline.prototype.deleteGroups=function(){this.groups=[],this.groupIndexes={}},links.Timeline.prototype.getGroup=function(groupName){var groups=this.groups,groupIndexes=this.groupIndexes,groupObj=void 0,groupIndex=groupIndexes[groupName];if(null==groupIndex&&null!=groupName){groupObj={content:groupName,labelTop:0,lineTop:0},groups.push(groupObj);for(var i=0,iMax=(groups=groups.sort(function(a,b){return a.content>b.content?1:a.content<b.content?-1:0})).length;i<iMax;i++)groupIndexes[groups[i].content]=i}else groupObj=groups[groupIndex];return groupObj},links.Timeline.prototype.getGroupName=function(groupObj){return groupObj?groupObj.content:void 0},links.Timeline.prototype.cancelChange=function(){this.applyChange=!1},links.Timeline.prototype.cancelDelete=function(){this.applyDelete=!1},links.Timeline.prototype.cancelAdd=function(){this.applyAdd=!1},links.Timeline.prototype.setSelection=function(selection,disableVisibleChartRangeUpdate){if(null!=selection&&selection.length>0){if(null!=selection[0].row){var index=selection[0].row;if(this.items[index]){var item=this.items[index];this.selectItem(index);var middle,start=item.start,end=item.end;middle=null!=end?(end.valueOf()+start.valueOf())/2:start.valueOf();var diff=this.end.valueOf()-this.start.valueOf(),newStart=new Date(middle-diff/2),newEnd=new Date(middle+diff/2);return disableVisibleChartRangeUpdate||this.setVisibleChartRange(newStart,newEnd),!0}}}else this.unselectItem();return!1},links.Timeline.prototype.getSelection=function(){var sel=[];return this.selection&&sel.push({row:this.selection.index}),sel},links.Timeline.prototype.selectItem=function(index){if(this.unselectItem(),this.selection=void 0,null!=this.items[index]){var item=this.items[index];item.dom;this.selection={index:index},item&&item.dom&&(this.isEditable(item)&&(item.dom.style.cursor="move"),item.select()),this.repaintDeleteButton(),this.repaintDragAreas()}},links.Timeline.prototype.isSelected=function(index){return this.selection&&this.selection.index==index},links.Timeline.prototype.unselectItem=function(){if(this.selection){var item=this.items[this.selection.index];if(item&&item.dom)item.dom.style.cursor="",item.unselect();this.selection=void 0,this.repaintDeleteButton(),this.repaintDragAreas()}},links.Timeline.prototype.stackItems=function(animate){if(!(this.groups.length>0)){null==animate&&(animate=!1);var stack=this.stack;if(stack||(stack={},this.stack=stack),stack.sortedItems=this.stackOrder(this.renderedItems),stack.finalItems=this.stackCalculateFinal(stack.sortedItems),animate||stack.timer){var timeline=this,step=function(){var arrived=timeline.stackMoveOneStep(stack.sortedItems,stack.finalItems);timeline.repaint(),arrived?delete stack.timer:stack.timer=setTimeout(step,30)};stack.timer||(stack.timer=setTimeout(step,30))}else this.stackMoveToFinal(stack.sortedItems,stack.finalItems)}},links.Timeline.prototype.stackCancelAnimation=function(){this.stack&&this.stack.timer&&(clearTimeout(this.stack.timer),delete this.stack.timer)},links.Timeline.prototype.stackOrder=function(items){var sortedItems=items.concat([]),f=this.options.customStackOrder&&"function"==typeof this.options.customStackOrder?this.options.customStackOrder:function(a,b){return a instanceof links.Timeline.ItemRange&&!(b instanceof links.Timeline.ItemRange)?-1:!(a instanceof links.Timeline.ItemRange)&&b instanceof links.Timeline.ItemRange?1:(result=a.start-b.start,result||(result=b.width-a.width),result||(result=b.bottom-a.bottom),result)};return sortedItems.sort(f),sortedItems},links.Timeline.prototype.stackCalculateFinal=function(items){var i,iMax,size=this.size,axisTop=size.axis.top,axisHeight=size.axis.height,options=this.options,axisOnTop=options.axisOnTop,eventMargin=options.eventMargin,eventMarginAxis=options.eventMarginAxis,finalItems=[];for(i=0,iMax=items.length;i<iMax;i++){var top,bottom,item=items[i],height=item.height,width=item.getWidth(this),right=item.getRight(this),left=right-width;bottom=(top=axisOnTop?axisHeight+eventMarginAxis+eventMargin/2:axisTop-height-eventMarginAxis-eventMargin/2)+height,finalItems[i]={left:left,top:top,right:right,bottom:bottom,height:height,item:item}}if(this.options.stackEvents)for(i=0,iMax=finalItems.length;i<iMax;i++){var finalItem=finalItems[i],collidingItem=null;do{null!=(collidingItem=this.stackItemsCheckOverlap(finalItems,i,0,i-1))&&(finalItem.top=axisOnTop?collidingItem.top+collidingItem.height+eventMargin:collidingItem.top-finalItem.height-eventMargin,finalItem.bottom=finalItem.top+finalItem.height)}while(collidingItem)}return finalItems},links.Timeline.prototype.stackMoveOneStep=function(currentItems,finalItems){var arrived=!0;for(i=0,iMax=finalItems.length;i<iMax;i++){var finalItem=finalItems[i],item=finalItem.item,topNow=parseInt(item.top),topFinal=parseInt(finalItem.top),diff=topFinal-topNow;if(diff){var step=topFinal==topNow?0:topFinal>topNow?1:-1;Math.abs(diff)>4&&(step=diff/4);var topNew=parseInt(topNow+step);topNew!=topFinal&&(arrived=!1),item.top=topNew,item.bottom=item.top+item.height}else item.top=finalItem.top,item.bottom=finalItem.bottom;item.left=finalItem.left,item.right=finalItem.right}return arrived},links.Timeline.prototype.stackMoveToFinal=function(currentItems,finalItems){for(i=0,iMax=finalItems.length;i<iMax;i++){var finalItem=finalItems[i],current=finalItem.item;current.left=finalItem.left,current.top=finalItem.top,current.right=finalItem.right,current.bottom=finalItem.bottom}},links.Timeline.prototype.stackItemsCheckOverlap=function(items,itemIndex,itemStart,itemEnd){for(var eventMargin=this.options.eventMargin,collision=this.collision,item1=items[itemIndex],i=itemEnd;i>=itemStart;i--){var item2=items[i];if(collision(item1,item2,eventMargin)&&i!=itemIndex)return item2}},links.Timeline.prototype.collision=function(item1,item2,margin){return null==margin&&(margin=0),item1.left-margin<item2.right&&item1.right+margin>item2.left&&item1.top-margin<item2.bottom&&item1.bottom+margin>item2.top},links.Timeline.prototype.trigger=function(event){var mouseX,properties=null;switch(event){case"rangechange":case"rangechanged":properties={start:new Date(this.start.valueOf()),end:new Date(this.end.valueOf())};break;case"timechange":case"timechanged":properties={time:new Date(this.customTime.valueOf())};break;case"add":mouseX=this.eventParams.mouseX-links.Timeline.getAbsoluteLeft(this.dom.content),properties={start:this.screenToTime(mouseX)}}links.events.trigger(this,event,properties),google&&google.visualization&&google.visualization.events.trigger(this,event,properties)},links.Timeline.prototype.clusterItems=function(){if(this.options.cluster){var clusters=this.clusterGenerator.getClusters(this.conversion.factor);if(this.clusters!=clusters){var queue=this.renderQueue;this.clusters&&AJS.$.each(this.clusters,function(clusterIdx,cluster){queue.hide.push(cluster),AJS.$.each(cluster.items,function(itemIdx,item){item.cluster=void 0})}),AJS.$.each(clusters,function(clusterIdx,cluster){AJS.$.each(cluster.items,function(itemIdx,item){item.cluster=cluster})}),this.clusters=clusters}}},links.Timeline.prototype.filterItems=function(){var queue=this.renderQueue,window=this.end-this.start,start=new Date(this.start.valueOf()-window),end=new Date(this.end.valueOf()+window);function filter(arr){AJS.$.each(arr,function(itemIdx,item){var rendered=item.rendered,visible=item.isVisible(start,end);rendered!=visible&&(rendered&&queue.hide.push(item),visible&&-1==AJS.$.inArray(item,queue.show)&&queue.show.push(item))})}filter(this.items),this.clusters&&filter(this.clusters)},links.Timeline.ClusterGenerator=function(timeline){this.timeline=timeline,this.clear()},links.Timeline.ClusterGenerator.prototype.clear=function(){this.items=[],this.groups={},this.clearCache()},links.Timeline.ClusterGenerator.prototype.clearCache=function(){this.cache={},this.cacheLevel=-1,this.cache[this.cacheLevel]=[]},links.Timeline.ClusterGenerator.prototype.setData=function(items,options){this.items=items||[],this.dataChanged=!0,this.applyOnChangedLevel=!0,options&&options.applyOnChangedLevel&&(this.applyOnChangedLevel=options.applyOnChangedLevel)},links.Timeline.ClusterGenerator.prototype.updateData=function(){this.dataChanged=!0,this.applyOnChangedLevel=!1},links.Timeline.ClusterGenerator.prototype.filterData=function(){var items=this.items||[],groups={};for(var groupName in this.groups=groups,AJS.$.each(items,function(itemIdx,item){var groupName=item.group?item.group.content:"",group=groups[groupName];group||(group=[],groups[groupName]=group),group.push(item),item.start&&(item.end?item.center=(item.start.valueOf()+item.end.valueOf())/2:item.center=item.start.valueOf())}),groups)groups.hasOwnProperty(groupName)&&groups[groupName].sort(function(a,b){return a.center-b.center});this.dataChanged=!1},links.Timeline.ClusterGenerator.prototype.getClusters=function(scale){var level=-1,timeWindow=0;if(scale>0&&(level=Math.round(Math.log(100/scale)/Math.log(2)),timeWindow=Math.pow(2,level),this.timeline.groups&&this.timeline.groups.length&&(timeWindow*=4)),this.dataChanged){var levelChanged=level!=this.cacheLevel;(!this.applyOnChangedLevel||levelChanged)&&(this.clearCache(),this.filterData())}this.cacheLevel=level;var clusters=this.cache[level];if(!clusters){for(var groupName in clusters=[],this.groups)if(this.groups.hasOwnProperty(groupName))for(var items=this.groups[groupName],iMax=items.length,i=0;i<iMax;){for(var item=items[i],neighbors=1,j=i-1;j>=0&&item.center-items[j].center<timeWindow/2;)items[j].cluster||neighbors++,j--;for(var k=i+1;k<items.length&&items[k].center-item.center<timeWindow/2;)neighbors++,k++;for(var l=clusters.length-1;l>=0&&item.center-clusters[l].center<timeWindow/2;)item.group==clusters[l].group&&neighbors++,l--;if(neighbors>5){for(var cluster,num=neighbors-5+1,clusterItems=[],avg=void 0,min=void 0,max=void 0,containsRanges=!1,count=0,m=i;clusterItems.length<num&&m<items.length;){var p=items[m],start=p.start.valueOf(),end=p.end?p.end.valueOf():p.start.valueOf();clusterItems.push(p),avg=count?count/(count+1)*avg+1/(count+1)*p.center:p.center,min=null!=min?Math.min(min,start):start,max=null!=max?Math.max(max,end):end,containsRanges=containsRanges||p instanceof links.Timeline.ItemRange,count++,m++}var content='<div title="'+("Cluster containing "+count+" events. Zoom in to see the individual events.")+'">'+count+" events</div>",group=item.group?item.group.content:void 0;(cluster=containsRanges?this.timeline.createItem({start:new Date(min),end:new Date(max),content:content,group:group}):this.timeline.createItem({start:new Date(avg),content:content,group:group})).isCluster=!0,cluster.items=clusterItems,AJS.$.each(cluster.items,function(itemIdx,item){item.cluster=cluster}),clusters.push(cluster),i+=num}else delete item.cluster,i+=1}this.cache[level]=clusters}return clusters},links.events=links.events||{listeners:[],indexOf:function(object){for(var listeners=this.listeners,i=0,iMax=this.listeners.length;i<iMax;i++){var listener=listeners[i];if(listener&&listener.object==object)return i}return-1},addListener:function(object,event,callback){var index=this.indexOf(object),listener=this.listeners[index];listener||(listener={object:object,events:{}},this.listeners.push(listener));var callbacks=listener.events[event];callbacks||(callbacks=[],listener.events[event]=callbacks),-1==AJS.$.inArray(callback,callbacks)&&callbacks.push(callback)},removeListener:function(object,event,callback){var index=this.indexOf(object),listener=this.listeners[index];if(listener){var callbacks=listener.events[event];if(callbacks)-1!=(index=AJS.$.inArray(callback,callbacks))&&callbacks.splice(index,1),0==callbacks.length&&delete listener.events[event];var count=0,events=listener.events;for(var e in events)events.hasOwnProperty(e)&&count++;0==count&&delete this.listeners[index]}},removeAllListeners:function(){this.listeners=[]},trigger:function(object,event,properties){var index=this.indexOf(object),listener=this.listeners[index];if(listener){var callbacks=listener.events[event];if(callbacks)for(var i=0,iMax=callbacks.length;i<iMax;i++)callbacks[i](properties)}}},links.Timeline.StepDate=function(start,end,minimumStep){this.current=new Date,this._start=new Date,this._end=new Date,this.autoScale=!0,this.scale=links.Timeline.StepDate.SCALE.DAY,this.step=1,this.setRange(start,end,minimumStep)},links.Timeline.StepDate.SCALE={MILLISECOND:1,SECOND:2,MINUTE:3,HOUR:4,DAY:5,WEEKDAY:6,MONTH:7,YEAR:8},links.Timeline.StepDate.prototype.setRange=function(start,end,minimumStep){start instanceof Date&&end instanceof Date&&(this._start=null!=start?new Date(start.valueOf()):new Date,this._end=null!=end?new Date(end.valueOf()):new Date,this.autoScale&&this.setMinimumStep(minimumStep))},links.Timeline.StepDate.prototype.start=function(){this.current=new Date(this._start.valueOf()),this.roundToMinor()},links.Timeline.StepDate.prototype.roundToMinor=function(){switch(this.scale){case links.Timeline.StepDate.SCALE.YEAR:this.current.setFullYear(this.step*Math.floor(this.current.getFullYear()/this.step)),this.current.setMonth(0);case links.Timeline.StepDate.SCALE.MONTH:this.current.setDate(1);case links.Timeline.StepDate.SCALE.DAY:case links.Timeline.StepDate.SCALE.WEEKDAY:this.current.setHours(0);case links.Timeline.StepDate.SCALE.HOUR:this.current.setMinutes(0);case links.Timeline.StepDate.SCALE.MINUTE:this.current.setSeconds(0);case links.Timeline.StepDate.SCALE.SECOND:this.current.setMilliseconds(0)}if(1!=this.step)switch(this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:this.current.setMilliseconds(this.current.getMilliseconds()-this.current.getMilliseconds()%this.step);break;case links.Timeline.StepDate.SCALE.SECOND:this.current.setSeconds(this.current.getSeconds()-this.current.getSeconds()%this.step);break;case links.Timeline.StepDate.SCALE.MINUTE:this.current.setMinutes(this.current.getMinutes()-this.current.getMinutes()%this.step);break;case links.Timeline.StepDate.SCALE.HOUR:this.current.setHours(this.current.getHours()-this.current.getHours()%this.step);break;case links.Timeline.StepDate.SCALE.WEEKDAY:case links.Timeline.StepDate.SCALE.DAY:this.current.setDate(this.current.getDate()-1-(this.current.getDate()-1)%this.step+1);break;case links.Timeline.StepDate.SCALE.MONTH:this.current.setMonth(this.current.getMonth()-this.current.getMonth()%this.step);break;case links.Timeline.StepDate.SCALE.YEAR:this.current.setFullYear(this.current.getFullYear()-this.current.getFullYear()%this.step)}},links.Timeline.StepDate.prototype.end=function(){return this.current.valueOf()>this._end.valueOf()},links.Timeline.StepDate.prototype.next=function(){var prev=this.current.valueOf();if(this.current.getMonth()<6)switch(this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:this.current=new Date(this.current.valueOf()+this.step);break;case links.Timeline.StepDate.SCALE.SECOND:this.current=new Date(this.current.valueOf()+1e3*this.step);break;case links.Timeline.StepDate.SCALE.MINUTE:this.current=new Date(this.current.valueOf()+1e3*this.step*60);break;case links.Timeline.StepDate.SCALE.HOUR:this.current=new Date(this.current.valueOf()+1e3*this.step*60*60);var h=this.current.getHours();this.current.setHours(h-h%this.step);break;case links.Timeline.StepDate.SCALE.WEEKDAY:case links.Timeline.StepDate.SCALE.DAY:this.current.setDate(this.current.getDate()+this.step);break;case links.Timeline.StepDate.SCALE.MONTH:this.current.setMonth(this.current.getMonth()+this.step);break;case links.Timeline.StepDate.SCALE.YEAR:this.current.setFullYear(this.current.getFullYear()+this.step)}else switch(this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:this.current=new Date(this.current.valueOf()+this.step);break;case links.Timeline.StepDate.SCALE.SECOND:this.current.setSeconds(this.current.getSeconds()+this.step);break;case links.Timeline.StepDate.SCALE.MINUTE:this.current.setMinutes(this.current.getMinutes()+this.step);break;case links.Timeline.StepDate.SCALE.HOUR:this.current.setHours(this.current.getHours()+this.step);break;case links.Timeline.StepDate.SCALE.WEEKDAY:case links.Timeline.StepDate.SCALE.DAY:this.current.setDate(this.current.getDate()+this.step);break;case links.Timeline.StepDate.SCALE.MONTH:this.current.setMonth(this.current.getMonth()+this.step);break;case links.Timeline.StepDate.SCALE.YEAR:this.current.setFullYear(this.current.getFullYear()+this.step)}if(1!=this.step)switch(this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:this.current.getMilliseconds()<this.step&&this.current.setMilliseconds(0);break;case links.Timeline.StepDate.SCALE.SECOND:this.current.getSeconds()<this.step&&this.current.setSeconds(0);break;case links.Timeline.StepDate.SCALE.MINUTE:this.current.getMinutes()<this.step&&this.current.setMinutes(0);break;case links.Timeline.StepDate.SCALE.HOUR:this.current.getHours()<this.step&&this.current.setHours(0);break;case links.Timeline.StepDate.SCALE.WEEKDAY:case links.Timeline.StepDate.SCALE.DAY:this.current.getDate()<this.step+1&&this.current.setDate(1);break;case links.Timeline.StepDate.SCALE.MONTH:this.current.getMonth()<this.step&&this.current.setMonth(0);case links.Timeline.StepDate.SCALE.YEAR:}this.current.valueOf()==prev&&(this.current=new Date(this._end.valueOf()))},links.Timeline.StepDate.prototype.getCurrent=function(){return this.current},links.Timeline.StepDate.prototype.setScale=function(newScale,newStep){this.scale=newScale,newStep>0&&(this.step=newStep),this.autoScale=!1},links.Timeline.StepDate.prototype.setAutoScale=function(enable){this.autoScale=enable},links.Timeline.StepDate.prototype.setMinimumStep=function(minimumStep){if(null!=minimumStep){31104e9>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=1e3),15552e9>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=500),31104e8>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=100),15552e8>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=50),31104e7>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=10),15552e7>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=5),31104e6>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=1),7776e6>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.MONTH,this.step=3),2592e6>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.MONTH,this.step=1),432e6>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.DAY,this.step=5),1728e5>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.DAY,this.step=2),864e5>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.DAY,this.step=1),432e5>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.WEEKDAY,this.step=1),144e5>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.HOUR,this.step=4),36e5>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.HOUR,this.step=1),9e5>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.MINUTE,this.step=15),6e5>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.MINUTE,this.step=10),3e5>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.MINUTE,this.step=5),6e4>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.MINUTE,this.step=1),15e3>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.SECOND,this.step=15),1e4>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.SECOND,this.step=10),5e3>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.SECOND,this.step=5),1e3>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.SECOND,this.step=1),200>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.MILLISECOND,this.step=200),100>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.MILLISECOND,this.step=100),50>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.MILLISECOND,this.step=50),10>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.MILLISECOND,this.step=10),5>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.MILLISECOND,this.step=5),1>minimumStep&&(this.scale=links.Timeline.StepDate.SCALE.MILLISECOND,this.step=1)}},links.Timeline.StepDate.prototype.snap=function(date){if(this.scale==links.Timeline.StepDate.SCALE.YEAR){var year=date.getFullYear()+Math.round(date.getMonth()/12);date.setFullYear(Math.round(year/this.step)*this.step),date.setMonth(0),date.setDate(0),date.setHours(0),date.setMinutes(0),date.setSeconds(0),date.setMilliseconds(0)}else if(this.scale==links.Timeline.StepDate.SCALE.MONTH)date.getDate()>15?(date.setDate(1),date.setMonth(date.getMonth()+1)):date.setDate(1),date.setHours(0),date.setMinutes(0),date.setSeconds(0),date.setMilliseconds(0);else if(this.scale==links.Timeline.StepDate.SCALE.DAY||this.scale==links.Timeline.StepDate.SCALE.WEEKDAY){switch(this.step){case 5:case 2:date.setHours(24*Math.round(date.getHours()/24));break;default:date.setHours(12*Math.round(date.getHours()/12))}date.setMinutes(0),date.setSeconds(0),date.setMilliseconds(0)}else if(this.scale==links.Timeline.StepDate.SCALE.HOUR){if(4===this.step)date.setMinutes(60*Math.round(date.getMinutes()/60));else date.setMinutes(30*Math.round(date.getMinutes()/30));date.setSeconds(0),date.setMilliseconds(0)}else if(this.scale==links.Timeline.StepDate.SCALE.MINUTE){switch(this.step){case 15:case 10:date.setMinutes(5*Math.round(date.getMinutes()/5)),date.setSeconds(0);break;case 5:date.setSeconds(60*Math.round(date.getSeconds()/60));break;default:date.setSeconds(30*Math.round(date.getSeconds()/30))}date.setMilliseconds(0)}else if(this.scale==links.Timeline.StepDate.SCALE.SECOND)switch(this.step){case 15:case 10:date.setSeconds(5*Math.round(date.getSeconds()/5)),date.setMilliseconds(0);break;case 5:date.setMilliseconds(1e3*Math.round(date.getMilliseconds()/1e3));break;default:date.setMilliseconds(500*Math.round(date.getMilliseconds()/500))}else if(this.scale==links.Timeline.StepDate.SCALE.MILLISECOND){var step=this.step>5?this.step/2:1;date.setMilliseconds(Math.round(date.getMilliseconds()/step)*step)}},links.Timeline.StepDate.prototype.isMajor=function(){switch(this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:return 0==this.current.getMilliseconds();case links.Timeline.StepDate.SCALE.SECOND:return 0==this.current.getSeconds();case links.Timeline.StepDate.SCALE.MINUTE:return 0==this.current.getHours()&&0==this.current.getMinutes();case links.Timeline.StepDate.SCALE.HOUR:return 0==this.current.getHours();case links.Timeline.StepDate.SCALE.WEEKDAY:case links.Timeline.StepDate.SCALE.DAY:return 1==this.current.getDate();case links.Timeline.StepDate.SCALE.MONTH:return 0==this.current.getMonth();case links.Timeline.StepDate.SCALE.YEAR:default:return!1}},links.Timeline.StepDate.prototype.getLabelMinor=function(options,date){switch(null==date&&(date=this.current),this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:return String(date.getMilliseconds());case links.Timeline.StepDate.SCALE.SECOND:return String(date.getSeconds());case links.Timeline.StepDate.SCALE.MINUTE:case links.Timeline.StepDate.SCALE.HOUR:return this.addZeros(date.getHours(),2)+":"+this.addZeros(date.getMinutes(),2);case links.Timeline.StepDate.SCALE.WEEKDAY:return options.DAYS_SHORT[date.getDay()]+" "+date.getDate();case links.Timeline.StepDate.SCALE.DAY:return String(date.getDate());case links.Timeline.StepDate.SCALE.MONTH:return options.MONTHS_SHORT[date.getMonth()];case links.Timeline.StepDate.SCALE.YEAR:return String(date.getFullYear());default:return""}},links.Timeline.StepDate.prototype.getLabelMajor=function(options,date){switch(null==date&&(date=this.current),this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:return this.addZeros(date.getHours(),2)+":"+this.addZeros(date.getMinutes(),2)+":"+this.addZeros(date.getSeconds(),2);case links.Timeline.StepDate.SCALE.SECOND:return date.getDate()+" "+options.MONTHS[date.getMonth()]+" "+this.addZeros(date.getHours(),2)+":"+this.addZeros(date.getMinutes(),2);case links.Timeline.StepDate.SCALE.MINUTE:case links.Timeline.StepDate.SCALE.HOUR:return options.DAYS[date.getDay()]+" "+date.getDate()+" "+options.MONTHS[date.getMonth()]+" "+date.getFullYear();case links.Timeline.StepDate.SCALE.WEEKDAY:case links.Timeline.StepDate.SCALE.DAY:return options.MONTHS[date.getMonth()]+" "+date.getFullYear();case links.Timeline.StepDate.SCALE.MONTH:return String(date.getFullYear());default:return""}},links.Timeline.StepDate.prototype.addZeros=function(value,len){for(var str=""+value;str.length<len;)str="0"+str;return str},links.imageloader=function(){var urls={},callbacks={};function isLoaded(url){if(1==urls[url])return!0;var image=new Image;return image.src=url,!!image.complete}function isLoading(url){return null!=callbacks[url]}function load(url,callback,sendCallbackWhenAlreadyLoaded){if(null==sendCallbackWhenAlreadyLoaded&&(sendCallbackWhenAlreadyLoaded=!0),isLoaded(url))sendCallbackWhenAlreadyLoaded&&callback(url);else if(!isLoading(url)||sendCallbackWhenAlreadyLoaded){var c=callbacks[url];if(!c){var image=new Image;image.src=url,c=[],callbacks[url]=c,image.onload=function(event){urls[url]=!0,delete callbacks[url];for(var i=0;i<c.length;i++)c[i](url)}}-1==AJS.$.inArray(callback,c)&&c.push(callback)}}return{isLoaded:isLoaded,isLoading:isLoading,load:load,loadAll:function(urls,callback,sendCallbackWhenAlreadyLoaded){var urlsLeft=[];if(AJS.$.each(urls,function(urlIdx,url){isLoaded(url)||urlsLeft.push(url)}),urlsLeft.length){var countLeft=urlsLeft.length;AJS.$.each(urlsLeft,function(urlIdx,url){load(url,function(){0==--countLeft&&callback()},sendCallbackWhenAlreadyLoaded)})}else sendCallbackWhenAlreadyLoaded&&callback()},filterImageUrls:function filterImageUrls(elem,urls){for(var child=elem.firstChild;child;){if("IMG"==child.tagName){var url=child.src;-1==AJS.$.inArray(url,urls)&&urls.push(url)}filterImageUrls(child,urls),child=child.nextSibling}}}}(),links.Timeline.addEventListener=function(element,action,listener,useCapture){element.addEventListener?(void 0===useCapture&&(useCapture=!1),"mousewheel"===action&&navigator.userAgent.indexOf("Firefox")>=0&&(action="DOMMouseScroll"),element.addEventListener(action,listener,useCapture)):element.attachEvent("on"+action,listener)},links.Timeline.removeEventListener=function(element,action,listener,useCapture){element.removeEventListener?(void 0===useCapture&&(useCapture=!1),"mousewheel"===action&&navigator.userAgent.indexOf("Firefox")>=0&&(action="DOMMouseScroll"),element.removeEventListener(action,listener,useCapture)):element.detachEvent("on"+action,listener)},links.Timeline.getTarget=function(event){var target;return event||(event=window.event),event.target?target=event.target:event.srcElement&&(target=event.srcElement),null!=target.nodeType&&3==target.nodeType&&(target=target.parentNode),target},links.Timeline.stopPropagation=function(event){event||(event=window.event),event.stopPropagation?event.stopPropagation():event.cancelBubble=!0},links.Timeline.preventDefault=function(event){event||(event=window.event),event.preventDefault?event.preventDefault():event.returnValue=!1},links.Timeline.getAbsoluteLeft=function(elem){for(var doc=document.documentElement,body=document.body,left=elem.offsetLeft,e=elem.offsetParent;null!=e&&e!=body&&e!=doc;)left+=e.offsetLeft,left-=e.scrollLeft,e=e.offsetParent;return left},links.Timeline.getAbsoluteTop=function(elem){for(var doc=document.documentElement,body=document.body,top=elem.offsetTop,e=elem.offsetParent;null!=e&&e!=body&&e!=doc;)top+=e.offsetTop,top-=e.scrollTop,e=e.offsetParent;return top},links.Timeline.getPageY=function(event){if("pageY"in event)return event.pageY;var clientY;clientY="targetTouches"in event&&event.targetTouches.length?event.targetTouches[0].clientY:event.clientY;var doc=document.documentElement,body=document.body;return clientY+(doc&&doc.scrollTop||body&&body.scrollTop||0)-(doc&&doc.clientTop||body&&body.clientTop||0)},links.Timeline.getPageX=function(event){if("pageY"in event)return event.pageX;var clientX;clientX="targetTouches"in event&&event.targetTouches.length?event.targetTouches[0].clientX:event.clientX;var doc=document.documentElement,body=document.body;return clientX+(doc&&doc.scrollLeft||body&&body.scrollLeft||0)-(doc&&doc.clientLeft||body&&body.clientLeft||0)},links.Timeline.addClassName=function(elem,className){var classes=elem.className.split(" ");-1==AJS.$.inArray(className,classes)&&(classes.push(className),elem.className=classes.join(" "))},links.Timeline.removeClassName=function(elem,className){var classes=elem.className.split(" "),index=AJS.$.inArray(className,classes);-1!=index&&(classes.splice(index,1),elem.className=classes.join(" "))},links.Timeline.isArray=function(obj){return obj instanceof Array||"[object Array]"===Object.prototype.toString.call(obj)},links.Timeline.parseJSONDate=function(date){if(null!=date){if(date instanceof Date)return date;var m=date.match(/\/Date\((-?\d+)([-\+]?\d{2})?(\d{2})?\)\//i);if(m){var offset=m[2]?36e5*m[2]+6e4*m[3]*(m[2]/Math.abs(m[2])):0;return new Date(1*m[1]+offset)}return Date.parse(date)}};