/**
 * This is a wrapper for methods to enable/disable element
 * Module confluence/form-state-control is only available from Confluence 7
 * Teamcal is a special plugin, we need to maintain backward compatibility, that's why we need this wrapper
 */
define("tc/form-state-control", [ "jquery", "ajs" ], function($, AJS) {
    var ConfluenceFormStateControl;
    try {
        ConfluenceFormStateControl = require('confluence/form-state-control');
    } catch (e) {
        AJS.log('[TEAMCAL] No module "confluence/form-state-control", falling back to default enable/disableElement');
    }
    
    function enableElement(element) {
        if (ConfluenceFormStateControl) {
            ConfluenceFormStateControl.enableElement(element);
        } else {
            $(element).enable();
        }
    }

    function disableElement(element) {
        if (ConfluenceFormStateControl) {
            ConfluenceFormStateControl.disableElement(element);
        } else {
            $(element).disable();
        }
    }

    return {
        enableElement: enableElement,
        disableElement: disableElement
    };
});
