define('confluence-search/analytics-search-filters', [
    'confluence/api/event'
], function(
    event
) {
    "use strict";

    function triggerAdvancedSearchStartedEvent(cqlComponentFields) {
        const {ancestor, contributor, created, creator, label, lastmodified, mention, parent, space, title, type} = cqlComponentFields;

        event.trigger('analyticsEvent', {
            name: 'confluence.search.advanced.started.filters',
            data: {
                ancestor: ancestor ? !!ancestor : undefined,
                // contributor is an input field, so check the CQL string
                contributor: contributor && contributor[0].asCql() ? !!(contributor && contributor[0].asCql()) : undefined,
                created: created ? _getDateTypeFromFilter(created[0].asCql(), created[0].fieldName) : 'anyDate',
                creator: creator ? !!creator : undefined,
                label: label ? !!label : undefined,
                lastmodified: lastmodified ? _getDateTypeFromFilter(lastmodified[0].asCql(), lastmodified[0].fieldName) : 'anyDate',
                mentioningUser: mention ? !!mention : undefined,
                parent: parent ? !!parent : undefined,
                // space is an input field, so check the CQL string
                space: space && space[0].asCql() ? !!(space && space[0].asCql()) : undefined,
                title: title ? !!title : undefined,
                contentType: type ? _getTypeFromCqlString(type[0].asCql()) : 'all'
            }
        });
    }

    const dateTypeMap = {
        ' >= now(\'-1d\')': 'last24Hours',
        ' >= now(\'-1w\')': 'lastWeek',
        ' >= now(\'-1M\')': 'lastMonth',
        ' >= now(\'-1y\')': 'lastYear'
    };

    function _getDateTypeFromFilter(date, fieldName) {
        if (!date) {
            return 'anyDate';
        }
        return dateTypeMap[date.replace(fieldName, '')] || 'custom';
    }

    const contentTypeMap = {
        'type = "page"': 'page',
        'type = "blogpost"': 'blogPost',
        'type = "attachment"': 'attachment',
        'type = "space"': 'space'
    };

    function _getTypeFromCqlString(type) {
        if (!type) {
            return 'all';
        }
        return contentTypeMap[type] || 'custom';
    }

    return {
        triggerAdvancedSearchStartedEvent: triggerAdvancedSearchStartedEvent
    };
});