define('confluence-page-banner/page-banner', [
    'ajs',
    'jquery',
    'confluence/templates',
    'confluence/legacy'
], function(
    AJS,
    $,
    Templates,
    Confluence
) {
    // This function will check whether all children in the system-content-items section are hidden and if so, hide the parent container.
    function updateSystemContentItems() {
        var $systemContentItems = $('#system-content-items');

        if ($systemContentItems.children(':not(.hidden)').length == 0) {
            $systemContentItems.addClass('hidden');
        } else {
            $systemContentItems.removeClass('hidden');
        }
    }

    function applyTooltips() {
        var bannerItemsSelector = '#system-content-items a:not(.tipsy-disabled),' +
            '.page-metadata-item a:not(.tipsy-disabled),' +
            '.page-metadata-modification-info a.last-modified:not(tipsy-disabled),' +
            '#draft-status-lozenge';
        applyTooltip(bannerItemsSelector);

        $(bannerItemsSelector).click(function(e) {
            hideTooltips($(e.target).closest('a'));
        });
        $(window).on('click scroll resize', hideTooltips)
    }

    function applyTooltip(selector) {
        // We construct a jQuery object using the selector to guarantee that the tooltip function can extract the object's selector.
        // This is required for the live param to work.
        $(document).tooltip({
            live: selector, // Dynamically added links are handled automatically
            gravity: 'n',
            title: function() {return $(this).attr('data-tooltip') || ''}
        });
    }

    function hideTooltips(tooltipTrigger) {
        if (tooltipTrigger) {
            $(tooltipTrigger).tooltip('hide');
        }
    }

    var toggledRestrictions = function(event, data) {
        var restrictionsIconSelector = "#content-metadata-page-restrictions";
        var $restrictionsIcon = $(restrictionsIconSelector);
        var labelName = '';

        // Remove only the necessary css classes
        $restrictionsIcon.removeClass('aui-iconfont-locked aui-iconfont-unlocked restricted');

        // We only use this value if the new values are not being passed in,
        //  this allows us to support older versions of Confluence.
        var oldHasRestrictions = data.hasRestrictions && !(data.hasExplicitRestrictions || data.hasInheritedRestrictions);

        if (data.hasExplicitRestrictions || oldHasRestrictions) {
            $restrictionsIcon.addClass('aui-icon aui-icon-small aui-iconfont-locked restricted');
            labelName = AJS.I18n.getText("page.restrictions.apply");
        } else if (data.hasInheritedRestrictions) {
            $restrictionsIcon.addClass('aui-icon aui-icon-small aui-iconfont-unlocked restricted');
            labelName = AJS.I18n.getText("page.restrictions.apply");
        } else {
            $restrictionsIcon.addClass('aui-icon aui-icon-small aui-iconfont-unlocked');
            labelName = data.hasAnyExplicitRestrictions ?
                AJS.I18n.getText("page.restrictions.apply") : AJS.I18n.getText("page.restrictions.none");
        }

        $restrictionsIcon.attr('data-tooltip', labelName);
        applyTooltip(restrictionsIconSelector);

        updateSystemContentItems();
    };

    var setup = function() {
        updateSystemContentItems();

        AJS.bind("system-content-metadata.toggled-restrictions", toggledRestrictions);

        $('#page-metadata-banner').css('visibility', 'visible');
        applyTooltips();
    };

    var teardown = function() {
        AJS.unbind("system-content-metadata.toggled-restrictions", toggledRestrictions);
    };

    var init = function() {
        // JQuery hooks onto `system-metadata-restrictions` class on webitem
        $(function() {
            setup();
            $('.system-metadata-restrictions')
                .on("remove", teardown)
                .click(function(ev) {
                    ev.preventDefault();
                    AJS.trigger('system-content-metadata.open-restrictions-dialog');
                });
        })
    };

    init();
});

require('confluence/module-exporter').safeRequire('confluence-page-banner/page-banner');
