AJS.toInit(function($) {
    const protocolsToPorts = {
        pop3: 110,
        pop3s: 995,
        imap: 143,
        imaps: 993
    };

    $('select[name=\'protocol\']').change(function() {
        let protocol = $(this).val();
        if (!protocolsToPorts.hasOwnProperty(protocol)) {
            window.alert('Protocol: ' + protocol + ' is not a supported protocol.');
        } else {
            $('#port').val(protocolsToPorts[protocol]);
        }
    });

    $("#authentication").on('change', function(e) {
        e.preventDefault();
        let isBasicAuth = $(this).val() === 'BasicAuthentication';
        $('#password').parent().css('display', isBasicAuth ? 'inline-block' : 'none');
        $("#password").val('');
        $('#confirm').prop('disabled', (!isBasicAuth && $("#token").val() === '') ? true : false);
    });

    if($("#token").val() !== '') {
        $('#password').parent().css('display', 'none');
        $('#confirm').prop('disabled', false);
    }
});