(function (exports) {
    'use strict';

    const reportMarshallers = [];
    const urlCleaners = [];
    let EventQueue;
    const addUrlCleaner = (cleaner) => {
        urlCleaners.push(cleaner);
    };
    const cleanUrl = (url) => {
        return urlCleaners.reduce((longestCleanedUrl, cleaner) => {
            const cleanedUrl = cleaner(url);
            return cleanedUrl.length > longestCleanedUrl.length
                ? cleanedUrl
                : longestCleanedUrl;
        }, "");
    };
    const addReportMarshaller = (marshaller) => {
        reportMarshallers.push(marshaller);
    };
    const setEventQueue = (eventQueue) => {
        EventQueue = eventQueue;
    };
    const beacon = (report) => {
        const properties = {};
        reportMarshallers.forEach(marshaller => {
            const partialProperties = marshaller(report);
            if (typeof partialProperties === "object") {
                Object.assign(properties, partialProperties);
            }
        });
        const event = {
            name: "browser.metrics.navigation",
            properties,
        };
        (EventQueue || AJS.EventQueue).push(event);
        console.debug("[BM-AA] ", "AJS Event pushed", event);
    };
    if (window.define) {
        window.define("internal/browser-metrics-aa-beacon", function () {
            return {
                beacon,
                setEventQueue,
                addReportMarshaller,
                cleanUrl,
                addUrlCleaner,
            };
        });
    }

    exports.addReportMarshaller = addReportMarshaller;
    exports.addUrlCleaner = addUrlCleaner;
    exports.beacon = beacon;
    exports.cleanUrl = cleanUrl;
    exports.setEventQueue = setEventQueue;

    Object.defineProperty(exports, '__esModule', { value: true });

})(this["browser-metrics-aa-beacon"] = this["browser-metrics-aa-beacon"] || {});
