(function (dcBrowserMetrics, dcBrowserMetricsAtlassianAnalyticsBeacon) {
    'use strict';

    let w = window;

    var $;
    try {
        $ = w.require("jquery");
    }
    catch (e) {
        $ = w.jQuery;
    }
    var $$1 = $;

    const experimentJavaScriptCloudFrontUrlPattern = /^(?:https?:)?\/\/[^\.]+\.cloudfront\.net\/p\/([^\/]+)\/main\.js$/;
    const experimentJavaScriptAesUrlPattern = /^(?:https?:)?\/\/aes-artifacts--cdn\.[^\.]+\.atlassian\.io\/hashed\/([^\/]+)\/.+\.js$/;
    function scripts() {
        return Array.prototype.slice.call(w.document.getElementsByTagName("script") || []);
    }
    function experiments() {
        let deferred = $$1.Deferred();
        $$1(function determineExperimentEnrolment() {
            let runningExperiments = [];
            scripts().forEach(script => {
                let src = script.getAttribute("src");
                let matches = src &&
                    (src.match(experimentJavaScriptAesUrlPattern) ||
                        src.match(experimentJavaScriptCloudFrontUrlPattern));
                if (matches && matches.length > 1) {
                    let experimentHash = matches[1];
                    runningExperiments.push({
                        name: experimentHash,
                        async: script.async,
                    });
                }
            });
            deferred.resolve(runningExperiments);
        });
        return deferred.promise();
    }
    const pendingReport = experiments().then((experiments) => {
        return { experiments: experiments };
    });
    let reporter = function experimentsReporter() {
        return pendingReport;
    };

    function isExperimentsReport(report) {
        return Array.isArray(report["experiments"]);
    }
    const experimentsMarshaller = report => {
        if (isExperimentsReport(report)) {
            return {
                experiments: JSON.stringify(report.experiments.map((experiment) => [
                    experiment.name,
                    experiment.async ? 1 : 0,
                ])),
            };
        }
    };

    const dictionary = [
        "android",
        "applewebkit",
        "baiduspider",
        "bingbot",
        "build",
        "chrome",
        "compatible",
        "edge",
        "electron",
        "explorer",
        "firefox",
        "gecko",
        "googlebot",
        "iemobile",
        "intel",
        "ipad",
        "iphone",
        "khtml",
        "konqueror",
        "like",
        "linux",
        "mac",
        "macintosh",
        "maxthon",
        "microsoft",
        "mini",
        "mobi",
        "mobile",
        "mozilla",
        "msie",
        "mwendo",
        "nt",
        "opera",
        "opr",
        "os",
        "phone",
        "playstation",
        "presto",
        "rv",
        "safari",
        "samsung",
        "thunderbird",
        "trident",
        "ubuntu",
        "ucbrowser",
        "unix",
        "version",
        "vivo",
        "win",
        "win64",
        "windows",
        "wow64",
        "x",
        "x11",
        "x64",
        "x86",
        "x86_64",
        "xbox",
    ];
    function isNumberLike(word) {
        return !!word.match(/^[0-9.,_%\-]+$/);
    }
    function sanitiseWord(word) {
        const testWord = word.toLowerCase().replace(/[;,()+]/g, "");
        if (isNumberLike(testWord) || dictionary.indexOf(testWord) !== -1) {
            return word;
        }
        return "";
    }
    function filter(userAgent) {
        const splitPattern = /[\s\/:]/g;
        const splitChars = userAgent.match(splitPattern);
        if (splitChars === null) {
            return sanitiseWord(userAgent);
        }
        return userAgent
            .split(splitPattern)
            .map(sanitiseWord)
            .reduce((prev, cur) => {
            return prev + splitChars.shift() + cur;
        });
    }
    const userAgentMarshaller = report => {
        if (report["userAgent"]) {
            return {
                userAgent: filter(report["userAgent"]),
            };
        }
    };

    let regex = /^(true|false|\d+)$/gi;
    let isPrivacyPolicySafeToken = (value) => {
        return !!value.match(regex);
    };

    let queryStringItemRegex = /([&?][^&=]+)(=?)([^&#]*)/g;
    let sanitiseQueryString = (url) => {
        return url.replace(queryStringItemRegex, (match, name, equals, value) => {
            return name + equals + (isPrivacyPolicySafeToken(value) ? value : "☠");
        });
    };

    let staticResourceItemRegex = /(\/s\/).+(\/_\/)/;
    let removeStaticResourceHash = (url) => {
        return url.replace(staticResourceItemRegex, (match, s, _) => {
            return s + "☠" + _;
        });
    };

    const cloudPerTenantUrlRegex = /^https:\/\/[^.]+\.cloudfront.net\/[^/]+(\/wiki)?\/s\//g;
    const cloudPerTenantCdnUrlFilter = url => {
        if (url.match(cloudPerTenantUrlRegex)) {
            url = sanitiseQueryString(url);
            url = removeStaticResourceHash(url);
            return url;
        }
        return "";
    };

    const cloudCrossTenantUrlRegex = /^https:\/\/d2kryfvs3op226\.cloudfront\.net\/[a-f0-9]+\.[a-z]+$/g;
    const cloudCrossTenantCdnUrlFilter = url => {
        if (url.match(cloudCrossTenantUrlRegex)) {
            return url;
        }
        return "";
    };

    const microsRegex = /^https:\/\/[^\/]+\.atl-paas.net\//g;
    const microsUrlFilter = (url) => url.match(microsRegex) ? url : "";

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation.

    Permission to use, copy, modify, and/or distribute this software for any
    purpose with or without fee is hereby granted.

    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
    PERFORMANCE OF THIS SOFTWARE.
    ***************************************************************************** */

    function __rest(s, e) {
        var t = {};
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
            t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    }

    function __awaiter(thisArg, _arguments, P, generator) {
        function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
            function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
            function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    }

    var r=function(e,t){return {name:e,value:void 0===t?-1:t,delta:0,entries:[],id:"v2-".concat(Date.now(),"-").concat(Math.floor(8999999999999*Math.random())+1e12)}},a=function(e,t){try{if(PerformanceObserver.supportedEntryTypes.includes(e)){if("first-input"===e&&!("PerformanceEventTiming"in self))return;var n=new PerformanceObserver((function(e){return e.getEntries().map(t)}));return n.observe({type:e,buffered:!0}),n}}catch(e){}},o=function(e,t){var n=function n(i){"pagehide"!==i.type&&"hidden"!==document.visibilityState||(e(i),t&&(removeEventListener("visibilitychange",n,!0),removeEventListener("pagehide",n,!0)));};addEventListener("visibilitychange",n,!0),addEventListener("pagehide",n,!0);},u=function(e){addEventListener("pageshow",(function(t){t.persisted&&e(t);}),!0);},c=function(e,t,n){var i;return function(r){t.value>=0&&(r||n)&&(t.delta=t.value-(i||0),(t.delta||void 0===i)&&(i=t.value,e(t)));}},f=-1,s=function(){return "hidden"===document.visibilityState?0:1/0},m=function(){o((function(e){var t=e.timeStamp;f=t;}),!0);},v=function(){return f<0&&(f=s(),m(),u((function(){setTimeout((function(){f=s(),m();}),0);}))),{get firstHiddenTime(){return f}}},d=function(e,t){var n,i=v(),o=r("FCP"),f=function(e){"first-contentful-paint"===e.name&&(m&&m.disconnect(),e.startTime<i.firstHiddenTime&&(o.value=e.startTime,o.entries.push(e),n(!0)));},s=window.performance&&performance.getEntriesByName&&performance.getEntriesByName("first-contentful-paint")[0],m=s?null:a("paint",f);(s||m)&&(n=c(e,o,t),s&&f(s),u((function(i){o=r("FCP"),n=c(e,o,t),requestAnimationFrame((function(){requestAnimationFrame((function(){o.value=performance.now()-i.timeStamp,n(!0);}));}));})));},P=function(e){var t,n=r("TTFB");t=function(){try{var t=performance.getEntriesByType("navigation")[0]||function(){var e=performance.timing,t={entryType:"navigation",startTime:0};for(var n in e)"navigationStart"!==n&&"toJSON"!==n&&(t[n]=Math.max(e[n]-e.navigationStart,0));return t}();if(n.value=n.delta=t.responseStart,n.value<0||n.value>performance.now())return;n.entries=[t],e(n);}catch(e){}},"complete"===document.readyState?setTimeout(t,0):addEventListener("load",(function(){return setTimeout(t,0)}));};

    const makeWebVitalsReporter = (key, callback, extract, ignoreWhen = () => false) => {
        let pending = null;
        return (transition) => {
            pending =
                pending ||
                    new Promise(resolve => {
                        callback(value => {
                            resolve(value);
                        });
                    });
            if (ignoreWhen(transition)) {
                return Promise.reject();
            }
            return pending.then(value => {
                return {
                    [key]: extract(value),
                };
            });
        };
    };

    function isEntryTypeSupported(entryType) {
        var _a;
        return (_a = PerformanceObserver === null || PerformanceObserver === void 0 ? void 0 : PerformanceObserver.supportedEntryTypes) === null || _a === void 0 ? void 0 : _a.includes(entryType);
    }
    function observePerformance(type, callback) {
        try {
            if (isEntryTypeSupported(type)) {
                const performanceObserver = new PerformanceObserver(entryList => entryList.getEntries().map(callback));
                performanceObserver.observe({ type, buffered: true });
                return performanceObserver;
            }
        }
        catch (e) {
            console.debug("[BM]", "observePerformance", e);
        }
    }

    const fcp = makeWebVitalsReporter("fcp", d, report => report.value, (transition) => {
        const pageWasNotFullyVisibleDuringTransition = [
            "hidden",
            "mixed",
        ].includes(transition.observations.pageVisibility);
        const isNotInitialTransition = !transition.isInitial;
        const isNotSupported = !isEntryTypeSupported("paint");
        return (isNotSupported ||
            pageWasNotFullyVisibleDuringTransition ||
            isNotInitialTransition);
    });

    const ttfb = makeWebVitalsReporter("ttfb", P, report => report.value, (transition) => {
        return !transition.isInitial;
    });

    function pageVisibility({ observations, }) {
        if (observations.pageVisibility === undefined) {
            return {};
        }
        return {
            pageVisibility: observations.pageVisibility,
        };
    }

    function readyForUser(transition) {
        return { readyForUser: transition.end - transition.start };
    }

    function apdexReporter(transition) {
        var apdex;
        var report = readyForUser(transition);
        var satisfiedThreshold = transition.threshold;
        var tolerableThreshold = transition.threshold * 4;
        if (report.readyForUser <= satisfiedThreshold) {
            apdex = 1;
        }
        else if (report.readyForUser <= tolerableThreshold) {
            apdex = 0.5;
        }
        else {
            apdex = 0;
        }
        return { apdex: apdex };
    }

    function badger(func, interval) {
        return new Promise(function (resolve) {
            var timer;
            function peek() {
                var result = func();
                if (result !== undefined) {
                    clearInterval(timer);
                    resolve(result);
                }
            }
            timer = setInterval(peek, interval);
            peek();
        });
    }

    const getWindow$1 = () => window;
    var window$1 = window;

    const getPerformance = () => getWindow$1().performance;

    function firstPaint(transition) {
        const performance = getPerformance();
        if (!performance) {
            return;
        }
        if (!transition.isInitial) {
            return {};
        }
        return firstPaintReady().then(function (firstPaint) {
            return { firstPaint: firstPaint };
        }, function () {
            return {};
        });
    }
    function isTopFrame() {
        return getWindow$1().top === getWindow$1().self;
    }
    function getFirstPaint() {
        const paintEntries = getPerformance().getEntriesByType("paint");
        if (paintEntries.length) {
            const firstPaint = paintEntries.find(entry => entry.name === "first-paint");
            if (firstPaint) {
                return firstPaint.startTime;
            }
            else {
                return "not supported";
            }
        }
    }
    function firstPaintReady() {
        if (isTopFrame() && "PerformancePaintTiming" in getWindow$1()) {
            return badger(getFirstPaint, 250);
        }
        else {
            return Promise.reject("The browser does not have PerformancePaintTiming metric");
        }
    }

    function isInitial(transition) {
        return { isInitial: transition.isInitial };
    }

    var storageKey = "browser-metrics-journey";
    function randomJourneyId() {
        return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function (c) {
            var r = (getWindow$1().Math.random() * 16) | 0;
            var v = c === "x" ? r : (r & 0x3) | 0x8;
            return v.toString(16);
        });
    }
    function journeyId() {
        const window = getWindow$1();
        if (typeof window.sessionStorage === "undefined") {
            return Promise.reject("sessionStorage is required to produce a report for this transition.");
        }
        if (window.sessionStorage.getItem(storageKey) === null) {
            window.sessionStorage.setItem(storageKey, randomJourneyId());
        }
        return Promise.resolve({
            journeyId: window.sessionStorage.getItem(storageKey),
        });
    }

    function key$1(transition) {
        return { key: transition.key };
    }

    function supportsNavigationTiming() {
        const window = getWindow$1();
        return (window.performance &&
            window.performance.navigation &&
            window.performance.timing &&
            typeof window.performance.timing.navigationStart !== "undefined");
    }

    function navigationType(transition) {
        var report = {};
        const window = getWindow$1();
        if (transition.isInitial && supportsNavigationTiming()) {
            report.navigationType = window.performance.navigation.type;
        }
        return report;
    }

    function redirectCount(transition) {
        var report = {};
        const window = getWindow$1();
        if (transition.isInitial) {
            if (!supportsNavigationTiming()) {
                return Promise.reject("The navigation timing API is required to produce a report for this transition.");
            }
            if (typeof window.performance.navigation.redirectCount !== "undefined") {
                report.redirectCount = window.performance.navigation.redirectCount;
            }
        }
        return Promise.resolve(report);
    }

    function absolutiseUrl(url) {
        var a = window$1.document.createElement("a");
        a.href = url;
        return a.href;
    }

    function isFunction(value) {
        return typeof value === "function";
    }

    function noop() { }
    function onResourceTimingBufferFull(callback) {
        const performance = getPerformance();
        var existingHandler = performance.onresourcetimingbufferfull || noop;
        if (isFunction(performance.addEventListener)) {
            performance.addEventListener("resourcetimingbufferfull", callback);
        }
        else {
            performance.onresourcetimingbufferfull = function () {
                callback();
                existingHandler();
            };
        }
    }

    function supportsResourceTiming() {
        const performance = getPerformance();
        return performance && isFunction(performance.getEntriesByType);
    }

    var previousBuffer = [];
    function peek() {
        return getPerformance()
            .getEntriesByType("resource")
            .filter(function (entry) {
            return entry.initiatorType !== "img";
        });
    }
    function attemptDrain() {
        const performance = getPerformance();
        if (isFunction(performance.clearResourceTimings)) {
            previousBuffer = peek();
            performance.clearResourceTimings();
        }
    }
    onResourceTimingBufferFull(attemptDrain);
    function recentResourceTiming() {
        if (!supportsResourceTiming()) {
            return [];
        }
        return previousBuffer.concat(peek());
    }

    var timingPropertyNames = "unloadEventStart,unloadEventEnd,redirectStart,redirectEnd,fetchStart,domainLookupStart,domainLookupEnd,connectStart,connectEnd,secureConnectionStart,requestStart,responseStart,responseEnd,domLoading,domInteractive,domContentLoadedEventStart,domContentLoadedEventEnd,domComplete,loadEventStart,loadEventEnd".split(",");
    function relativeTimings() {
        const timing = getPerformance().timing;
        var hasFinishedLoading = timing.loadEventEnd > 0;
        var timings = {};
        if (hasFinishedLoading) {
            timingPropertyNames.forEach(function storeRelativeValue(propertyName) {
                var value = timing[propertyName];
                var hasMeasurement = value > 0;
                if (hasMeasurement) {
                    timings[propertyName] = value - timing.navigationStart;
                }
            });
            return timings;
        }
    }
    var cachedBadger;
    function relativeNavigationTiming() {
        if (!supportsNavigationTiming()) {
            return Promise.reject("The navigation timing API is required to produce a report for this transition.");
        }
        if (typeof cachedBadger === "undefined") {
            cachedBadger = badger(relativeTimings, 250);
        }
        return cachedBadger;
    }

    function getExternalNonBlockingScriptUrls() {
        var externalScripts = window$1.document.querySelectorAll("script[src][async]");
        return Array.prototype.map.call(externalScripts, function (script) {
            return absolutiseUrl(script.src);
        });
    }
    function getInitialBlockingResourceTiming() {
        var externalNonBlockingScriptUrls = getExternalNonBlockingScriptUrls();
        function filter(relativeTimings) {
            return recentResourceTiming()
                .filter(function isResourceJsOrCss(resource) {
                return (resource.initiatorType === "link" ||
                    resource.initiatorType === "script");
            })
                .filter(function isBlockingResource(resource) {
                return (resource.responseEnd <
                    relativeTimings.domContentLoadedEventStart);
            })
                .filter(function isBlockingIfScript(resource) {
                return (resource.initiatorType !== "script" ||
                    externalNonBlockingScriptUrls.indexOf(resource.name) === -1);
            });
        }
        return relativeNavigationTiming().then(filter);
    }

    function resourceLoadedEnd(transition) {
        if (!transition.isInitial) {
            return {};
        }
        return getInitialBlockingResourceTiming().then(function makeReport(resources) {
            if (resources.length === 0) {
                return { resourceLoadedEnd: null };
            }
            var resourceLoadedEnd = resources
                .map(function toResponseEnd(resource) {
                return resource.responseEnd;
            })
                .reduce(function toMax(a, b) {
                return Math.max(a, b);
            });
            return {
                resourceLoadedEnd: resourceLoadedEnd,
            };
        });
    }

    function resourceLoadedStart(transition) {
        if (!transition.isInitial) {
            return {};
        }
        return getInitialBlockingResourceTiming().then(function makeReport(resources) {
            if (resources.length === 0) {
                return { resourceLoadedStart: null };
            }
            var startTimes = resources.map(function toStartTime(resource) {
                return resource.startTime;
            });
            var resourceLoadedStart = Math.min.apply(Math, startTimes);
            return {
                resourceLoadedStart: resourceLoadedStart,
            };
        });
    }

    var attributesToCopy = "duration,initiatorType,name".split(",");
    var attributesRelativeToTransitionStart = "startTime,connectEnd,connectStart,domainLookupEnd,domainLookupStart,fetchStart,redirectEnd,redirectStart,requestStart,responseEnd,responseStart,secureConnectionStart".split(",");
    function resourceTiming(transition) {
        if (!supportsResourceTiming()) {
            return {};
        }
        var resources = recentResourceTiming().filter(function loadedDuringTransition(entry) {
            var responseEnd = entry.responseEnd;
            return (responseEnd >= transition.start &&
                responseEnd <= transition.extendedEnd &&
                entry.startTime >= transition.start);
        });
        return {
            resourceTiming: resources.map(function (resource) {
                var resourceReport = {};
                attributesToCopy.forEach(function (attribute) {
                    resourceReport[attribute] = resource[attribute];
                });
                attributesRelativeToTransitionStart.forEach(function (attribute) {
                    resourceReport[attribute] =
                        resource[attribute] > 0
                            ? resource[attribute] - transition.start
                            : 0;
                });
                return resourceReport;
            }),
        };
    }

    function key(transition) {
        return { threshold: transition.threshold };
    }

    function timing(transition) {
        if (!transition.isInitial) {
            return {};
        }
        return relativeNavigationTiming();
    }

    function userAgent() {
        return { userAgent: getWindow$1().navigator.userAgent };
    }

    function userTiming(transition) {
        const performance = getPerformance();
        if (!performance || !isFunction(performance.getEntriesByType)) {
            return {};
        }
        var marks = performance.getEntriesByType("mark").filter(function (mark) {
            return (mark.startTime >= transition.start &&
                mark.startTime <= transition.extendedEnd);
        });
        var measures = performance
            .getEntriesByType("measure")
            .filter(function (measure) {
            return (measure.startTime >= transition.start &&
                measure.startTime + measure.duration <= transition.extendedEnd);
        });
        return {
            marks: marks.map(function (mark) {
                return {
                    name: mark.name,
                    time: mark.startTime - transition.start,
                };
            }),
            measures: measures.map(function (measure) {
                return {
                    name: measure.name,
                    startTime: measure.startTime - transition.start,
                    duration: measure.duration,
                };
            }),
        };
    }

    function entityId({ entityId, }) {
        return entityId ? { entityId: entityId } : {};
    }

    function elementTimings(transition) {
        const timingEntries = {};
        const observer = observePerformance("element", ({ startTime, identifier }) => {
            let filteredStartTime = startTime >= transition.start &&
                startTime <= transition.extendedEnd
                ? startTime
                : undefined;
            if (timingEntries.hasOwnProperty(identifier)) {
                if (timingEntries[identifier] < filteredStartTime)
                    timingEntries[identifier] = filteredStartTime;
            }
            else if (filteredStartTime)
                timingEntries[identifier] = filteredStartTime;
        });
        return new Promise(resolve => {
            setTimeout(() => {
                resolve({ elementTimings: timingEntries });
                observer === null || observer === void 0 ? void 0 : observer.disconnect();
            }, 250);
        });
    }

    function getNavigator() {
        return window.navigator;
    }

    function applyIfExist(report, property, value) {
        if (value !== undefined) {
            report[property] = value;
        }
    }
    function reportUserHardware() {
        const { deviceMemory, hardwareConcurrency } = getNavigator();
        const report = {};
        applyIfExist(report, "userDeviceMemory", deviceMemory);
        applyIfExist(report, "userDeviceProcessors", hardwareConcurrency);
        return report;
    }

    const reporters = [
        fcp,
        ttfb,
        pageVisibility,
        entityId,
        key$1,
        isInitial,
        key,
        elementTimings,
        reportUserHardware,
        apdexReporter,
        firstPaint,
        journeyId,
        navigationType,
        readyForUser,
        redirectCount,
        resourceLoadedEnd,
        resourceLoadedStart,
        resourceTiming,
        timing,
        userAgent,
        userTiming,
    ];
    function get() {
        return reporters.concat();
    }
    function add(reporter) {
        reporters.push(reporter);
    }

    var hasOwnProperty = Object.prototype.hasOwnProperty;
    function merge() {
        var obj = {};
        var source, prop;
        for (var i = 0, length = arguments.length; i < length; i++) {
            source = arguments[i];
            for (prop in source) {
                if (hasOwnProperty.call(source, prop)) {
                    obj[prop] = source[prop];
                }
            }
        }
        return obj;
    }

    function logError(error) {
        const window = getWindow$1();
        (window.console.error || window.console.log).call(window.console, error.stack || error);
    }

    function asPromise(value) {
        return Promise.all([value]).then(function (reports) {
            return reports[0];
        });
    }
    function transformRejectedPromiseToEmptyReport(report) {
        return asPromise(report).then(null, function () {
            return {};
        });
    }
    function buildReport(transition) {
        var transitionSpecificReporters = transition.reporters;
        var pendingReports = get()
            .concat(transitionSpecificReporters)
            .map(function makeReport(reporter) {
            var report;
            try {
                report = reporter(transition);
            }
            catch (e) {
                logError(e);
                report = {};
            }
            return transformRejectedPromiseToEmptyReport(report);
        });
        return Promise.all(pendingReports).then(function mergeReports(reports) {
            return merge.apply(undefined, reports);
        });
    }

    const getWindow = () => window;

    const getDocument = () => getWindow().document;

    const onPageVisibilityChange = (callback) => {
        document.addEventListener("visibilitychange", callback);
        window.addEventListener("pagehide", callback);
        return () => {
            document.removeEventListener("visibilitychange", callback);
            window.removeEventListener("pagehide", callback);
        };
    };

    const observePageVisibility = () => {
        let pageVisibility = getDocument().visibilityState;
        const unsubscribe = onPageVisibilityChange(() => {
            pageVisibility = "mixed";
        });
        const getResult = () => {
            unsubscribe();
            return pageVisibility;
        };
        return getResult;
    };

    function logEntityIdOverrides(transitionProperties, endOptions) {
        if (transitionProperties.entityId && endOptions.entityId) {
            console.debug("[BM]", `entityId "${transitionProperties.entityId}" provided in start() was overridden by "${endOptions.entityId}" provided in end()`);
        }
    }
    function resolveAfter(timeInMillis) {
        return new Promise(resolve => setTimeout(() => resolve(null), timeInMillis));
    }
    function gatherMarks(expectedMarks, transition, resolveAfterTimeout) {
        let perfObserver;
        const getLatestMarkEnd = new Promise(resolve => {
            const registeredMarks = new Set();
            let latestMarkTime = 0;
            function observerCallback(list, observer) {
                const observedMarks = list.getEntries().map(mark => ({
                    name: mark.name,
                    startTime: mark.startTime,
                }));
                observedMarks
                    .filter(observedMark => expectedMarks.includes(observedMark.name) &&
                    observedMark.startTime >= transition.start)
                    .forEach(observedMark => {
                    latestMarkTime = Math.max(latestMarkTime, observedMark.startTime);
                    registeredMarks.add(observedMark.name);
                });
                if (registeredMarks.size === expectedMarks.length) {
                    resolve(latestMarkTime);
                }
            }
            perfObserver = new PerformanceObserver(observerCallback);
            perfObserver.observe({ type: "mark", buffered: true });
        });
        Promise.race([getLatestMarkEnd, resolveAfterTimeout]).then(() => {
            perfObserver.disconnect();
        });
        return getLatestMarkEnd;
    }
    function isPerformanceObserverSupported() {
        return (typeof window.PerformanceObserverEntryList !== "undefined" &&
            typeof window.PerformanceObserverEntryList.prototype.getEntries !==
                "undefined");
    }
    const createTransitionRegistry = () => {
        const transitions = {};
        return {
            startTransition: (key, options) => {
                if (transitions[key] !== undefined) {
                    console.log("[BM]", `Transition key: "${key}" is already in use.`);
                    return false;
                }
                console.debug("[BM]", key, "Collector.startTransition", options);
                const { isInitial = false, threshold, reporters, timestamp: start, entityId, waitForMarks, timeout, } = options;
                const observers = {
                    pageVisibility: observePageVisibility(),
                };
                transitions[key] = {
                    isInitial,
                    start,
                    key,
                    threshold,
                    reporters,
                    entityId,
                    observers,
                    waitForMarks,
                    timeout,
                };
                return true;
            },
            endTransition: (key, options) => __awaiter(void 0, void 0, void 0, function* () {
                var _a;
                const pendingTransition = transitions[key];
                if (pendingTransition === undefined) {
                    throw new Error(`Transition with key: ${key} does not exist in the registry`);
                }
                console.debug("[BM]", key, "Collector.endTransition", options);
                delete transitions[key];
                const { observers, waitForMarks, timeout } = pendingTransition, transitionProperties = __rest(pendingTransition, ["observers", "waitForMarks", "timeout"]);
                const remainingTimeForMarks = timeout - (options.timestamp - pendingTransition.start);
                logEntityIdOverrides(pendingTransition, options);
                const endedTransition = Object.assign(Object.assign({}, transitionProperties), { observations: {
                        pageVisibility: observers.pageVisibility(),
                    }, end: options.timestamp, extendedEnd: options.timestamp, entityId: (_a = options.entityId) !== null && _a !== void 0 ? _a : transitionProperties.entityId });
                if (!waitForMarks ||
                    waitForMarks.length <= 0 ||
                    remainingTimeForMarks <= 0) {
                    return endedTransition;
                }
                if (!isPerformanceObserverSupported()) {
                    const waitForTime = remainingTimeForMarks / 2;
                    return resolveAfter(waitForTime).then(() => {
                        endedTransition.extendedEnd =
                            endedTransition.end + waitForTime;
                        return endedTransition;
                    });
                }
                const defaultResolveAfter = resolveAfter(remainingTimeForMarks);
                return Promise.race([
                    defaultResolveAfter,
                    gatherMarks(waitForMarks, pendingTransition, defaultResolveAfter),
                ]).then(latestMarkEndOrNull => {
                    endedTransition.extendedEnd =
                        latestMarkEndOrNull !== null && latestMarkEndOrNull !== void 0 ? latestMarkEndOrNull : endedTransition.end + remainingTimeForMarks;
                    return endedTransition;
                });
            }),
        };
    };

    function createEventHandler() {
        const subscribers = [];
        const reports = [];
        const transitionsRegistry = createTransitionRegistry();
        function storeReport(report) {
            reports.push(report);
            console.debug("[BM]", report.key, "Report stored");
            return report;
        }
        function processStoredReports(subscriber) {
            reports.forEach(function (report) {
                subscriber({ report });
            });
        }
        function notifySubscribers(report) {
            subscribers.forEach(function (subscriber) {
                subscriber({ report });
            });
            console.debug("[BM]", report.key, "Subscribers notified");
            return report;
        }
        function onStart(_a) {
            var { key } = _a, options = __rest(_a, ["key"]);
            transitionsRegistry.startTransition(key, options);
        }
        function onEnd(_a) {
            var { key } = _a, options = __rest(_a, ["key"]);
            transitionsRegistry
                .endTransition(key, options)
                .then(buildReport)
                .then(storeReport)
                .then(notifySubscribers)
                .catch(error => {
                console.log("[BM]", error.message);
            });
        }
        function onAddReporter(reporter) {
            add(reporter);
        }
        function onSubscribe(subscriber) {
            processStoredReports(subscriber);
            subscribers.push(subscriber);
        }
        return function on(event) {
            if (event.start) {
                onStart(event.start);
            }
            else if (event.end) {
                onEnd(event.end);
            }
            else if (event.addReporter) {
                onAddReporter(event.addReporter);
            }
            else if (event.subscribe) {
                onSubscribe(event.subscribe);
            }
        };
    }

    var probe = window$1["browser-metrics"];

    function install() {
        if (getPerformance()) {
            console.log("[BM]", "Collector installed");
            const eventHandler = createEventHandler();
            probe.delegateTo(eventHandler);
        }
    }

    if (w.define) {
        w.define("internal/browser-metrics-plugin/collector", () => {
            return {
                install,
            };
        });
    }
    w["browser-metrics-plugin"].install(function (done) {
        dcBrowserMetrics.addReporter(reporter);
        dcBrowserMetricsAtlassianAnalyticsBeacon.addReportMarshaller(experimentsMarshaller);
        dcBrowserMetricsAtlassianAnalyticsBeacon.addReportMarshaller(userAgentMarshaller);
        dcBrowserMetricsAtlassianAnalyticsBeacon.addUrlCleaner(cloudPerTenantCdnUrlFilter);
        dcBrowserMetricsAtlassianAnalyticsBeacon.addUrlCleaner(cloudCrossTenantCdnUrlFilter);
        dcBrowserMetricsAtlassianAnalyticsBeacon.addUrlCleaner(microsUrlFilter);
        done();
    });

})(window['browser-metrics'], window['browser-metrics-aa-beacon']);
