define('children-macro/macro-browser-overrides', [
    'jquery',
    'confluence/templates',
    'confluence-macro-browser/macro-browser',
    'confluence/api/constants',
], function ($, ConfluenceTemplates, MacroBrowser, constants) {
    'use strict';

    return {
        fields: {
            enum: {
                excerptType: function (param, options) {
                    const paramDiv = $(ConfluenceTemplates.MacroBrowser.macroParameterSelect());
                    // There's only one <select> in the template
                    const dropDowns = $('select', paramDiv);
                    if (dropDowns.length !== 1) {
                        throw new Error(
                            'Expected to find exactly one element with id "macro-param-excerptType" in the template.'
                        );
                    }
                    /** @type {HTMLSelectElement} */
                    const dropDown = dropDowns[0];

                    Array.from(param.enumValues).forEach((/** @type {string} */ excerptType) => {
                        const option = document.createElement('option');
                        option.value = excerptType;
                        option.innerText = excerptType;
                        dropDown.appendChild(option);
                    });

                    setDropDownVisibility(paramDiv);

                    return new MacroBrowser.Field(paramDiv, $(dropDown), options);
                },
            },
        },
    };

    function setDropDownVisibility(paramDiv) {
        fetch(constants.CONTEXT_PATH + '/rest/children-macro/browser/settings', {
            method: 'GET',
            headers: { 'Content-Type': 'application/json' },
        })
            .then(
                /** @type {Response} */ async (response) => {
                    if (response.ok) {
                        return response.json();
                    }
                    throw new Error('Network response was not ok.');
                }
            )
            .then(function (/** @type {{excerptGenerationDisabled: boolean}} */ body) {
                if (body.excerptGenerationDisabled === true) {
                    paramDiv[0].hidden = true;
                } else {
                    paramDiv[0].hidden = false;
                }
            })
            .catch((error) => {
                console.error('Children macro status request failed because of ' + error);
            });
    }
});

require('confluence/module-exporter').safeRequire('children-macro/macro-browser-overrides', function (overrides) {
    require('confluence-macro-browser/macro-browser').setMacroJsOverride('children', overrides);
});
