require(['ajs', 'wrm', 'document', 'confluence/api/logger', 'confluence/meta', 'confluence/api/constants', 'confluence/search-ui/analytics-support'],
    function (ajs, wrm, document, logger, meta, constants, analyticsSupport) {
        const eventsTriggeringPluginLazyLoad = ['keydown', 'input', 'click'];
        const eventsTriggeringForQuickSearchEnabled = ['click', 'focusout', 'focus'];
        var searchUI;
        var searchInput;
        var searchInputButton;
        var spinner;
        var tooltip;
        var isTooltipShown = false;
        var isLoading = false;

        function toggleIcon() {
            searchUI.classList.toggle("hide-icon");
        }

        function startLoading() {
            isLoading = true;
            toggleIcon();
            spinner.style.display = 'block';
        }

        function stopLoading() {
            isLoading = false;
            toggleIcon();
            spinner.style.display = 'none';
        }

        function unregisterHandlers() {
            eventsTriggeringPluginLazyLoad.forEach(function (event) {
                searchInput.removeEventListener(event, lazyLoadManager);
            });
            searchInputButton.removeEventListener('click', lazyLoadManagerForIcon);
            searchInputButton.removeEventListener('keydown', lazyLoadManagerForIcon);
        }

        // TODO: would be great remove those events too
        function unregisterHandlersForQuickEnabledScope() {
            eventsTriggeringForQuickSearchEnabled.forEach(function (event) {
                searchInput.removeEventListener(event, handleClickAndFocusEvent);
                searchInputButton.removeEventListener(event, handleClickAndFocusEvent);
            });
        }

        function showTooltip() {
            if (!isTooltipShown) {
                tooltip.style.display = 'block';
                isTooltipShown = true;
            }
        }

        function hideTooltip() {
            if (isTooltipShown) {
                tooltip.style.display = 'none';
                isTooltipShown = false;
            }
        }

        function handleClickAndFocusEvent(event) {
            if (event && event.type ==='focusout') {
                hideTooltip()
                return;
            }

            showTooltip();
            event.stopPropagation();
        }

        function handleInputEvent(event) {
            if (event.target.value) {
                showTooltip();
            } else {
                hideTooltip();
            }
        }

        function handleKeyDownEvent(event) {
            const ENTER_KEY_CODE = 13;
            if (event.keyCode === ENTER_KEY_CODE) {
                const searchTerm = event.target.value;
                const cql = searchTerm ? '?cql=&queryString=' + encodeURIComponent(searchTerm) : '';
                window.location.href = constants.CONTEXT_PATH + '/dosearchsite.action' + cql;
            }
        }

        function handleDocumentClick(event) {
            if (searchUI.contains(event.target)) {
                showTooltip();
            } else {
                hideTooltip();
            }
        }

        function lazyLoadManager(event) {
            if (!event) return;
            if(event.type === 'keydown' && event.keyCode !== 13) return;
            lazyLoad();
        }

        function lazyLoadManagerForIcon(event) {
            if (!event) return;
            if (event.type === 'keydown'
            && event.keyCode !== 13
            && event.keyCode !== 32) return;
            lazyLoad();
        }

        function lazyLoad() {
            if (isLoading) return;

            startLoading();
            wrm
                .require(['wrc!confluence-search-ui-plugin-main'])
                .done(function () {
                    require(['confluence-search-ui-plugin-main'], function (SearchUI) {
                        SearchUI.default.init();
                        unregisterHandlers();
                        stopLoading();
                    });
                })
                .fail(function () {
                    stopLoading();
                    logger.error('fail to load confluence-search-ui-plugin-main');
                });
        }

        ajs.toInit(function () {
            searchUI = document.getElementById('search-ui');
            // login screen doesn't have navigation search
            if (!searchUI) {
                logger.log('no search-ui element found');
                return;
            }

            analyticsSupport.init();
            searchInput = searchUI.querySelector('#quick-search-query');
            searchInputButton = searchUI.querySelector('#quick-search-query-button');
            spinner = searchUI.querySelector('aui-spinner');
            tooltip = searchUI.querySelector('[role=alert]');

            if (!meta.get('global-settings-quick-search-enabled')) {
                searchInputButton.addEventListener('keydown', handleKeyDownEvent);
                searchInput.addEventListener('keydown', handleKeyDownEvent);
                searchInput.addEventListener('input', handleInputEvent);

                eventsTriggeringForQuickSearchEnabled.forEach(function (event) {
                    searchInputButton.addEventListener(event, handleClickAndFocusEvent);
                    searchInput.addEventListener(event, handleClickAndFocusEvent);
                });

                document.addEventListener('click', handleDocumentClick);
            } else {
                eventsTriggeringPluginLazyLoad.forEach(function (event) {
                    searchInput.addEventListener(event, lazyLoadManager);
                });
                searchInputButton.addEventListener('click', lazyLoadManagerForIcon);
                searchInputButton.addEventListener('keydown', lazyLoadManagerForIcon);
            }
        });
    });
