define("confluence/softwareproject/dialog/abstract-panel-view",["jquery","underscore","ajs","backbone","confluence/softwareproject/util/config","confluence/softwareproject/util/service","confluence/softwareproject/util/select2-mixin","confluence/form-state-control"],function(E,I,G,H,C,F,D,A){var B=H.Model.extend({defaults:{selectedServer:null,isValid:false},reset:function(){I.extend(this.attributes,this.defaults)
}});
var J=H.View.extend({template:Confluence.SpaceBlueprints.SoftwareProject.Dialog,initialize:function(){this.panelId="";
this.panelTitle="";
this.view={$errorMessage:null,$servers:null};
this.servers=[];
this.on("reload.data",function(){F.resetCachingData();
this._fillServersData()
},this);
this.formData=new B();
this.listenTo(this.formData,"change:selectedServer",this._handleServerChanged)
},render:function(K){this.dialogView=K.dialog;
this.panelDialog=K.panelDialog;
if(K.$el){this.$el=K.$el
}else{this.$el=this.panelDialog.body
}this.el=this.$el[0];
this.delegateEvents();
this.listenTo(this.dialogView,"dialog.process.begin",this.onBeginInitDialog);
this.listenTo(this.dialogView,"dialog.process.finish",this.onEndInitDialog);
this.listenTo(this.dialogView,"dialog.showing.begin",this.onOpenDialog)
},initServerField:function(){this.view.$servers=this.$(".jira-servers");
this.view.$servers.on("change",this._onSelectServerChanged.bind(this));
this.setupSelect2({$el:this.view.$servers,placeholderText:G.I18n.getText("jira.server.placeholder"),isRequired:true})
},onBeginInitDialog:function(){},onEndInitDialog:function(){},onOpenDialog:function(K){this.init()
},init:function(){this._fillServersData().done(function(){this.reset()
}.bind(this))
},reset:function(){var K=this;
this.$("input[type=text]").each(function(){var L=E(this);
L.val("");
K.toggleSiblingErrorMessage(L,false)
})
},toggleEnablePanel:function(L){var K=this.$("input, area, select");
K=K.not("[name=jira-server]");
if(L){A.enableElement(K)
}else{A.disableElement(K)
}K.select2("enable",L);
if(!L){this.dialogView.toggleEnableInsertButton(false)
}},disableWholePanel:function(){var K=this.$("input, select, textarea");
this.$(".select2-container-active").removeClass("select2-container-active");
A.disableElement(K);
K.select2("enable",false);
this.dialogView.toggleEnableInsertButton(false)
},toggleSiblingErrorMessage:function(M,L,N){var K=M.siblings(".error");
if(L){M.focus();
K.removeClass("hidden").text(N)
}else{K.addClass("hidden").text("")
}},handleAjaxRequestError:function(M,L){var K=G.I18n.getText("confluence.software.jira.project.validation.cannot.connect");
if(L==="timeout"){K=G.I18n.getText("confluence.software.jira.project.validation.connection.timeout")
}var N=G.messages.error({body:K});
this.view.$errorMessage.empty().append(N).removeClass("hidden");
this.resetSelect2Options(M);
this.toggleSiblingErrorMessage(M,false);
this.dialogView.toggleEnableInsertButton(false)
},renderErrorNoAppLink:function(){var M=G.Meta.get("is-confluence-admin");
var K="";
if(M){K=G.I18n.getText("confluence.software.jira.project.noapplink.admin.message",G.contextPath())
}else{K=G.I18n.getText("confluence.software.jira.project.noapplink.user.message",G.contextPath())
}var L=G.messages.error({body:K});
this.view.$errorMessage.empty().append(L).removeClass("hidden");
this.toggleCreateButton(false)
},validateServer:function(L){var K=true;
if(L&&L.authUrl){this._renderErrorMessageUnauthentication(L);
K=false
}return K
},_renderErrorMessageUnauthentication:function(L){var N=this;
var M=(window.AppLinks&&window.AppLinks.authenticateRemoteCredentials);
var K=this.template.errorMessageOauth({forceUserToReload:!M});
this.view.$errorMessage.removeClass("hidden").append(K);
this.view.$errorMessage.find("a").click(function(P){P.preventDefault();
if(M){window.AppLinks.authenticateRemoteCredentials(L.authUrl,function(){L.authUrl=null;
if(window.AJS.Editor&&window.AJS.Editor.JiraConnector&&window.AJS.Editor.JiraConnector.servers){var Q=I.findWhere(window.AJS.Editor.JiraConnector.servers,{id:L.id});
if(Q){Q.authUrl=null
}}N.view.$errorMessage.empty().addClass("hidden");
N.trigger("reload.data")
},function(){})
}else{var O=window.open(L.authUrl,"com_atlassian_applinks_authentication");
O.opener=null
}})
},validateRequiredFields:function(K,L){var M=E.trim(K.val());
if(!M||M===C.DEFAULT_OPTION_VALUE){this.toggleSiblingErrorMessage(K,true,L);
return false
}this.toggleSiblingErrorMessage(K,false);
return true
},getUserInputData:function(){return{}
},fillDataInSelect2:function(L,K){this.toggleSelect2Loading(L,true);
K.done(function(){this.toggleSelect2Loading(L,false);
this.view.$errorMessage.empty().addClass("hidden")
}.bind(this));
K.fail(function(N,M){this.handleAjaxRequestError(L,M)
}.bind(this));
return K
},_fillServersData:function(){return this.fillDataInSelect2(this.view.$servers,F.loadJiraServers()).done(function(M){this.servers=M.servers;
this.primaryServer=M.primaryServer;
if(this.servers.length===0){this.renderErrorNoAppLink();
return 
}this.fillDataSelect2(this.view.$servers,this.servers);
if(this.servers.length===1){this.view.$servers.parent().addClass("hidden");
this.removeEmptyOptionInSelect2(this.view.$servers)
}var L=this.macroOptions&&this.macroOptions.params?this.macroOptions.params.serverId:null;
var K;
if(L){K=L
}else{if(this.primaryServer){K=this.primaryServer.id
}else{K=this.view.$servers[0].id
}}this.setSelect2Value(this.view.$servers,K)
}.bind(this))
},_handleServerChanged:function(){var L=this.formData.get("selectedServer");
if(!L){this.formData.set("isValid",false);
return 
}this.formData.set("isValid",this.validateServer(L));
var K=this.formData.get("isValid");
this.toggleEnablePanel(K);
if(!K){F.resetCachingData()
}},_onSelectServerChanged:function(){var L=this.view.$servers.val();
if(!L||L===C.DEFAULT_OPTION_VALUE){this.formData.set("isValid",false)
}else{this.formData.set("isValid",true)
}var M=I.findWhere(this.servers,{id:L});
var K=this.formData.get("selectedServer");
if(K!==null&&K.id===L){this.formData.set("isValid",this.validateServer(M));
this.toggleEnablePanel(this.formData.get("isValid"))
}this.formData.set("selectedServer",M)
}});
I.extend(J.prototype,D);
return J
});