define('confluence-inline-tasks/macro-browser-overrides', [
    'jquery',
    'ajs',
    'confluence/templates',
    'confluence-macro-browser/macro-browser',
    'confluence-inline-tasks/space-page-picker-shim',
    'confluence/meta',
] /**
 * Defines macro browser overrides for the Tasks Report macro.
 */, function ($, AJS, ConfluenceTemplates, MacroBrowser, SpacePagePicker, Meta) {
    'use strict';

    return {
        fields: {
            string: {
                // spaceAndPage parameter is defined in atlassian-plugin.xml
                spaceAndPage: function (param) {
                    var className = param.multiple
                        ? 'autocomplete-multi-space-and-page'
                        : 'autocomplete-space-and-page';
                    var $paramDiv = $(ConfluenceTemplates.MacroBrowser.macroParameter());
                    var $input = $paramDiv.find("input[type='text']");
                    // aui/i18n
                    $input
                        .addClass(className)
                        .attr('data-none-message', AJS.I18n.getText('macro.browser.smartfields.not.found'));

                    // CONF-16859 - check if mandatory params are now filled
                    if (param.required) {
                        $input.keyup(MacroBrowser.processRequiredParameters);
                    }

                    const isInserting = MacroBrowser.settings.mode === 'insert';
                    const currentPageId = Meta.get('content-id');
                    const pageIds = [];

                    // default to select current page only when inserting a new task report macro
                    const currentPage = {
                        id: currentPageId,
                        title:
                            $('#content-title').val() ||
                            AJS.I18n.getText('confluence-ui-components.space-page-picker.current-content'),
                        space: { name: Meta.get('space-name') },
                        selected: isInserting,
                    };
                    if (isInserting) {
                        pageIds.push(currentPageId);
                    }

                    $input.auiSelect2(
                        SpacePagePicker.build({
                            multiple: param.multiple,
                            orgElement: $input,
                            currentPage: currentPage,
                            pageIds: pageIds,
                            // FIXME - these options below are deprecated and should be removed once the updated
                            // SpacePagePicker is being used. They're only included because the current version
                            // of SpacePagePicker will break if they aren't supplied.
                            inputSpaceId: 'legacy-macro-param-spaces',
                            inputSpaceCatId: 'legacy-macro-param-space-cats',
                            inputPageId: 'legacy-macro-param-pages',
                        })
                    );

                    var options = {
                        setValue: function (value) {
                            SpacePagePicker.setValue(value, $input);
                        },
                    };

                    return MacroBrowser.Field($paramDiv, $input, options);
                },
            },
        },

        // Before setting values in the UI, convert storage pages/spaces params into spaceAndPage.
        beforeParamsSet: function (paramMap) {
            var str = SpacePagePicker.combineMapToString({
                page: paramMap.pages,
                space: paramMap.spaces,
            });
            if (str) {
                paramMap.spaceAndPage = str;
            }

            // No need in the UI for storage values.
            delete paramMap.pages;
            delete paramMap.spaces;

            return paramMap;
        },

        // Before storing values from the UI, convert spaceAndPage into storage pages/spaces params.
        beforeParamsRetrieved: function (paramMap) {
            var values = SpacePagePicker.splitStringToMap(paramMap.spaceAndPage);

            if (values.page.length) {
                paramMap.pages = values.page.join(',');
            }
            if (values.space.length) {
                paramMap.spaces = values.space.join(',');
            }

            // No need to persist the value used in the UI.
            delete paramMap.spaceAndPage;

            return paramMap;
        },
    };
});

require('confluence/module-exporter').safeRequire(
    'confluence-inline-tasks/macro-browser-overrides',
    function (overrides) {
        require('confluence-macro-browser/macro-browser').setMacroJsOverride('tasks-report-macro', overrides);
    }
);
