$(function ($) {
    'use strict';

    /* This is very dependant on the images used and the padding, etc */
    function isInCheckArea(e, inTable) {
        var offsetX;
        var offsetY;

        // Browsers are all over the place for mouse events. :/
        if (navigator.userAgent.indexOf('Firefox') > -1) {
            offsetX = e.pageX - e.target.offsetLeft;
            offsetY = e.pageY - e.target.offsetTop;
        } else {
            offsetX = e.offsetX;
            offsetY = e.offsetY;
        }

        if (inTable) {
            return offsetX >= 3 && offsetX <= 14 && offsetY >= 3 && offsetY <= 14;
        } else {
            return offsetX >= 3 && offsetX <= 14 && offsetY >= 6 && offsetY <= 17;
        }
    }

    // Ignores the bubbled event on any parent inline tasks
    function isActualTarget(e) {
        return e.currentTarget === e.target;
    }

    function isInTable(e) {
        return $(e.target).closest('table.confluenceTable').length > 0;
    }

    function getRestUrl(contentId, taskId) {
        return (
            ConfluenceMobile.AppData.get('confluence-context-path') +
            '/rest/inlinetasks/1/task/' +
            contentId +
            '/' +
            taskId +
            '/'
        );
    }

    $('.container').delegate('ul.inline-task-list > li[data-inline-task-id]', 'click', function (e) {
        if (isActualTarget(e) && isInCheckArea(e, isInTable(e))) {
            var $el = $(this).toggleClass('checked');
            var status = $el.hasClass('checked') ? 'CHECKED' : 'UNCHECKED';
            var taskId = $el.data('inline-task-id');
            var contentId =
                $el.closest('ul').attr('data-inline-tasks-content-id') || $('div.content').data('content-id');
            var url = getRestUrl(contentId, taskId);

            var model = {
                status: status,
                trigger: 'VIEW_PAGE',
            };

            var onFailure = function (response, statusText) {
                if (statusText === 'timeout') {
                    // CONFDEV-10030 - it's likely that the request still completes successfully despite a timeout
                    return;
                }
                $el.toggleClass('checked');
                ConfluenceMobile.genericAjaxErrorHandler(response, model, {
                    message: AJS.I18n.getText('inline-tasks.notice.unavailable.mobile'),
                    // eslint-disable-next-line no-undef
                    onRetry: send,
                });
            };

            $.ajax({
                type: 'POST',
                url: url,
                data: JSON.stringify(model),
                dataType: 'json',
                contentType: 'application/json',
                timeout: 30000,
                error: onFailure,
            });
        }
    });
});
