define('confluence-inline-tasks/util', ['jquery'], function ($) {
    'use strict';

    return {
        NODE_TYPE: {
            ELEMENT_NODE: 1,
            ATTRIBUTE_NODE: 2,
            TEXT_NODE: 3,
            CDATA_SECTION_NODE: 4,
            ENTITY_REFERENCE_NODE: 5,
            ENTITY_NODE: 6,
            PROCESSING_INSTRUCTION_NODE: 7,
            COMMENT_NODE: 8,
            DOCUMENT_NODE: 9,
            DOCUMENT_TYPE_NODE: 10,
            DOCUMENT_FRAGMENT_NODE: 11,
            NOTATION_NODE: 12,
        },

        KEY: {
            BACKSPACE: 8,
            SPACE: 32,
            PAGEUP: 33,
            PAGEDOWN: 34,
            END: 35,
            HOME: 36,
            INS: 45,
            TAB: 9,
            ENTER: 13,
            SHIFT: 16,
            CTRL: 17,
            ALT: 18,
            ESCAPE: 27,
            LEFT: 37,
            UP: 38,
            RIGHT: 39,
            DOWN: 40,
            DELETE: 46,
            META: 91, // Command key on OSX, WinKey on Windows.
        },

        /**
         * Add contenteditable=false for DOM node in Chrome, Firefox, Safari. But contenteditable=true for IEs
         * @param node
         */
        addContentEditableIfApplicable: function (node) {
            var $node = $(node);
            $node.attr({
                contenteditable: false,
                class: 'non-editable',
                //CONFDEV-22626: prevent copy partial of date lozenge
                onselectstart: 'return false;', //for IE & Webkit
            });
        },
    };
});

require('confluence/module-exporter').exportModuleAsGlobal(
    'confluence-inline-tasks/util',
    'Confluence.InlineTasks.Util'
);
