/**
 * @module confluence-editor/utils/file-types-utils
 */
define('confluence-editor/utils/file-types-utils', [], function() {
    'use strict';

    var DEFAULT_ICON = 'confluence-icon-file';

    var mimeToAUIIconMap = {};
    var extToAUIIconMap = {};

    (function() {
        // the format is: <iconfont-name>|<css-name>|<file-extensions>|<mime-types>
        // this is more space-efficient in code than an object. sorry 'bout that.
        var AUI_ICON_MAP = [
            'code|code|css,htm,html,java,js,xhtml,xml|text/css,text/html,text/javascript,text/x-java-source,text/xml',
            'doc|page|doc,docx,dot|application/msword,application/vnd.openxmlformats-officedocument.wordprocessingml.document',
            'image|image|bmp,gif,jpe,jpeg,jpg,png,tif,tiff|image/bmp,image/gif,image/jpeg,image/png,image/tiff',
            'pdf|pdf|pdf|application/pdf',
            'ppt|presentation|pot,pps,ppt,pptx|application/vnd.ms-powerpoint,application/vnd.openxmlformats-officedocument.presentationml.presentation',
            'txt|page|asc,diff,log,text,txt|text/plain',
            'video|video|avi,flv,m4a,m4v,mov,mp2,mp3,mp4,mpe,mpeg,mpega,mpg,mpga,qt,rv,wav,webm,wmv|audio/mp3,audio/mp4,audio/mpeg,audio/x-wav,video/avi,video/mp4,video/mpeg,video/quicktime,video/vnd.rn-realvideo,video/webm,video/x-flv,video/x-m4v,video/x-ms-wmv',
            'xls|spreadsheet|xlb,xls,xlsx|application/vnd.ms-excel,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
            'zip|zip|ear,jar,war,zip|application/java-archive,application/zip'
        ];
        AUI_ICON_MAP.forEach(function(row) {
            var parts = row.split('|');
            var icon = 'confluence-icon-' + parts[1];
            var extensions = parts[2].split(',');
            var mimetypes = parts[3].split(',');
            mimetypes.forEach(function(mimetype) {
                mimeToAUIIconMap[mimetype] = icon;
            });
            extensions.forEach(function(extension) {
                extToAUIIconMap[extension] = icon;
            });
        });
    }());

    return {
        getAUIIconFromMime: function(mime) {
            return mimeToAUIIconMap[mime] || DEFAULT_ICON;
        },

        getAUIIconFromExt: function(ext) {
            return extToAUIIconMap[ext] || DEFAULT_ICON;
        },

        // If it's supported and started with '/image'
        isImage: function(mime) {
            return mimeToAUIIconMap[mime] && mime.indexOf('image/') === 0;
        }
    };
});

require('confluence/module-exporter').exportModuleAsGlobal(
    'confluence-editor/utils/file-types-utils',
    'AJS.Confluence.FileTypesUtils'
);
